/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.util.HashMap;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamMessageMetadata;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.pinot.shaded.org.apache.kafka.common.header.Header;
import org.apache.pinot.shaded.org.apache.kafka.common.header.Headers;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.RowMetadata;

@FunctionalInterface
public interface KafkaMetadataExtractor {
    public static KafkaMetadataExtractor build(boolean populateMetadata) {
        return record -> {
            long recordTimestamp = record.timestamp();
            HashMap<String, String> metadataMap = new HashMap<String, String>();
            metadataMap.put("offset", String.valueOf(record.offset()));
            metadataMap.put("recordTimestamp", String.valueOf(recordTimestamp));
            if (!populateMetadata) {
                return new KafkaStreamMessageMetadata(recordTimestamp, RowMetadata.EMPTY_ROW, metadataMap);
            }
            GenericRow headerGenericRow = new GenericRow();
            Headers headers = record.headers();
            if (headers != null) {
                Header[] headersArray;
                for (Header header : headersArray = headers.toArray()) {
                    headerGenericRow.putValue(header.key(), (Object)header.value());
                }
            }
            return new KafkaStreamMessageMetadata(record.timestamp(), headerGenericRow, metadataMap);
        };
    }

    public RowMetadata extract(ConsumerRecord<?, ?> var1);
}

