/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.pinot.plugin.stream.kafka20.KafkaStreamMessage;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.MessageBatch;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

public class KafkaMessageBatch
implements MessageBatch<StreamMessage<byte[]>> {
    private final List<StreamMessage<byte[]>> _messageList;
    private final int _unfilteredMessageCount;
    private final long _lastOffset;
    private final StreamMessageMetadata _lastMessageMetadata;

    public KafkaMessageBatch(int unfilteredMessageCount, long lastOffset, List<StreamMessage<byte[]>> batch, StreamMessageMetadata lastMessageMetadata) {
        this._messageList = batch;
        this._lastOffset = lastOffset;
        this._unfilteredMessageCount = unfilteredMessageCount;
        this._lastMessageMetadata = lastMessageMetadata;
    }

    public StreamMessageMetadata getLastMessageMetadata() {
        return this._lastMessageMetadata;
    }

    public int getMessageCount() {
        return this._messageList.size();
    }

    public int getUnfilteredMessageCount() {
        return this._unfilteredMessageCount;
    }

    public StreamMessage getMessageAtIndex(int index) {
        return this._messageList.get(index);
    }

    public int getMessageOffsetAtIndex(int index) {
        return ByteBuffer.wrap((byte[])this._messageList.get(index).getValue()).arrayOffset();
    }

    public int getMessageLengthAtIndex(int index) {
        return ((byte[])this._messageList.get(index).getValue()).length;
    }

    public long getNextStreamMessageOffsetAtIndex(int index) {
        throw new UnsupportedOperationException("This method is deprecated");
    }

    public StreamPartitionMsgOffset getNextStreamPartitionMsgOffsetAtIndex(int index) {
        return new LongMsgOffset(((KafkaStreamMessage)this._messageList.get(index)).getNextOffset());
    }

    public StreamPartitionMsgOffset getOffsetOfNextBatch() {
        return new LongMsgOffset(this._lastOffset + 1L);
    }

    public RowMetadata getMetadataAtIndex(int index) {
        return this._messageList.get(index).getMetadata();
    }

    public byte[] getMessageBytesAtIndex(int index) {
        return (byte[])this._messageList.get(index).getValue();
    }

    public StreamMessage getStreamMessage(int index) {
        return this._messageList.get(index);
    }
}

