/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.zk.ControllerEpochZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CheckOp;
import kafka.zookeeper.CreateOp;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteOp;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.MultiRequest;
import kafka.zookeeper.MultiResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataOp;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZkOp;
import kafka.zookeeper.ZkOpResult;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.Nothing$;

public final class KafkaZkClient$ {
    public static KafkaZkClient$ MODULE$;

    static {
        new KafkaZkClient$();
    }

    public KafkaZkClient apply(String connectString, boolean isSecure, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String metricGroup, String metricType, Option<String> name, Option<ZKClientConfig> zkClientConfig) {
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(connectString, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, metricGroup, metricType, name, zkClientConfig);
        return new KafkaZkClient(zooKeeperClient, isSecure, time);
    }

    public String apply$default$7() {
        return "kafka.server";
    }

    public String apply$default$8() {
        return "SessionExpireListener";
    }

    public Option<String> apply$default$9() {
        return None$.MODULE$;
    }

    public Option<ZKClientConfig> apply$default$10() {
        return None$.MODULE$;
    }

    public MultiRequest kafka$zk$KafkaZkClient$$wrapRequestWithControllerEpochCheck(AsyncRequest request, int expectedControllerZkVersion) {
        MultiRequest multiRequest;
        CheckOp checkOp = new CheckOp(ControllerEpochZNode$.MODULE$.path(), expectedControllerZkVersion);
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx = createRequest.ctx();
            multiRequest = new MultiRequest(new $colon$colon<Nothing$>((Nothing$)((Object)checkOp), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new CreateOp(path, data, acl, createMode)), Nil$.MODULE$)), ctx);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx = deleteRequest.ctx();
            multiRequest = new MultiRequest(new $colon$colon<Nothing$>((Nothing$)((Object)checkOp), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new DeleteOp(path, version)), Nil$.MODULE$)), ctx);
        } else if (request instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)request;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx = setDataRequest.ctx();
            multiRequest = new MultiRequest(new $colon$colon<Nothing$>((Nothing$)((Object)checkOp), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new SetDataOp(path, data, version)), Nil$.MODULE$)), ctx);
        } else {
            throw new IllegalStateException(new StringBuilder(37).append(request).append(" does not need controller epoch check").toString());
        }
        return multiRequest;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public AsyncResponse kafka$zk$KafkaZkClient$$unwrapResponseWithControllerEpochCheck(AsyncResponse response) {
        if (!(response instanceof MultiResponse)) throw new IllegalStateException(new StringBuilder(48).append("Cannot unwrap ").append(response).append(" because it is not a MultiResponse").toString());
        MultiResponse multiResponse = (MultiResponse)response;
        KeeperException.Code resultCode = multiResponse.resultCode();
        Option<Object> ctx = multiResponse.ctx();
        Seq<ZkOpResult> zkOpResults = multiResponse.zkOpResults();
        ResponseMetadata responseMetadata = multiResponse.metadata();
        Some<Seq<ZkOpResult>> some = Seq$.MODULE$.unapplySeq(zkOpResults);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            ZkOpResult zkOpResult = (ZkOpResult)((SeqLike)some.get()).apply(0);
            ZkOpResult zkOpResult2 = (ZkOpResult)((SeqLike)some.get()).apply(1);
            if (zkOpResult != null) {
                ZkOp checkOp = zkOpResult.zkOp();
                OpResult checkOpResult = zkOpResult.rawOpResult();
                if (checkOp instanceof CheckOp) {
                    void var2_24;
                    CheckOp checkOp2 = (CheckOp)checkOp;
                    if (checkOpResult instanceof OpResult.ErrorResult) {
                        OpResult.ErrorResult errorResult = (OpResult.ErrorResult)checkOpResult;
                        if (checkOp2.path().equals(ControllerEpochZNode$.MODULE$.path())) {
                            KeeperException.Code errorCode;
                            KeeperException.Code code = errorCode = KeeperException.Code.get(errorResult.getErr());
                            KeeperException.Code code2 = KeeperException.Code.BADVERSION;
                            if (code == null) {
                                if (code2 == null) throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp2.version()).toString());
                            } else if (code.equals(code2)) {
                                throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp2.version()).toString());
                            }
                            KeeperException.Code code3 = errorCode;
                            KeeperException.Code code4 = KeeperException.Code.OK;
                            if (code3 == null ? code4 != null : !code3.equals(code4)) {
                                throw KeeperException.create(errorCode, checkOp2.path());
                            }
                        }
                    }
                    OpResult rawOpResult = zkOpResult2.rawOpResult();
                    ZkOp zkOp = zkOpResult2.zkOp();
                    if (zkOp instanceof CreateOp) {
                        CreateOp createOp = (CreateOp)zkOp;
                        String string = rawOpResult instanceof OpResult.CreateResult ? ((OpResult.CreateResult)rawOpResult).getPath() : null;
                        CreateResponse createResponse = new CreateResponse(resultCode, createOp.path(), ctx, string, responseMetadata);
                        return var2_24;
                    }
                    if (zkOp instanceof DeleteOp) {
                        DeleteOp deleteOp = (DeleteOp)zkOp;
                        DeleteResponse deleteResponse = new DeleteResponse(resultCode, deleteOp.path(), ctx, responseMetadata);
                        return var2_24;
                    }
                    if (!(zkOp instanceof SetDataOp)) throw new IllegalStateException(new StringBuilder(17).append("Unexpected zkOp: ").append(zkOp).toString());
                    SetDataOp setDataOp = (SetDataOp)zkOp;
                    Stat stat = rawOpResult instanceof OpResult.SetDataResult ? ((OpResult.SetDataResult)rawOpResult).getStat() : null;
                    SetDataResponse setDataResponse = new SetDataResponse(resultCode, setDataOp.path(), ctx, stat, responseMetadata);
                    return var2_24;
                }
            }
        }
        if (zkOpResults != null) throw new IllegalStateException(new StringBuilder(86).append("Cannot unwrap ").append(response).append(" because the first zookeeper op is not check op in original MultiRequest").toString());
        throw KeeperException.create(resultCode);
    }

    private KafkaZkClient$() {
        MODULE$ = this;
    }
}

