/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.Throttler$;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!i\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0011\u0004!\u0019!C\u0005K\"1a\u000e\u0001Q\u0001\n\u0019Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004}\u0001\u0001\u0006I!\u001d\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u0019y\b\u0001)A\u0005u!A\u0011\u0011\u0001\u0001A\u0002\u0013%a\u0010C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0003\u0001!B\u0013Q\u0004\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\u0002C\u0004\u0002\u001e\u0001\u0001\u000b\u0015\u0002\u001c\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u001d9\u0011qF\u0010\t\u0002\u0005EbA\u0002\u0010 \u0011\u0003\t\u0019\u0004\u0003\u0004\\-\u0011\u0005\u0011Q\u0007\u0005\b\u0003o1B\u0011AA\u001d\u0011%\t)EFI\u0001\n\u0003\t9\u0005C\u0005\u0002^Y\t\n\u0011\"\u0001\u0002`!I\u00111\r\f\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003S2\u0012\u0013!C\u0001\u0003KB\u0011\"a\u001b\u0017#\u0003%\t!!\u001c\u0003\u0013QC'o\u001c;uY\u0016\u0014(B\u0001\u0011\"\u0003\u0015)H/\u001b7t\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0015Zs\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011aH\u0005\u0003]}\u0011q\u0001T8hO&tw\r\u0005\u00021g5\t\u0011G\u0003\u00023C\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\u001b2\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0012I\u0016\u001c\u0018N]3e%\u0006$X\rU3s'\u0016\u001c\u0007C\u0001\u00148\u0013\tAtE\u0001\u0004E_V\u0014G.Z\u0001\u0010G\",7m[%oi\u0016\u0014h/\u00197NgB\u0011aeO\u0005\u0003y\u001d\u0012A\u0001T8oO\u0006aA\u000f\u001b:piRdW\rR8x]B\u0011aeP\u0005\u0003\u0001\u001e\u0012qAQ8pY\u0016\fg.\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\"a\u0011&\u000f\u0005\u0011C\u0005CA#(\u001b\u00051%BA$$\u0003\u0019a$o\\8u}%\u0011\u0011jJ\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002JO\u0005)QO\\5ug\u0006!A/[7f!\t\u0001\u0016,D\u0001R\u0015\t\u0001#K\u0003\u0002T)\u000611m\\7n_:T!AI+\u000b\u0005Y;\u0016AB1qC\u000eDWMC\u0001Y\u0003\ry'oZ\u0005\u00035F\u0013A\u0001V5nK\u00061A(\u001b8jiz\"r!\u00180`A\u0006\u00147\r\u0005\u0002-\u0001!)Qg\u0002a\u0001m!9\u0011h\u0002I\u0001\u0002\u0004Q\u0004bB\u001f\b!\u0003\u0005\rA\u0010\u0005\b\u0003\u001e\u0001\n\u00111\u0001C\u0011\u001diu\u0001%AA\u0002\tCqAT\u0004\u0011\u0002\u0003\u0007q*\u0001\u0003m_\u000e\\W#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nQ!\\3uKJ,\u0012!\u001d\t\u0003ejl\u0011a\u001d\u0006\u0003iV\fAaY8sK*\u0011!G\u001e\u0006\u0003ob\fa!_1n[\u0016\u0014(\"A=\u0002\u0007\r|W.\u0003\u0002|g\n)Q*\u001a;fe\u00061Q.\u001a;fe\u0002\nqb\u00195fG.Le\u000e^3sm\u0006dgj]\u000b\u0002u\u0005\u00012\r[3dW&sG/\u001a:wC2t5\u000fI\u0001\u000ea\u0016\u0014\u0018n\u001c3Ti\u0006\u0014HOT:\u0002#A,'/[8e'R\f'\u000f\u001e(t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00055\u0001c\u0001\u0014\u0002\n%\u0019\u00111B\u0014\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001fy\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002\u001dA,'/[8e'R\f'\u000f\u001e(tA\u0005iqNY:feZ,GmU8GCJ,\u0012AN\u0001\u0012_\n\u001cXM\u001d<fIN{g)\u0019:`I\u0015\fH\u0003BA\u0004\u00037A\u0001\"a\u0004\u0013\u0003\u0003\u0005\rAN\u0001\u000f_\n\u001cXM\u001d<fIN{g)\u0019:!\u00035i\u0017-\u001f2f)\"\u0014x\u000e\u001e;mKR!\u0011qAA\u0012\u0011\u0019\t)\u0003\u0006a\u0001m\u0005AqNY:feZ,G\rK\u0002\u0001\u0003S\u00012\u0001LA\u0016\u0013\r\tic\b\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0017!\u0003+ie>$H\u000f\\3s!\tacc\u0005\u0002\u0017KQ\u0011\u0011\u0011G\u0001\u0005[\u0006Lg\u000e\u0006\u0003\u0002\b\u0005m\u0002bBA\u001f1\u0001\u0007\u0011qH\u0001\u0005CJ<7\u000f\u0005\u0003'\u0003\u0003\u0012\u0015bAA\"O\t)\u0011I\u001d:bs\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u0013+\u0007i\nYe\u000b\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013!C;oG\",7m[3e\u0015\r\t9fJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA.\u0003#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\r\u0016\u0004}\u0005-\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002h)\u001a!)a\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u000e\u0016\u0004\u001f\u0006-\u0003")
public class Throttler
implements KafkaMetricsGroup {
    private final double desiredRatePerSec;
    private final boolean throttleDown;
    private final Time time;
    private final Object lock;
    private final Meter meter;
    private final long checkIntervalNs;
    private long periodStartNs;
    private double observedSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return Throttler$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return Throttler$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return Throttler$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return Throttler$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return Throttler$.MODULE$.$lessinit$greater$default$2();
    }

    public static void main(String[] stringArray) {
        Throttler$.MODULE$.main(stringArray);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private Meter meter() {
        return this.meter;
    }

    private long checkIntervalNs() {
        return this.checkIntervalNs;
    }

    private long periodStartNs() {
        return this.periodStartNs;
    }

    private void periodStartNs_$eq(long x$1) {
        this.periodStartNs = x$1;
    }

    private double observedSoFar() {
        return this.observedSoFar;
    }

    private void observedSoFar_$eq(double x$1) {
        this.observedSoFar = x$1;
    }

    public void maybeThrottle(double observed) {
        long msPerSec = TimeUnit.SECONDS.toMillis(1L);
        long nsPerSec = TimeUnit.SECONDS.toNanos(1L);
        this.meter().mark((long)observed);
        Object object = this.lock();
        synchronized (object) {
            this.observedSoFar_$eq(this.observedSoFar() + observed);
            long elapsedNs = this.time.nanoseconds() - this.periodStartNs();
            if (elapsedNs > this.checkIntervalNs() && this.observedSoFar() > 0.0) {
                double rateInSecs = this.observedSoFar() * (double)nsPerSec / (double)elapsedNs;
                if (!(this.throttleDown ^ rateInSecs > this.desiredRatePerSec)) {
                    double desiredRateMs = this.desiredRatePerSec / (double)msPerSec;
                    long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsedNs);
                    long sleepTime = package$.MODULE$.round(this.observedSoFar() / desiredRateMs - (double)elapsedMs);
                    if (sleepTime > 0L) {
                        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Natural rate is %f per second but desired rate is %f, sleeping for %d ms to compensate.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(rateInSecs), BoxesRunTime.boxToDouble($this.desiredRatePerSec), BoxesRunTime.boxToLong(sleepTime)})));
                        this.time.sleep(sleepTime);
                    }
                }
                this.periodStartNs_$eq(this.time.nanoseconds());
                this.observedSoFar_$eq(0.0);
            }
            return;
        }
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, String metricName, String units, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.throttleDown = throttleDown;
        this.time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.lock = new Object();
        this.meter = this.newMeter(metricName, units, TimeUnit.SECONDS, this.newMeter$default$4());
        this.checkIntervalNs = TimeUnit.MILLISECONDS.toNanos(checkIntervalMs);
        this.periodStartNs = time.nanoseconds();
        this.observedSoFar = 0.0;
    }
}

