/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import org.apache.pinot.shaded.org.apache.kafka.clients.ClientResponse;
import org.apache.pinot.shaded.org.apache.kafka.clients.KafkaClient;
import org.apache.pinot.shaded.org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.pinot.shaded.org.apache.kafka.common.Node;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.AuthenticationException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000b\u0016\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"Q\u0011!)\u0006A!A!\u0002\u00131\u0006\"\u0002.\u0001\t\u0003Y\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007g\u0002\u0001\u000b\u0011\u00024\t\u000fQ\u0004!\u0019!C\u0005k\"9\u0011\u0011\u0001\u0001!\u0002\u00131\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002.\u0001!\t%a\f\t\u0011\u0005%\u0003\u0001\"\u0001\u0016\u0003\u0017Bq!!\u0018\u0001\t\u0003\nyFA\u0010Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014(+Z9vKN$H\u000b\u001b:fC\u0012T!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ!AH\f\u0002\r\r|W.\\8o\u0013\t\u0001SDA\u000bJ]R,'O\u0011:pW\u0016\u00148+\u001a8e)\"\u0014X-\u00193\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u!\t\u00193&D\u0001%\u0015\t)c%A\u0004dY&,g\u000e^:\u000b\u0005a9#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0013\u0003\u0017-\u000bgm[1DY&,g\u000e^\u0001\u0010[\u0016$\u0018\rZ1uCV\u0003H-\u0019;feB\u00111eL\u0005\u0003a\u0011\u0012Q#T1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'/\u0001\fd_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s!\t\u0019D'D\u0001\u0016\u0013\t)TC\u0001\fD_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3s\u0003\u0019\u0019wN\u001c4jOB\u00111\u0007O\u0005\u0003sU\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006!A/[7f!\ta\u0004)D\u0001>\u0015\tqt(A\u0003vi&d7O\u0003\u0002\u001fM%\u0011\u0011)\u0010\u0002\u0005)&lW-\u0001\u0006uQJ,\u0017\r\u001a(b[\u0016\u0004\"\u0001R'\u000f\u0005\u0015[\u0005C\u0001$J\u001b\u00059%B\u0001%\u001a\u0003\u0019a$o\\8u})\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\u00061\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\ta\u0015*\u0003\u0002R%\u0006!a.Y7f\u0013\t\u0019FK\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$'B\u0001 \u0018\u00039\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\"a\u0016-\u000e\u0003%K!!W%\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011qkfl\u00181bE\u000e\u0004\"a\r\u0001\t\u000b\u0005B\u0001\u0019\u0001\u0012\t\u000b5B\u0001\u0019\u0001\u0018\t\u000bEB\u0001\u0019\u0001\u001a\t\u000bYB\u0001\u0019A\u001c\t\u000biB\u0001\u0019A\u001e\t\u000b\tC\u0001\u0019A\"\t\u000bUC\u0001\u0019\u0001,\u0002\u0019I,\u0017/^3tiF+X-^3\u0016\u0003\u0019\u00042a\u001a8q\u001b\u0005A'BA5k\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003W2\fA!\u001e;jY*\tQ.\u0001\u0003kCZ\f\u0017BA8i\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e$U-];f!\t\u0019\u0014/\u0003\u0002s+\tY\"I]8lKJ$vnQ8oiJ|G\u000e\\3s#V,W/Z%uK6\fQB]3rk\u0016\u001cH/U;fk\u0016\u0004\u0013\u0001E1di&4XmQ8oiJ|G\u000e\\3s+\u00051\bcA<{y6\t\u0001P\u0003\u0002zQ\u00061\u0011\r^8nS\u000eL!a\u001f=\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"! @\u000e\u0003}J!a` \u0003\t9{G-Z\u0001\u0012C\u000e$\u0018N^3D_:$(o\u001c7mKJ\u0004\u0013aF1di&4XmQ8oiJ|G\u000e\\3s\u0003\u0012$'/Z:t)\t\t9\u0001\u0005\u0003X\u0003\u0013a\u0018bAA\u0006\u0013\n1q\n\u001d;j_:\fq#\u001e9eCR,7i\u001c8ue>dG.\u001a:BI\u0012\u0014Xm]:\u0015\t\u0005E\u0011q\u0003\t\u0004/\u0006M\u0011bAA\u000b\u0013\n!QK\\5u\u0011\u0019\tIB\u0004a\u0001y\u0006\u0019b.Z<BGRLg/Z\"p]R\u0014x\u000e\u001c7fe\u00069QM\\9vKV,G\u0003BA\t\u0003?Aa!!\t\u0010\u0001\u0004\u0001\u0018a\u0002:fcV,7\u000f^\u0001\ncV,W/Z*ju\u0016,\"!a\n\u0011\u0007]\u000bI#C\u0002\u0002,%\u00131!\u00138u\u0003A9WM\\3sCR,'+Z9vKN$8\u000f\u0006\u0002\u00022A1\u00111GA\u001f\u0003\u0007rA!!\u000e\u0002:9\u0019a)a\u000e\n\u0003)K1!a\u000fJ\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0010\u0002B\tA\u0011\n^3sC\ndWMC\u0002\u0002<%\u00032\u0001HA#\u0013\r\t9%\b\u0002\u001c%\u0016\fX/Z:u\u0003:$7i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0002\u001d!\fg\u000e\u001a7f%\u0016\u001c\bo\u001c8tKR!\u0011QJA-)\u0011\t\t\"a\u0014\t\u000f\u0005E#\u00031\u0001\u0002T\u0005A!/Z:q_:\u001cX\rE\u0002$\u0003+J1!a\u0016%\u00059\u0019E.[3oiJ+7\u000f]8og\u0016Da!a\u0017\u0013\u0001\u0004\u0001\u0018!C9vKV,\u0017\n^3n\u0003\u0019!wnV8sWR\u0011\u0011\u0011\u0003")
public class BrokerToControllerRequestThread
extends InterBrokerSendThread {
    private final KafkaClient networkClient;
    private final ManualMetadataUpdater metadataUpdater;
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final long retryTimeoutMs;
    private final LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue;
    private final AtomicReference<Node> activeController;

    private LinkedBlockingDeque<BrokerToControllerQueueItem> requestQueue() {
        return this.requestQueue;
    }

    private AtomicReference<Node> activeController() {
        return this.activeController;
    }

    public Option<Node> activeControllerAddress() {
        return Option$.MODULE$.apply(this.activeController().get());
    }

    private void updateControllerAddress(Node newActiveController) {
        this.activeController().set(newActiveController);
    }

    public void enqueue(BrokerToControllerQueueItem request) {
        this.requestQueue().add(request);
        if (this.activeControllerAddress().isDefined()) {
            this.wakeup();
        }
    }

    public int queueSize() {
        return this.requestQueue().size();
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        Iterator<BrokerToControllerQueueItem> requestIter = this.requestQueue().iterator();
        while (requestIter.hasNext()) {
            BrokerToControllerQueueItem request = requestIter.next();
            if (currentTimeMs - request.createdTimeMs() >= this.retryTimeoutMs) {
                requestIter.remove();
                request.callback().onTimeout();
                continue;
            }
            Option<Node> controllerAddress = this.activeControllerAddress();
            if (!controllerAddress.isDefined()) continue;
            requestIter.remove();
            return Option$.MODULE$.option2Iterable(new Some<RequestAndCompletionHandler>(new RequestAndCompletionHandler(this.time.milliseconds(), controllerAddress.get(), request.request(), response -> this.handleResponse(request, response))));
        }
        return Option$.MODULE$.option2Iterable(None$.MODULE$);
    }

    public void handleResponse(BrokerToControllerQueueItem queueItem, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Request ").append(queueItem.request()).append(" failed due to authentication error with controller").toString(), (Function0<Throwable>)(Function0<AuthenticationException> & Serializable & scala.Serializable)() -> response.authenticationException());
            queueItem.callback().onComplete(response);
            return;
        }
        if (response.versionMismatch() != null) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Request ").append(queueItem.request()).append(" failed due to unsupported version error").toString(), (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable & scala.Serializable)() -> response.versionMismatch());
            queueItem.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected()) {
            this.updateControllerAddress(null);
            this.requestQueue().putFirst(queueItem);
            return;
        }
        if (response.responseBody().errorCounts().containsKey((Object)Errors.NOT_CONTROLLER)) {
            this.activeControllerAddress().foreach((Function1<Node, Object> & Serializable & scala.Serializable)controllerAddress -> {
                BrokerToControllerRequestThread.$anonfun$handleResponse$5(this, controllerAddress);
                return BoxedUnit.UNIT;
            });
            this.requestQueue().putFirst(queueItem);
            return;
        }
        queueItem.callback().onComplete(response);
    }

    @Override
    public void doWork() {
        if (this.activeControllerAddress().isDefined()) {
            super.pollOnce(Long.MAX_VALUE);
            return;
        }
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> "Controller isn't cached, looking for local metadata changes");
        Option<Node> option = this.controllerNodeProvider.get();
        if (option instanceof Some) {
            Node controllerNode = (Node)((Some)option).value();
            this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Recorded new controller, from now on will use broker ").append(controllerNode).toString());
            this.updateControllerAddress(controllerNode);
            this.metadataUpdater.setNodes(CollectionConverters$.MODULE$.seqAsJavaListConverter(new $colon$colon<Nothing$>((Nothing$)((Object)controllerNode), Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> "No controller defined in metadata cache, retrying after backoff");
            super.pollOnce(100L);
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$handleResponse$5(BrokerToControllerRequestThread $this, Node controllerAddress) {
        $this.networkClient.disconnect(controllerAddress.idString());
        $this.updateControllerAddress(null);
    }

    public BrokerToControllerRequestThread(KafkaClient networkClient, ManualMetadataUpdater metadataUpdater, ControllerNodeProvider controllerNodeProvider, KafkaConfig config, Time time, String threadName, long retryTimeoutMs) {
        this.networkClient = networkClient;
        this.metadataUpdater = metadataUpdater;
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.retryTimeoutMs = retryTimeoutMs;
        super(threadName, networkClient, config.controllerSocketTimeoutMs(), time, false);
        this.requestQueue = new LinkedBlockingDeque();
        this.activeController = new AtomicReference<Object>(null);
    }
}

