/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerQueueItem;
import kafka.server.BrokerToControllerRequestThread;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.clients.ApiVersions;
import org.apache.pinot.shaded.org.apache.kafka.clients.ClientDnsLookup;
import org.apache.pinot.shaded.org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.pinot.shaded.org.apache.kafka.clients.NetworkClient;
import org.apache.pinot.shaded.org.apache.kafka.clients.NodeApiVersions;
import org.apache.pinot.shaded.org.apache.kafka.common.Node;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selectable;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selector;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.security.JaasContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\r\u001a\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011i\u0003!\u0011!Q\u0001\nmCQA\u0018\u0001\u0005\u0002}Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u00191\b\u0001)A\u0005a\"9q\u000f\u0001b\u0001\n\u0013A\bB\u0002?\u0001A\u0003%\u0011\u0010C\u0004~\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001)A\u0005\u007f\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u000f\u0001\u0011\u0005\u0011Q\u0003\u0005\t\u0003?\u0001A\u0011A\r\u0002\n!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA0\u0001\u0011\u0005\u0011\u0011\r\u0002%\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/S7qY*\u0011!dG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003q\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001?\u0015J\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t\u0011$\u0003\u0002)3\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\tQS&D\u0001,\u0015\ta3$A\u0003vi&d7/\u0003\u0002/W\t9Aj\\4hS:<\u0017AF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0011\u0005\u0019\n\u0014B\u0001\u001a\u001a\u0005Y\u0019uN\u001c;s_2dWM\u001d(pI\u0016\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"!\u000e \u000e\u0003YR!\u0001L\u001c\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u001du)\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tydG\u0001\u0003US6,\u0017aB7fiJL7m\u001d\t\u0003\u0005\u0012k\u0011a\u0011\u0006\u0003\u0001^J!!R\"\u0003\u000f5+GO]5dg\u000611m\u001c8gS\u001e\u0004\"A\n%\n\u0005%K\"aC&bM.\f7i\u001c8gS\u001e\f1b\u00195b]:,GNT1nKB\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u0011\u000e\u0003=S!\u0001U\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*\"\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002!1.K!!W\u0011\u0003\r=\u0003H/[8o\u00039\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\"\u0001\t/\n\u0005u\u000b#\u0001\u0002'p]\u001e\fa\u0001P5oSRtD\u0003\u00031bE\u000e$WMZ4\u0011\u0005\u0019\u0002\u0001\"B\u0018\t\u0001\u0004\u0001\u0004\"B\u001a\t\u0001\u0004!\u0004\"\u0002!\t\u0001\u0004\t\u0005\"\u0002$\t\u0001\u00049\u0005\"\u0002&\t\u0001\u0004Y\u0005\"\u0002,\t\u0001\u00049\u0006\"\u0002.\t\u0001\u0004Y\u0016A\u00037pO\u000e{g\u000e^3yiV\t!\u000e\u0005\u00026W&\u0011AN\u000e\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\nQ#\\1ok\u0006dW*\u001a;bI\u0006$\u0018-\u00169eCR,'/F\u0001q!\t\tH/D\u0001s\u0015\t\u0019\u0018(A\u0004dY&,g\u000e^:\n\u0005U\u0014(!F'b]V\fG.T3uC\u0012\fG/Y+qI\u0006$XM]\u0001\u0017[\u0006tW/\u00197NKR\fG-\u0019;b+B$\u0017\r^3sA\u0005Y\u0011\r]5WKJ\u001c\u0018n\u001c8t+\u0005I\bCA9{\u0013\tY(OA\u0006Ba&4VM]:j_:\u001c\u0018\u0001D1qSZ+'o]5p]N\u0004\u0013AF2veJ,g\u000e\u001e(pI\u0016\f\u0005/\u001b,feNLwN\\:\u0016\u0003}\u00042!]A\u0001\u0013\r\t\u0019A\u001d\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u000692-\u001e:sK:$hj\u001c3f\u0003BLg+\u001a:tS>t7\u000fI\u0001\u000ee\u0016\fX/Z:u)\"\u0014X-\u00193\u0016\u0005\u0005-\u0001c\u0001\u0014\u0002\u000e%\u0019\u0011qB\r\u0003?\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM\u001d*fcV,7\u000f\u001e+ie\u0016\fG-\u0001\bsKF,Xm\u001d;UQJ,\u0017\r\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005]\u0001c\u0001\u0011\u0002\u001a%\u0019\u00111D\u0011\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006\u0001b.Z<SKF,Xm\u001d;UQJ,\u0017\rZ\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0018\u0005\u0015\u0012Q\u000b\u0005\b\u0003O1\u0002\u0019AA\u0015\u0003\u001d\u0011X-];fgR\u0004D!a\u000b\u0002DA1\u0011QFA\u001d\u0003\u007fqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0012\u0011G\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!\u00111HA\u001f\u0005\u001d\u0011U/\u001b7eKJTA!a\u000e\u00022A!\u0011\u0011IA\"\u0019\u0001!A\"!\u0012\u0002&\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00121a\u0018\u00133#\u0011\tI%a\u0014\u0011\u0007\u0001\nY%C\u0002\u0002N\u0005\u0012qAT8uQ&tw\r\u0005\u0003\u00020\u0005E\u0013\u0002BA*\u0003c\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003/2\u0002\u0019AA-\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007c\u0001\u0014\u0002\\%\u0019\u0011QL\r\u0003E\r{g\u000e\u001e:pY2,'OU3rk\u0016\u001cHoQ8na2,G/[8o\u0011\u0006tG\r\\3s\u0003U\u0019wN\u001c;s_2dWM]!qSZ+'o]5p]N$\"!a\u0019\u0011\u0007\u0001Bv\u0010")
public class BrokerToControllerChannelManagerImpl
implements BrokerToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final Option<String> threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final NodeApiVersions currentNodeApiVersions;
    private final BrokerToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private NodeApiVersions currentNodeApiVersions() {
        return this.currentNodeApiVersions;
    }

    private BrokerToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    @Override
    public void start() {
        this.requestThread().start();
    }

    @Override
    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Broker to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public BrokerToControllerRequestThread newRequestThread() {
        String string;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(this.controllerNodeProvider.securityProtocol(), JaasContext.Type.SERVER, this.config, this.controllerNodeProvider.listenerName(), this.controllerNodeProvider.saslMechanism(), this.time, this.config.saslInterBrokerHandshakeRequestEnable(), this.logContext());
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("BrokerId"), Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        NetworkClient networkClient = new NetworkClient((Selectable)selector, this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), ClientDnsLookup.USE_ALL_DNS_IPS, this.time, true, this.apiVersions(), this.logContext());
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(33).append("broker-").append(this.config.brokerId()).append("-to-controller-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(34).append(name).append(":broker-").append(this.config.brokerId()).append("-to-controller-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        return new BrokerToControllerRequestThread(networkClient, this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, string, this.retryTimeoutMs);
    }

    @Override
    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new BrokerToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    @Override
    public Option<NodeApiVersions> controllerApiVersions() {
        return this.requestThread().activeControllerAddress().flatMap((Function1<Node, Option> & Serializable & scala.Serializable)activeController -> {
            if (activeController.id() == $this.config.brokerId()) {
                return new Some<NodeApiVersions>(this.currentNodeApiVersions());
            }
            return Option$.MODULE$.apply(this.apiVersions().get(activeController.idString()));
        });
    }

    public BrokerToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, Option<String> threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(24).append("[broker-").append(config.brokerId()).append("-to-controller] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.currentNodeApiVersions = NodeApiVersions.create();
        this.requestThread = this.newRequestThread();
    }
}

