/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import kafka.security.auth.Acl;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import org.apache.pinot.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.pinot.shaded.org.apache.kafka.common.acl.AclBinding;
import org.apache.pinot.shaded.org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.pinot.shaded.org.apache.kafka.common.resource.ResourcePattern;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.SecurityUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AuthorizerWrapper$ {
    public static AuthorizerWrapper$ MODULE$;

    static {
        new AuthorizerWrapper$();
    }

    public Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        Right<ApiError, Tuple2<Resource, Acl>> right;
        Try try_ = Try$.MODULE$.apply((Function0<ResourceType> & Serializable & scala.Serializable)() -> ResourceType$.MODULE$.fromJava(filter.patternFilter().resourceType())).flatMap((Function1<ResourceType, Try> & Serializable & scala.Serializable)resourceType -> Try$.MODULE$.apply((Function0<KafkaPrincipal> & Serializable & scala.Serializable)() -> SecurityUtils.parseKafkaPrincipal(filter.entryFilter().principal())).flatMap((Function1<KafkaPrincipal, Try> & Serializable & scala.Serializable)principal -> Try$.MODULE$.apply((Function0<Operation> & Serializable & scala.Serializable)() -> Operation$.MODULE$.fromJava(filter.entryFilter().operation())).flatMap((Function1<Operation, Try> & Serializable & scala.Serializable)operation -> Try$.MODULE$.apply((Function0<PermissionType> & Serializable & scala.Serializable)() -> PermissionType$.MODULE$.fromJava(filter.entryFilter().permissionType())).map((Function1<PermissionType, Tuple3> & Serializable & scala.Serializable)permissionType -> {
            Resource resource = new Resource((ResourceType)resourceType, filter.patternFilter().name(), filter.patternFilter().patternType());
            Acl acl = new Acl((KafkaPrincipal)principal, (PermissionType)permissionType, filter.entryFilter().host(), (Operation)operation);
            return new Tuple3<PermissionType, Resource, Acl>((PermissionType)permissionType, resource, acl);
        }).map((Function1<Tuple3, Tuple2> & Serializable & scala.Serializable)x$1 -> {
            if (x$1 == null) {
                throw new MatchError((Object)null);
            }
            Resource resource = (Resource)x$1._2();
            Acl acl = (Acl)x$1._3();
            Tuple2<Resource, Acl> tuple2 = new Tuple2<Resource, Acl>(resource, acl);
            return tuple2;
        }))));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            right = package$.MODULE$.Left().apply(new ApiError(Errors.INVALID_REQUEST, throwable.getMessage()));
        } else if (try_ instanceof Success) {
            Tuple2 s = (Tuple2)((Success)try_).value();
            right = package$.MODULE$.Right().apply(s);
        } else {
            throw new MatchError(try_);
        }
        return right;
    }

    public AclBinding convertToAclBinding(Resource resource, Acl acl) {
        ResourcePattern resourcePattern = new ResourcePattern(resource.resourceType().toJava(), resource.name(), resource.patternType());
        return new AclBinding(resourcePattern, this.convertToAccessControlEntry(acl));
    }

    public AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava());
    }

    public Acl convertToAcl(AccessControlEntry ace) {
        return new Acl(SecurityUtils.parseKafkaPrincipal(ace.principal()), PermissionType$.MODULE$.fromJava(ace.permissionType()), ace.host(), Operation$.MODULE$.fromJava(ace.operation()));
    }

    public Resource convertToResource(ResourcePattern resourcePattern) {
        return new Resource(ResourceType$.MODULE$.fromJava(resourcePattern.resourceType()), resourcePattern.name(), resourcePattern.patternType());
    }

    private AuthorizerWrapper$() {
        MODULE$ = this;
    }
}

