/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.Log$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.pinot.shaded.org.apache.kafka.clients.ApiVersions;
import org.apache.pinot.shaded.org.apache.kafka.clients.ClientDnsLookup;
import org.apache.pinot.shaded.org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.pinot.shaded.org.apache.kafka.clients.NetworkClient;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selectable;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selector;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.RequestHeader;
import org.apache.pinot.shaded.org.apache.kafka.common.security.JaasContext;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.raft.FileBasedStateStore;
import org.apache.pinot.shaded.org.apache.kafka.raft.KafkaRaftClient;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftClient;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftConfig;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftRequest;
import org.apache.pinot.shaded.org.apache.kafka.raft.RecordSerde;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=v!B\u001a5\u0011\u0003Id!B\u001e5\u0011\u0003a\u0004\"B\"\u0002\t\u0003!e\u0001B#\u0002\u0001\u0019C\u0001\"T\u0002\u0003\u0002\u0003\u0006IA\u0014\u0005\tI\u000e\u0011\t\u0011)A\u0005K\")1i\u0001C\u0001a\")\u0011p\u0001C!u\")ap\u0001C!\u007f\"9\u0011qA\u0002\u0005B\u0005%\u0001bBA\u0006\u0003\u0011%\u0011Q\u0002\u0004\u0006wQ\u0002\u0011q\u0005\u0005\u000b\u0003{Y!\u0011!Q\u0001\n\u0005}\u0002BCA&\u0017\t\u0005\t\u0015!\u0003\u0002N!Q\u00111K\u0006\u0003\u0002\u0003\u0006I!!\u0016\t\u0015\u0005m3B!A!\u0002\u0013\ti\u0006\u0003\u0006\u0002j-\u0011\t\u0011)A\u0005\u0003WB!\"!\u001e\f\u0005\u0003\u0005\u000b\u0011BA<\u0011)\t\ti\u0003B\u0001B\u0003%\u00111\u0011\u0005\u0007\u0007.!\t!!#\t\u0013\u0005m5B1A\u0005\n\u0005u\u0005\u0002CAS\u0017\u0001\u0006I!a(\t\u0011\u0011\\!\u0019!C\u0005\u0003OCq!!+\fA\u0003%Q\rC\u0005\u0002,.\u0011\r\u0011\"\u0003\u0002.\"A\u0011QW\u0006!\u0002\u0013\ty\u000bC\u0005\u00028.\u0011\r\u0011\"\u0003\u0002:\"A\u0011\u0011Y\u0006!\u0002\u0013\tY\fC\u0005\u0002D.\u0011\r\u0011\"\u0003\u0002F\"A\u0011qY\u0006!\u0002\u0013\ty\u0001C\u0005\u0002J.\u0011\r\u0011\"\u0003\u0002L\"A\u00111[\u0006!\u0002\u0013\ti\rC\u0005\u0002V.\u0011\r\u0011\"\u0003\u0002X\"A\u0011q\\\u0006!\u0002\u0013\tI\u000eC\u0005\u0002b.\u0011\r\u0011\"\u0003\u0002d\"A\u0011q]\u0006!\u0002\u0013\t)\u000fC\u0005\u0002j.\u0011\r\u0011\"\u0003\u0002l\"A\u0011\u0011`\u0006!\u0002\u0013\ti\u000fC\u0004\u0002|.!\t!a9\t\r\u0005u8\u0002\"\u0001{\u0011\u0019\typ\u0003C\u0001u\"9!\u0011A\u0006\u0005B\t\r\u0001b\u0002B\f\u0017\u0011\u0005#\u0011\u0004\u0005\b\u0005\u0007ZA\u0011\tB#\u0011\u001d\u0011Ye\u0003C\u0005\u0005\u001bBqAa\u0016\f\t\u0003\u0012I\u0006C\u0004\u0003\u0010.!IA!%\t\u000f\tM5\u0002\"\u0003\u0003\u0016\"9!qS\u0006\u0005\n\te\u0005b\u0002BN\u0017\u0011%!Q\u0014\u0005\b\u0005?[A\u0011\u0002BQ\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u00026m\u0005!!/\u00194u\u0015\u00059\u0014!B6bM.\f7\u0001\u0001\t\u0003u\u0005i\u0011\u0001\u000e\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011H\u0001\u0007SC\u001a$\u0018j\u001c+ie\u0016\fGm\u0005\u0002\u0004\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JN\u0001\u0006kRLGn]\u0005\u0003\u0019&\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u000611\r\\5f]R\u0004$aT.\u0011\u0007A;\u0016,D\u0001R\u0015\t)$K\u0003\u00028'*\u0011A+V\u0001\u0007CB\f7\r[3\u000b\u0003Y\u000b1a\u001c:h\u0013\tA\u0016KA\bLC\u001a\\\u0017MU1gi\u000ec\u0017.\u001a8u!\tQ6\f\u0004\u0001\u0005\u0013q#\u0011\u0011!A\u0001\u0006\u0003i&aA0%cE\u0011a,\u0019\t\u0003}}K!\u0001Y \u0003\u000f9{G\u000f[5oOB\u0011aHY\u0005\u0003G~\u00121!\u00118z\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010\u0005\u0002g[:\u0011qm\u001b\t\u0003Q~j\u0011!\u001b\u0006\u0003Ub\na\u0001\u0010:p_Rt\u0014B\u00017@\u0003\u0019\u0001&/\u001a3fM&\u0011an\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051|DcA9tqB\u0011!oA\u0007\u0002\u0003!)QJ\u0002a\u0001iB\u0012Qo\u001e\t\u0004!^3\bC\u0001.x\t%a6/!A\u0001\u0002\u000b\u0005Q\fC\u0003e\r\u0001\u0007Q-\u0001\u0004e_^{'o\u001b\u000b\u0002wB\u0011a\b`\u0005\u0003{~\u0012A!\u00168ji\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u000b\u0003\u0003\u0003\u00012APA\u0002\u0013\r\t)a\u0010\u0002\b\u0005>|G.Z1o\u0003%I7OU;o]&tw-\u0006\u0002\u0002\u0002\u0005\u00112M]3bi\u0016dun\u001a#je\u0016\u001cGo\u001c:z)\u0019\ty!a\b\u0002$A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011AA5p\u0015\t\tI\"\u0001\u0003kCZ\f\u0017\u0002BA\u000f\u0003'\u0011AAR5mK\"9\u0011\u0011\u0005\u0006A\u0002\u0005=\u0011A\u00027pO\u0012K'\u000f\u0003\u0004\u0002&)\u0001\r!Z\u0001\u000bY><G)\u001b:OC6,W\u0003BA\u0015\u0003g\u0019baC\u001f\u0002,\u0005]\u0002#\u0002\u001e\u0002.\u0005E\u0012bAA\u0018i\tY!+\u00194u\u001b\u0006t\u0017mZ3s!\rQ\u00161\u0007\u0003\u0007\u0003kY!\u0019A/\u0003\u0003Q\u00032\u0001SA\u001d\u0013\r\tY$\u0013\u0002\b\u0019><w-\u001b8h\u00039iW\r^1Qe>\u0004XM\u001d;jKN\u0004B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000b2\u0014AB:feZ,'/\u0003\u0003\u0002J\u0005\r#AD'fi\u0006\u0004&o\u001c9feRLWm]\u0001\u0007G>tg-[4\u0011\t\u0005\u0005\u0013qJ\u0005\u0005\u0003#\n\u0019EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>\u0014HmU3sI\u0016\u0004R\u0001UA,\u0003cI1!!\u0017R\u0005-\u0011VmY8sIN+'\u000fZ3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qLA3\u001b\t\t\tGC\u0002\u0002dI\u000baaY8n[>t\u0017\u0002BA4\u0003C\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0003uS6,\u0007\u0003BA7\u0003cj!!a\u001c\u000b\u0007)\u000b\t'\u0003\u0003\u0002t\u0005=$\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002z\u0005uTBAA>\u0015\u0011\t)(!\u0019\n\t\u0005}\u00141\u0010\u0002\b\u001b\u0016$(/[2t\u0003M!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007p\u00149u!\u0011q\u0014QQ3\n\u0007\u0005\u001duH\u0001\u0004PaRLwN\u001c\u000b\u0011\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0015QSAL\u00033\u0003BAO\u0006\u00022!9\u0011QH\nA\u0002\u0005}\u0002bBA&'\u0001\u0007\u0011Q\n\u0005\b\u0003'\u001a\u0002\u0019AA+\u0011\u001d\tYf\u0005a\u0001\u0003;Bq!!\u001b\u0014\u0001\u0004\tY\u0007C\u0004\u0002vM\u0001\r!a\u001e\t\u000f\u0005\u00055\u00031\u0001\u0002\u0004\u0006Q!/\u00194u\u0007>tg-[4\u0016\u0005\u0005}\u0005c\u0001)\u0002\"&\u0019\u00111U)\u0003\u0015I\u000bg\r^\"p]\u001aLw-A\u0006sC\u001a$8i\u001c8gS\u001e\u0004S#A3\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"!a,\u0011\t\u00055\u0014\u0011W\u0005\u0005\u0003g\u000byG\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0003w\u00032\u0001SA_\u0013\r\ty,\u0013\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\bI\u0006$\u0018\rR5s+\t\ty!\u0001\u0005eCR\fG)\u001b:!\u0003-iW\r^1eCR\fGj\\4\u0016\u0005\u00055\u0007c\u0001\u001e\u0002P&\u0019\u0011\u0011\u001b\u001b\u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0017\u0001D7fi\u0006$\u0017\r^1M_\u001e\u0004\u0013A\u00038fi\u000eC\u0017M\u001c8fYV\u0011\u0011\u0011\u001c\t\u0004u\u0005m\u0017bAAoi\t\u00192*\u00194lC:+Go^8sW\u000eC\u0017M\u001c8fY\u0006Ya.\u001a;DQ\u0006tg.\u001a7!\u0003)\u0011\u0018M\u001a;DY&,g\u000e^\u000b\u0003\u0003K\u0004B\u0001U,\u00022\u0005Y!/\u00194u\u00072LWM\u001c;!\u00031\u0011\u0018M\u001a;J_RC'/Z1e+\t\ti\u000fE\u0002\u0002p\u000eq1!!=\u0001\u001d\u0011\t\u00190a>\u000f\u0007!\f)0C\u00018\u0013\t)d'A\u0007sC\u001a$\u0018j\u001c+ie\u0016\fG\rI\u0001\u0010W\u000647.\u0019*bMR\u001cE.[3oi\u000691\u000f^1siV\u0004\u0018\u0001C:ikR$wn\u001e8\u0002\u0011I,w-[:uKJ$2a\u001fB\u0003\u0011\u001d\u00119!\u000ba\u0001\u0005\u0013\t\u0001\u0002\\5ti\u0016tWM\u001d\t\u0007\u0005\u0017\u0011\t\"!\r\u000f\u0007A\u0013i!C\u0002\u0003\u0010E\u000b!BU1gi\u000ec\u0017.\u001a8u\u0013\u0011\u0011\u0019B!\u0006\u0003\u00111K7\u000f^3oKJT1Aa\u0004R\u0003Q\u00198\r[3ek2,\u0017\t^8nS\u000e\f\u0005\u000f]3oIR1!1\u0004B\u0012\u0005[\u0001RAPAC\u0005;\u00012A\u0010B\u0010\u0013\r\u0011\tc\u0010\u0002\u0005\u0019>tw\rC\u0004\u0003&)\u0002\rAa\n\u0002\u000b\u0015\u0004xn\u00195\u0011\u0007y\u0012I#C\u0002\u0003,}\u00121!\u00138u\u0011\u001d\u0011yC\u000ba\u0001\u0005c\tqA]3d_J$7\u000f\u0005\u0004\u00034\tu\u0012\u0011\u0007\b\u0005\u0005k\u0011IDD\u0002i\u0005oI\u0011\u0001Q\u0005\u0004\u0005wy\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005\u007f\u0011\tEA\u0002TKFT1Aa\u000f@\u00039\u00198\r[3ek2,\u0017\t\u001d9f]\u0012$bAa\u0007\u0003H\t%\u0003b\u0002B\u0013W\u0001\u0007!q\u0005\u0005\b\u0005_Y\u0003\u0019\u0001B\u0019\u0003\u0019\t\u0007\u000f]3oIRA!1\u0004B(\u0005#\u0012\u0019\u0006C\u0004\u0003&1\u0002\rAa\n\t\u000f\t=B\u00061\u0001\u00032!9!Q\u000b\u0017A\u0002\u0005\u0005\u0011\u0001C5t\u0003R|W.[2\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u)!\u0011YFa\u001e\u0003\b\n-\u0005C\u0002B/\u0005O\u0012Y'\u0004\u0002\u0003`)!!\u0011\rB2\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005K\n9\"\u0001\u0003vi&d\u0017\u0002\u0002B5\u0005?\u0012\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\u0011iGa\u001d\u000e\u0005\t=$\u0002\u0002B9\u0003C\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005k\u0012yG\u0001\u0006Ba&lUm]:bO\u0016DqA!\u001f.\u0001\u0004\u0011Y(\u0001\u0004iK\u0006$WM\u001d\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)!!\u0011QA1\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002BC\u0005\u007f\u0012QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\bb\u0002BE[\u0001\u0007!1N\u0001\be\u0016\fX/Z:u\u0011\u001d\u0011i)\fa\u0001\u0005;\tQb\u0019:fCR,G\rV5nK6\u001b\u0018a\u00042vS2$'+\u00194u\u00072LWM\u001c;\u0015\u0005\u0005\u0015\u0018a\u00052vS2$g*\u001a;x_J\\7\t[1o]\u0016dGCAAm\u00035\u0019'/Z1uK\u0012\u000bG/\u0019#jeR\u0011\u0011qB\u0001\u0011EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$\"!!4\u0002%\t,\u0018\u000e\u001c3OKR<xN]6DY&,g\u000e\u001e\u000b\u0003\u0005G\u0003BA!*\u0003,6\u0011!q\u0015\u0006\u0004\u0005S\u0013\u0016aB2mS\u0016tGo]\u0005\u0005\u0005[\u00139KA\u0007OKR<xN]6DY&,g\u000e\u001e")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Time time;
    private final Metrics metrics;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final KafkaMetadataLog metadataLog;
    private final KafkaNetworkChannel netChannel;
    private final KafkaRaftClient<T> raftClient;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private KafkaMetadataLog metadataLog() {
        return this.metadataLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private KafkaRaftClient<T> raftClient() {
        return this.raftClient;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public KafkaRaftClient<T> kafkaRaftClient() {
        return this.raftClient();
    }

    public void startup() {
        Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.raftConfig().quorumVoterConnections();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1<Map.Entry, Object> & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        this.raftIoThread().shutdown();
        this.raftClient().close();
        this.scheduler().shutdown();
        this.netChannel().close();
        this.metadataLog().close();
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.raftClient().register(listener);
    }

    @Override
    public Option<Object> scheduleAtomicAppend(int epoch, Seq<T> records) {
        return this.append(epoch, records, true);
    }

    @Override
    public Option<Object> scheduleAppend(int epoch, Seq<T> records) {
        return this.append(epoch, records, false);
    }

    private Option<Object> append(int epoch, Seq<T> records, boolean isAtomic) {
        Long offset = isAtomic ? this.raftClient().scheduleAtomicAppend(epoch, CollectionConverters$.MODULE$.seqAsJavaListConverter(records).asJava()) : this.raftClient().scheduleAppend(epoch, CollectionConverters$.MODULE$.seqAsJavaListConverter(records).asJava());
        return Option$.MODULE$.apply(offset).map((Function1<Object, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong(KafkaRaftManager.$anonfun$append$1(x)));
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.raftClient().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private KafkaRaftClient<T> buildRaftClient() {
        SystemTimer expirationTimer = new SystemTimer("raft-expiration-executor", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4());
        TimingWheelExpirationService expirationService = new TimingWheelExpirationService(expirationTimer);
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        KafkaRaftClient<T> client = new KafkaRaftClient<T>(this.recordSerde, this.netChannel(), this.metadataLog(), quorumStateStore, this.time, this.metrics, expirationService, this.logContext(), this.metaProperties.clusterId().toString(), OptionalInt.of(this.config.nodeId()), this.raftConfig());
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = Log$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.dataDir(), this.time, this.scheduler(), 0x800000, 0x800000);
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((Object)this.config.listenerSecurityProtocolMap().getOrElse(controllerListenerName, (Function0<SecurityProtocol> & Serializable & scala.Serializable)() -> SecurityProtocol.forName(controllerListenerName.value()))), JaasContext.Type.SERVER, this.config, controllerListenerName, this.config.saslMechanismControllerProtocol(), this.time, this.config.saslInterBrokerHandshakeRequestEnable(), this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.mapAsJavaMapConverter(Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), ClientDnsLookup.USE_ALL_DNS_IPS, this.time, discoverBrokerVersions, new ApiVersions(), this.logContext());
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
                return;
            }
        } else if (addressSpec != null) {
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
                return;
            }
        } else {
            throw new MatchError((Object)null);
        }
    }

    public static final /* synthetic */ long $anonfun$append$1(Object x) {
        return BoxesRunTime.unboxToLong(x);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Time time, Metrics metrics, Option<String> threadNamePrefixOpt) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.time = time;
        this.metrics = metrics;
        Logging.$init$(this);
        this.raftConfig = new RaftConfig(config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        this.metadataLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.raftClient = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.raftClient(), this.threadNamePrefix());
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String> & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable> & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix) {
            this.client = client;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

