/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.pinot.shaded.org.apache.kafka.common.MetricName;
import org.apache.pinot.shaded.org.apache.kafka.common.Reconfigurable;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.pinot.shaded.org.apache.kafka.common.memory.MemoryPool;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ClientInformation;
import org.apache.pinot.shaded.org.apache.kafka.common.network.KafkaChannel;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.pinot.shaded.org.apache.kafka.common.network.NetworkReceive;
import org.apache.pinot.shaded.org.apache.kafka.common.network.NetworkSend;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selector;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Send;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.RequestContext;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.RequestHeader;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$$eq$colon$eq$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011}uA\u00027n\u0011\u0003y\u0017O\u0002\u0004t[\"\u0005q\u000e\u001e\u0005\u0006w\u0006!\t! \u0005\b}\u0006\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0001Q\u0001\n\u0005\u0005\u0001\u0002CA\n\u0003\t\u0007I\u0011A@\t\u0011\u0005U\u0011\u0001)A\u0005\u0003\u0003A\u0001\"a\u0006\u0002\u0005\u0004%\ta \u0005\t\u00033\t\u0001\u0015!\u0003\u0002\u0002!I\u00111D\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003K\t\u0001\u0015!\u0003\u0002 \u001911/\u001c\u0001p\u0003OA!\"a\u000f\f\u0005\u000b\u0007I\u0011AA\u000f\u0011)\tid\u0003B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003\u007fY!\u0011!Q\u0001\n\u0005\u0005\u0003BCA.\u0017\t\u0005\t\u0015!\u0003\u0002 !Q\u0011QL\u0006\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u0005\u00154B!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002n-\u0011\t\u0011)A\u0005\u0003_B!\"!\u001e\f\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t9h\u0003B\u0001B\u0003%\u0011\u0011\u0010\u0005\u000b\u0003\u0007[!\u0011!Q\u0001\n\u0005\u0015\u0005BCAK\u0017\t\u0005\t\u0015!\u0003\u0002\u0018\"Q\u0011QG\u0006\u0003\u0002\u0003\u0006I!a)\t\u0015\u000556B!A!\u0002\u0013\ty\u000b\u0003\u0006\u0002:.\u0011\t\u0011)A\u0005\u0003wC!\"a2\f\u0005\u0003\u0005\u000b\u0011BAe\u0011)\tym\u0003B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003#\\!\u0011!Q\u0001\n\u0005M\u0007BCAm\u0017\t\u0005\t\u0015!\u0003\u0002\\\"11p\u0003C\u0001\u0003C<qAa\u0002\f\u0011\u0013\u0011IAB\u0004\u0003\u000e-AIAa\u0004\t\rm\u0004C\u0011\u0001B\f\u0011\u001d\u0011I\u0002\tC\u0001\u00057A\u0011Ba4!\u0003\u0003%\tI!5\t\u0013\tu\u0007%!A\u0005\u0002\n}ga\u0002B\u0007\u0017\u0001k'Q\u0005\u0005\u000b\u0005[)#Q3A\u0005\u0002\t=\u0002B\u0003B#K\tE\t\u0015!\u0003\u00032!Q!qI\u0013\u0003\u0016\u0004%\t!!\b\t\u0015\t%SE!E!\u0002\u0013\ty\u0002\u0003\u0006\u0003L\u0015\u0012)\u001a!C\u0001\u0005_A!B!\u0014&\u0005#\u0005\u000b\u0011\u0002B\u0019\u0011)\u0011y%\nBK\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0005#*#\u0011#Q\u0001\n\u0005}\u0001B\u0003B*K\tU\r\u0011\"\u0001\u0002\u001e!Q!QK\u0013\u0003\u0012\u0003\u0006I!a\b\t\rm,C\u0011\u0001B,\u0011\u001d\u0011\u0019'\nC!\u0005KB\u0011Ba\u001a&\u0003\u0003%\tA!\u001b\t\u0013\tUT%%A\u0005\u0002\t]\u0004\"\u0003BGKE\u0005I\u0011\u0001BH\u0011%\u0011\u0019*JI\u0001\n\u0003\u00119\bC\u0005\u0003\u0016\u0016\n\n\u0011\"\u0001\u0003\u0010\"I!qS\u0013\u0012\u0002\u0013\u0005!q\u0012\u0005\t\u00053+\u0013\u0011!C!\u007f\"I!1T\u0013\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0005;+\u0013\u0011!C\u0001\u0005?C\u0011Ba+&\u0003\u0003%\tE!,\t\u0013\tmV%!A\u0005\u0002\tu\u0006\"\u0003BaK\u0005\u0005I\u0011\tBb\u0011%\u0011)-JA\u0001\n\u0003\u00129\rC\u0005\u0003n.\u0011\r\u0011\"\u0003\u0003p\"A1\u0011C\u0006!\u0002\u0013\u0011\t\u0010C\u0005\u0004\u0014-\u0011\r\u0011\"\u0003\u0004\u0016!A1\u0011G\u0006!\u0002\u0013\u00199\u0002C\u0005\u00044-\u0011\r\u0011\"\u0003\u00046!A1QH\u0006!\u0002\u0013\u00199\u0004\u0003\u0006\u0004@-\u0011\r\u0011\"\u0001p\u0007\u0003B\u0001b!\u0013\fA\u0003%11\t\u0005\n\u0007\u0017Z!\u0019!C\u0001\u0007\u001bB\u0001ba\u0017\fA\u0003%1q\n\u0005\n\u0007;Z!\u0019!C\u0005\u0007?B\u0001b!\u001b\fA\u0003%1\u0011\r\u0005\n\u0007WZ!\u0019!C\u0005\u0007[B\u0001b!\u001e\fA\u0003%1q\u000e\u0005\t\u0007oZA\u0011C7\u0004z!I1QQ\u0006A\u0002\u0013%\u0011Q\u0004\u0005\n\u0007\u000f[\u0001\u0019!C\u0005\u0007\u0013C\u0001ba%\fA\u0003&\u0011q\u0004\u0005\b\u0007+[A\u0011IBL\u0011!\u0019Ij\u0003C\u0001[\u000em\u0005bBB\\\u0017\u0011%1\u0011\u0018\u0005\b\u0007\u0007\\A\u0011BBL\u0011!\u0019)m\u0003C\t[\u000e\u001d\u0007bBBl\u0017\u0011%1q\u0013\u0005\b\u00073\\A\u0011CBn\u0011\u001d\u0019)p\u0003C\u0005\u0007/Cqaa>\f\t\u0013\u00199\nC\u0004\u0004z.!Iaa?\t\u000f\r}8\u0002\"\u0003\u0004\u0018\"9A\u0011A\u0006\u0005\n\r]\u0005b\u0002C\u0002\u0017\u0011%AQ\u0001\u0005\b\t\u0017YA\u0011\u0001C\u0007\u0011\u001d!\td\u0003C\u0005\u0007/Cq\u0001b\r\f\t\u0013\u00199\n\u0003\u0005\u0005\n-!\t\"\u001cC\u001b\u0011!!9e\u0003C\u0001[\u0012%\u0003b\u0002C'\u0017\u0011%Aq\n\u0005\t\t#ZA\u0011A7\u0002\u001e!AA1K\u0006\u0005\u00025\fi\u0002\u0003\u0005\u0005V-!\t!\u001cC,\u0011\u001d!\u0019g\u0003C\u0005\tKBq\u0001b$\f\t\u0013!\t\n\u0003\u0005\u0005\u0016.!\t!\u001cCL\u0011\u001d!Yj\u0003C!\u0007/Cq\u0001\"(\f\t\u0003\u001a9*A\u0005Qe>\u001cWm]:pe*\u0011an\\\u0001\b]\u0016$xo\u001c:l\u0015\u0005\u0001\u0018!B6bM.\f\u0007C\u0001:\u0002\u001b\u0005i'!\u0003)s_\u000e,7o]8s'\t\tQ\u000f\u0005\u0002ws6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0011/A\u000bJI2,\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\rM#(/\u001b8h\u0003YIE\r\\3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\u0007(fi^|'o\u001b)s_\u000e,7o]8s\u001b\u0016$(/[2UC\u001e\f!DT3uo>\u00148\u000e\u0015:pG\u0016\u001c8o\u001c:NKR\u0014\u0018n\u0019+bO\u0002\n\u0011\u0003T5ti\u0016tWM]'fiJL7\rV1h\u0003Ia\u0015n\u001d;f]\u0016\u0014X*\u001a;sS\u000e$\u0016m\u001a\u0011\u0002'\r{gN\\3di&|g.U;fk\u0016\u001c\u0016N_3\u0016\u0005\u0005}\u0001c\u0001<\u0002\"%\u0019\u00111E<\u0003\u0007%sG/\u0001\u000bD_:tWm\u0019;j_:\fV/Z;f'&TX\rI\n\u0006\u0017\u0005%\u0012q\u0006\t\u0004e\u0006-\u0012bAA\u0017[\n!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ky\u0017aB7fiJL7m]\u0005\u0005\u0003s\t\u0019DA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\f!!\u001b3\u0002\u0007%$\u0007%\u0001\u0003uS6,\u0007\u0003BA\"\u0003/j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0006kRLGn\u001d\u0006\u0005\u0003\u0017\ni%\u0001\u0004d_6lwN\u001c\u0006\u0004a\u0006=#\u0002BA)\u0003'\na!\u00199bG\",'BAA+\u0003\ry'oZ\u0005\u0005\u00033\n)E\u0001\u0003US6,\u0017AD7bqJ+\u0017/^3tiNK'0Z\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\r\u0011\u0018\u0011M\u0005\u0004\u0003Gj'A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN\u00042A]A5\u0013\r\tY'\u001c\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fAcY8o]\u0016\u001cG/[8og6\u000b\u00070\u00133mK6\u001b\bc\u0001<\u0002r%\u0019\u00111O<\u0003\t1{gnZ\u0001\u001cM\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8EK2\f\u00170T:\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005m\u0014qP\u0007\u0003\u0003{R1A\\A%\u0013\u0011\t\t)! \u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\u0005CV$\bN\u0003\u0003\u0002\u0010\u0006%\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005M\u0015\u0011\u0012\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\faaY8oM&<\u0007\u0003BAM\u0003?k!!a'\u000b\u0007\u0005uu.\u0001\u0004tKJ4XM]\u0005\u0005\u0003C\u000bYJA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0003BAS\u0003Sk!!a*\u000b\t\u0005U\u0012\u0011J\u0005\u0005\u0003W\u000b9KA\u0004NKR\u0014\u0018nY:\u0002%\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u0005\u0003c\u000b),\u0004\u0002\u00024*\u0019\u0011qR8\n\t\u0005]\u00161\u0017\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006nK6|'/\u001f)p_2\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\fI%\u0001\u0004nK6|'/_\u0005\u0005\u0003\u000b\fyL\u0001\u0006NK6|'/\u001f)p_2\f!\u0002\\8h\u0007>tG/\u001a=u!\u0011\t\u0019%a3\n\t\u00055\u0017Q\t\u0002\u000b\u0019><7i\u001c8uKb$\u0018aE2p]:,7\r^5p]F+X-^3TSj,\u0017\u0001F5t!JLg/\u001b7fO\u0016$G*[:uK:,'\u000fE\u0002w\u0003+L1!a6x\u0005\u001d\u0011un\u001c7fC:\f\u0011#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s!\u0011\tI*!8\n\t\u0005}\u00171\u0014\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014H\u0003JAr\u0003K\f9/!;\u0002l\u00065\u0018q^Ay\u0003g\f)0a>\u0002z\u0006m\u0018Q`A\u0000\u0005\u0003\u0011\u0019A!\u0002\u0011\u0005I\\\u0001bBA\u001e=\u0001\u0007\u0011q\u0004\u0005\b\u0003\u007fq\u0002\u0019AA!\u0011\u001d\tYF\ba\u0001\u0003?Aq!!\u0018\u001f\u0001\u0004\ty\u0006C\u0004\u0002fy\u0001\r!a\u001a\t\u000f\u00055d\u00041\u0001\u0002p!9\u0011Q\u000f\u0010A\u0002\u0005}\u0001bBA<=\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0007s\u0002\u0019AAC\u0011\u001d\t)J\ba\u0001\u0003/Cq!!\u000e\u001f\u0001\u0004\t\u0019\u000bC\u0004\u0002.z\u0001\r!a,\t\u000f\u0005ef\u00041\u0001\u0002<\"9\u0011q\u0019\u0010A\u0002\u0005%\u0007bBAh=\u0001\u0007\u0011q\u0004\u0005\b\u0003#t\u0002\u0019AAj\u0011\u001d\tIN\ba\u0001\u00037\fAbQ8o]\u0016\u001cG/[8o\u0013\u0012\u00042Aa\u0003!\u001b\u0005Y!\u0001D\"p]:,7\r^5p]&#7\u0003\u0002\u0011v\u0005#\u00012A\u001eB\n\u0013\r\u0011)b\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u0013\t!B\u001a:p[N#(/\u001b8h)\u0011\u0011iBa3\u0011\u000bY\u0014yBa\t\n\u0007\t\u0005rO\u0001\u0004PaRLwN\u001c\t\u0004\u0005\u0017)3CB\u0013v\u0005O\u0011\t\u0002E\u0002w\u0005SI1Aa\u000bx\u0005\u001d\u0001&o\u001c3vGR\f\u0011\u0002\\8dC2Dun\u001d;\u0016\u0005\tE\u0002\u0003\u0002B\u001a\u0005\u0003rAA!\u000e\u0003>A\u0019!qG<\u000e\u0005\te\"b\u0001B\u001ey\u00061AH]8pizJ1Aa\u0010x\u0003\u0019\u0001&/\u001a3fM&!\u0011q\u0002B\"\u0015\r\u0011yd^\u0001\u000bY>\u001c\u0017\r\u001c%pgR\u0004\u0013!\u00037pG\u0006d\u0007k\u001c:u\u0003)awnY1m!>\u0014H\u000fI\u0001\u000be\u0016lw\u000e^3I_N$\u0018a\u0003:f[>$X\rS8ti\u0002\n!B]3n_R,\u0007k\u001c:u\u0003-\u0011X-\\8uKB{'\u000f\u001e\u0011\u0002\u000b%tG-\u001a=\u0002\r%tG-\u001a=!)1\u0011\u0019C!\u0017\u0003\\\tu#q\fB1\u0011\u001d\u0011i\u0003\ra\u0001\u0005cAqAa\u00121\u0001\u0004\ty\u0002C\u0004\u0003LA\u0002\rA!\r\t\u000f\t=\u0003\u00071\u0001\u0002 !9!1\u000b\u0019A\u0002\u0005}\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0012\u0001B2paf$BBa\t\u0003l\t5$q\u000eB9\u0005gB\u0011B!\f3!\u0003\u0005\rA!\r\t\u0013\t\u001d#\u0007%AA\u0002\u0005}\u0001\"\u0003B&eA\u0005\t\u0019\u0001B\u0019\u0011%\u0011yE\rI\u0001\u0002\u0004\ty\u0002C\u0005\u0003TI\u0002\n\u00111\u0001\u0002 \u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B=U\u0011\u0011\tDa\u001f,\u0005\tu\u0004\u0003\u0002B@\u0005\u0013k!A!!\u000b\t\t\r%QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\"x\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0013\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0012*\"\u0011q\u0004B>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!)\u0003(B\u0019aOa)\n\u0007\t\u0015vOA\u0002B]fD\u0011B!+;\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u000b\u0005\u0004\u00032\n]&\u0011U\u0007\u0003\u0005gS1A!.x\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005s\u0013\u0019L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAj\u0005\u007fC\u0011B!+=\u0003\u0003\u0005\rA!)\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\b\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019N!3\t\u0013\t%f(!AA\u0002\t\u0005\u0006b\u0002BgE\u0001\u0007!\u0011G\u0001\u0002g\u0006)\u0011\r\u001d9msRa!1\u0005Bj\u0005+\u00149N!7\u0003\\\"9!QF\u0012A\u0002\tE\u0002b\u0002B$G\u0001\u0007\u0011q\u0004\u0005\b\u0005\u0017\u001a\u0003\u0019\u0001B\u0019\u0011\u001d\u0011ye\ta\u0001\u0003?AqAa\u0015$\u0001\u0004\ty\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005(\u0011\u001e\t\u0006m\n}!1\u001d\t\u000em\n\u0015(\u0011GA\u0010\u0005c\ty\"a\b\n\u0007\t\u001dxO\u0001\u0004UkBdW-\u000e\u0005\n\u0005W$\u0013\u0011!a\u0001\u0005G\t1\u0001\u001f\u00131\u00039qWm^\"p]:,7\r^5p]N,\"A!=\u0011\r\tM(Q`B\u0001\u001b\t\u0011)P\u0003\u0003\u0003x\ne\u0018AC2p]\u000e,(O]3oi*!!1`A\u0005\u0003\u0011)H/\u001b7\n\t\t}(Q\u001f\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003\u0004\u0004\r5QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0011\rD\u0017M\u001c8fYNTAaa\u0003\u0002\n\u0005\u0019a.[8\n\t\r=1Q\u0001\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002\n\u0011#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3t+\t\u00199\u0002\u0005\u0005\u0004\u001a\r}!\u0011GB\u0012\u001b\t\u0019YB\u0003\u0003\u0004\u001e\tM\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0007C\u0019YBA\u0002NCB\u0004Ba!\n\u0004,9\u0019!oa\n\n\u0007\r%R.\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\r52q\u0006\u0002\t%\u0016\u001c\bo\u001c8tK*\u00191\u0011F7\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000fI\u0001\u000ee\u0016\u001c\bo\u001c8tKF+X-^3\u0016\u0005\r]\u0002C\u0002Bz\u0007s\u0019\u0019#\u0003\u0003\u0004<\tU(a\u0005'j].,GM\u00117pG.Lgn\u001a#fcV,\u0017A\u0004:fgB|gn]3Rk\u0016,X\rI\u0001\u000b[\u0016$(/[2UC\u001e\u001cXCAB\"!!\u0019)ea\u0012\u0002\u0002\u0005\u0005QB\u0001B}\u0013\u0011\u0019\tC!?\u0002\u00175,GO]5d)\u0006<7\u000fI\u0001\u001eKb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oiV\u00111q\n\t\u0005\u0007#\u001a9&\u0004\u0002\u0004T)!1QKAT\u0003\u0015\u0019H/\u0019;t\u0013\u0011\u0019Ifa\u0015\u0003\u001b\r+X.\u001e7bi&4XmU;n\u0003y)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$\b%A\u0014fqBL'/\u001a3D_:tWm\u0019;j_:\u001c8*\u001b7mK\u0012\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WCAB1!\u0011\u0019\u0019g!\u001a\u000e\u0005\u0005%\u0013\u0002BB4\u0003\u0013\u0012!\"T3ue&\u001cg*Y7f\u0003!*\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003!\u0019X\r\\3di>\u0014XCAB8!\u0011\tYh!\u001d\n\t\rM\u0014Q\u0010\u0002\t'\u0016dWm\u0019;pe\u0006I1/\u001a7fGR|'\u000fI\u0001\u000fGJ,\u0017\r^3TK2,7\r^8s)\u0011\u0019yga\u001f\t\u000f\ruT\n1\u0001\u0004\u0000\u0005q1\r[1o]\u0016d')^5mI\u0016\u0014\b\u0003BA>\u0007\u0003KAaa!\u0002~\tq1\t[1o]\u0016d')^5mI\u0016\u0014\u0018a\u00058fqR\u001cuN\u001c8fGRLwN\\%oI\u0016D\u0018a\u00068fqR\u001cuN\u001c8fGRLwN\\%oI\u0016Dx\fJ3r)\u0011\u0019Yi!%\u0011\u0007Y\u001ci)C\u0002\u0004\u0010^\u0014A!\u00168ji\"I!\u0011V(\u0002\u0002\u0003\u0007\u0011qD\u0001\u0015]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r\u001f\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0004\f\u0006\u0001\u0002O]8dKN\u001cX\t_2faRLwN\u001c\u000b\u0007\u0007\u0017\u001bij!)\t\u000f\r}%\u000b1\u0001\u00032\u0005aQM\u001d:pe6+7o]1hK\"911\u0015*A\u0002\r\u0015\u0016!\u0003;ie><\u0018M\u00197f!\u0011\u00199k!-\u000f\t\r%6Q\u0016\b\u0005\u0005o\u0019Y+C\u0001y\u0013\r\u0019yk^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\u0019l!.\u0003\u0013QC'o\\<bE2,'bABXo\u00069\u0002O]8dKN\u001c8\t[1o]\u0016dW\t_2faRLwN\u001c\u000b\t\u0007\u0017\u001bYla0\u0004B\"91QX*A\u0002\tE\u0012!C2iC:tW\r\\%e\u0011\u001d\u0019yj\u0015a\u0001\u0005cAqaa)T\u0001\u0004\u0019)+A\nqe>\u001cWm]:OK^\u0014Vm\u001d9p]N,7/\u0001\u0007tK:$'+Z:q_:\u001cX\r\u0006\u0004\u0004\f\u000e%7Q\u001a\u0005\b\u0007\u0017,\u0006\u0019AB\u0012\u0003!\u0011Xm\u001d9p]N,\u0007bBBh+\u0002\u00071\u0011[\u0001\re\u0016\u001c\bo\u001c8tKN+g\u000e\u001a\t\u0005\u0003w\u001a\u0019.\u0003\u0003\u0004V\u0006u$\u0001B*f]\u0012\fA\u0001]8mY\u0006\u0011\u0002/\u0019:tKJ+\u0017/^3ti\"+\u0017\rZ3s)\u0011\u0019in!;\u0011\t\r}7Q]\u0007\u0003\u0007CTAaa9\u0002J\u0005A!/Z9vKN$8/\u0003\u0003\u0004h\u000e\u0005(!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0004l^\u0003\ra!<\u0002\r\t,hMZ3s!\u0011\u0019yo!=\u000e\u0005\r%\u0011\u0002BBz\u0007\u0013\u0011!BQ=uK\n+hMZ3s\u0003a\u0001(o\\2fgN\u001cu.\u001c9mKR,GMU3dK&4Xm]\u0001\u0016aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u001cVM\u001c3t\u0003Q)\b\u000fZ1uKJ+\u0017/^3ti6+GO]5dgR!11RB\u007f\u0011\u001d\u0019YM\u0017a\u0001\u0007G\t1\u0003\u001d:pG\u0016\u001c8\u000fR5tG>tg.Z2uK\u0012\fac\u00197pg\u0016,\u0005pY3tg\u000e{gN\\3di&|gn]\u0001\u0006G2|7/\u001a\u000b\u0005\u0007\u0017#9\u0001C\u0004\u0005\nu\u0003\rA!\r\u0002\u0019\r|gN\\3di&|g.\u00133\u0002\r\u0005\u001c7-\u001a9u)!\t\u0019\u000eb\u0004\u0005\u0014\u0011]\u0001b\u0002C\t=\u0002\u00071\u0011A\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\u0011Ua\f1\u0001\u0002T\u0006AQ.Y=CY>\u001c7\u000eC\u0004\u0005\u001ay\u0003\r\u0001b\u0007\u00021\u0005\u001c7-\u001a9u_JLE\r\\3QKJ\u001cWM\u001c;NKR,'\u000f\u0005\u0003\u0005\u001e\u00115RB\u0001C\u0010\u0015\u0011!\t\u0003b\t\u0002\t\r|'/\u001a\u0006\u0005\u0003k!)C\u0003\u0003\u0005(\u0011%\u0012AB=b[6,'O\u0003\u0002\u0005,\u0005\u00191m\\7\n\t\u0011=Bq\u0004\u0002\u0006\u001b\u0016$XM]\u0001\u0018G>tg-[4ve\u0016tUm^\"p]:,7\r^5p]N\f\u0001b\u00197pg\u0016\fE\u000e\u001c\u000b\u0005\u0005c!9\u0004C\u0004\u0005:\u0005\u0004\r\u0001b\u000f\u0002\rM|7m[3u!\u0011!i\u0004b\u0011\u000e\u0005\u0011}\"\u0002\u0002C!\u0003\u0013\t1A\\3u\u0013\u0011!)\u0005b\u0010\u0003\rM{7m[3u\u0003=)g.];fk\u0016\u0014Vm\u001d9p]N,G\u0003BBF\t\u0017Bqaa3c\u0001\u0004\u0019\u0019#A\beKF,X-^3SKN\u0004xN\\:f)\t\u0019\u0019#A\tsKN\u0004xN\\:f#V,W/Z*ju\u0016\fQ#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3D_VtG/\u0001\u000bpa\u0016twJ]\"m_NLgnZ\"iC:tW\r\u001c\u000b\u0005\t3\"\t\u0007E\u0003w\u0005?!Y\u0006\u0005\u0003\u0002|\u0011u\u0013\u0002\u0002C0\u0003{\u0012AbS1gW\u0006\u001c\u0005.\u00198oK2Dq\u0001\"\u0003g\u0001\u0004\u0011\t$\u0001\fiC:$G.Z\"iC:tW\r\\'vi\u0016,e/\u001a8u)\u0019\u0019Y\tb\u001a\u0005j!9A\u0011B4A\u0002\tE\u0002b\u0002C6O\u0002\u0007AQN\u0001\u0006KZ,g\u000e\u001e\t\u0005\t_\"II\u0004\u0003\u0005r\u0011\u0015e\u0002\u0002C:\t\u0007sA\u0001\"\u001e\u0005\u0002:!Aq\u000fC@\u001d\u0011!I\b\" \u000f\t\t]B1P\u0005\u0003\u0003+JA!!\u0015\u0002T%\u0019\u0001/a\u0014\n\t\u0005-\u0013QJ\u0005\u0004]\u0006%\u0013\u0002\u0002CD\u0003{\nAbS1gW\u0006\u001c\u0005.\u00198oK2LA\u0001b#\u0005\u000e\n\u00012\t[1o]\u0016dW*\u001e;f\u000bZ,g\u000e\u001e\u0006\u0005\t\u000f\u000bi(\u0001\tuef,f.\\;uK\u000eC\u0017M\u001c8fYR!11\u0012CJ\u0011\u001d!I\u0001\u001ba\u0001\u0005c\tqa\u00195b]:,G\u000e\u0006\u0003\u0005Z\u0011e\u0005b\u0002C\u0005S\u0002\u0007!\u0011G\u0001\u0007o\u0006\\W-\u001e9\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0007")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)((Object)channelBuilder));
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (Throwable)((Object)((ControlThrowable)((Object)throwable)));
        }
        this.error((Function0<String> & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(connectionId), response));
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll(pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    public RequestHeader parseRequestHeader(ByteBuffer buffer) {
        RequestHeader header = RequestHeader.parse(buffer);
        if (this.apiVersionManager.isApiEnabled(header.apiKey())) {
            return header;
        }
        throw new InvalidRequestException(new StringBuilder(46).append("Received request api key ").append((Object)header.apiKey()).append(" which is not enabled").toString());
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = this.parseRequestHeader(receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !((Object)((Object)apiKeys)).equals((Object)apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication((NetworkReceive)receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !((Object)((Object)apiKeys3)).equals((Object)apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef$$eq$colon$eq$.MODULE$.tpEquals()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove(send.destinationId()).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destinationId()).append(" completed, but not in `inflightResponses`").toString());
                });
                this.updateRequestMetrics(response);
                response.onComplete().foreach((Function1<Function1, Object> & Serializable & scala.Serializable)onComplete -> {
                    onComplete.apply(send);
                    return BoxedUnit.UNIT;
                });
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destinationId()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong(this.openOrClosingChannel(request.context().connectionId).fold((JFunction0$mcJ$sp & scala.Serializable)() -> 0L, (Function1<KafkaChannel, Object> & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong(x$18.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ConnectionId)this.ConnectionId().fromString((String)connectionId).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append((String)connectionId).toString());
                })).remoteHost();
                this.inflightResponses().remove((String)connectionId).foreach((Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1<KafkaChannel, Object> & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Processor$.MODULE$.NetworkProcessorMetricTag()), Integer.toString(this.id()))})));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply(this.selector().channel(connectionId)).orElse((Function0<Option> & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1<KafkaChannel, Object> & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1<KafkaChannel, Object> & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply(this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        this.removeMetric("IdlePercent", (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("networkProcessor"), Integer.toString(this.id()))})));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble(m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        return BoxesRunTime.unboxToDouble(Option$.MODULE$.apply(this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags()))).fold((JFunction0$mcD$sp & scala.Serializable)() -> 0.0, (Function1<KafkaMetric, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble(Processor.$anonfun$new$3(m))));
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$3(NetworkSend send$1, Function1 onComplete) {
        onComplete.apply(send$1);
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove(connectionId$3).foreach((Function1<RequestChannel.Response, Object> & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Processor$.MODULE$.ListenerMetricTag()), listenerName.value()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Processor$.MODULE$.NetworkProcessorMetricTag()), Integer.toString(id))}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Processor$.MODULE$.NetworkProcessorMetricTag()), Integer.toString(id))})));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder(listenerName, ((Object)listenerName).equals(config.interBrokerListenerName()), securityProtocol, config, credentialProvider.credentialCache(), credentialProvider.tokenCache(), time, logContext, () -> $this.apiVersionManager.apiVersionResponse(0)));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        @Override
        public String productPrefix() {
            return "ConnectionId";
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger(this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger(this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger(this.index());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(Statics.mix(Statics.mix(-889275714, Statics.anyHash(this.localHost())), this.localPort()), Statics.anyHash(this.remoteHost())), this.remotePort()), this.index()), 5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

