/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.common.InvalidRecordException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.pinot.shaded.org.apache.kafka.common.record.FileLogInputStream;
import org.apache.pinot.shaded.org.apache.kafka.common.record.FileRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.RecordBatch;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0011Ea\u0001\u0002.\\\u0001\u0001D\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u001c\u0005\tw\u0002\u0011\t\u0011)A\u0005]\"AA\u0010\u0001BC\u0002\u0013\u0005Q\u0010C\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005}\"Q\u0011Q\u0002\u0001\u0003\u0006\u0004%\t!a\u0004\t\u0015\u0005e\u0001A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001c\u0001\u0011)\u0019!C\u0001\u0003;A!\"!\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t9\u0003\u0001BC\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005-\u0002BCA\u001a\u0001\t\u0015\r\u0011\"\u0001\u00026!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005}\u0002A!b\u0001\n\u0003\tI\u0003\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003WA!\"a\u0011\u0001\u0005\u000b\u0007I\u0011AA#\u0011)\t\t\u0006\u0001B\u0001B\u0003%\u0011q\t\u0005\t\u0003'\u0002A\u0011A.\u0002V!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a%\u0001\t\u0003\t)\nC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002*!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003K\u0003\u0001\u0015)\u0003\u0002,!I\u0011q\u0015\u0001A\u0002\u0013%\u0011Q\u0007\u0005\n\u0003S\u0003\u0001\u0019!C\u0005\u0003WC\u0001\"a,\u0001A\u0003&\u0011q\u0007\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0011\"a/\u0001\u0001\u0004%I!!0\t\u0011\u0005\u0005\u0007\u0001)Q\u0005\u0003kC\u0011\"a3\u0001\u0001\u0004%I!a-\t\u0013\u00055\u0007\u00011A\u0005\n\u0005=\u0007\u0002CAj\u0001\u0001\u0006K!!.\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011q\u001c\u0001\u0005\u0002\u0005%\u0002\"CAq\u0001\u0001\u0007I\u0011BAZ\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BA[\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!!>\u0001\t\u0003\tI\u0003C\u0004\u0002\u0012\u0002!\t!!\u000e\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqAa\u0011\u0001\t\u0003\u0011)\u0005C\u0004\u0003X\u0001!IA!\u0017\t\u0011\t=\u0004\u0001\"\u0001\\\u0005cB!B!+\u0001#\u0003%\ta\u0017BV\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007D\u0011Ba9\u0001#\u0003%\tA!:\t\u0013\t%\b!%A\u0005\u0002\t-\bb\u0002Bx\u0001\u0011\u0005!\u0011\u001f\u0005\b\u0007\u0003\u0001A\u0011AB\u0002\u0011%\u0019Y\u0002AI\u0001\n\u0003\u0019i\u0002C\u0004\u0004\"\u0001!Iaa\t\t\u000f\r\u0015\u0002\u0001\"\u0001\u0004(!91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u001e\u0001\u0011\u00053Q\b\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011\u001d\u00199\u0006\u0001C\u0001\u0003SAqaa\u0017\u0001\t\u0003\u0019\u0019\u0003C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\r]\u0004\u0001\"\u0001\u0004z!911\u0011\u0001\u0005\u0002\r\r\u0002bBBC\u0001\u0011%11\u0005\u0005\b\u0007\u000f\u0003A\u0011ABE\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0007+Cqaa&\u0001\t\u0003\u0019I\nC\u0005\u0004*\u0002\t\n\u0011\"\u0001\u0003f\"911\u0016\u0001\u0005\u0002\r\r\u0002bBBW\u0001\u0011\u000511\u0005\u0005\b\u0007_\u0003A\u0011AB\u0012\u0011\u001d\u0019\t\f\u0001C\u0001\u0003SAqaa-\u0001\t\u0003\t\u0019\fC\u0004\u0003\b\u0001!\t!!\u000b\t\u000f\rU\u0006\u0001\"\u0001\u00048\u001e91qZ.\t\u0002\rEgA\u0002.\\\u0011\u0003\u0019\u0019\u000eC\u0004\u0002TE#\ta!6\t\u000f\r]\u0017\u000b\"\u0001\u0004Z\"I11`)\u0012\u0002\u0013\u0005!1\u001e\u0005\n\u0007{\f\u0016\u0013!C\u0001\u0005WC\u0011ba@R#\u0003%\tAa;\t\u0013\u0011\u0005\u0011+%A\u0005\u0002\u0011\r\u0001bBBX#\u0012\u0005Aq\u0001\u0005\n\t\u001f\t\u0016\u0013!C\u0001\t\u0007\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\taV,A\u0002m_\u001eT\u0011AX\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011m\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!\\W\"A5\u000b\u0005)l\u0016!B;uS2\u001c\u0018B\u00017j\u0005\u001daunZ4j]\u001e,\u0012A\u001c\t\u0003_fl\u0011\u0001\u001d\u0006\u0003cJ\faA]3d_J$'BA:u\u0003\u0019\u0019w.\\7p]*\u0011a,\u001e\u0006\u0003m^\fa!\u00199bG\",'\"\u0001=\u0002\u0007=\u0014x-\u0003\u0002{a\nYa)\u001b7f%\u0016\u001cwN\u001d3t\u0003\u0011awn\u001a\u0011\u0002\u001f1\f'0_(gMN,G/\u00138eKb,\u0012A \t\u0006\u007f\u0006\u0005\u0011QA\u0007\u00027&\u0019\u00111A.\u0003\u00131\u000b'0_%oI\u0016D\bcA@\u0002\b%\u0019\u0011\u0011B.\u0003\u0017=3gm]3u\u0013:$W\r_\u0001\u0011Y\u0006T\u0018p\u00144gg\u0016$\u0018J\u001c3fq\u0002\nQ\u0002\\1{sRKW.Z%oI\u0016DXCAA\t!\u0015y\u0018\u0011AA\n!\ry\u0018QC\u0005\u0004\u0003/Y&!\u0003+j[\u0016Le\u000eZ3y\u00039a\u0017M_=US6,\u0017J\u001c3fq\u0002\n\u0001\u0002\u001e=o\u0013:$W\r_\u000b\u0003\u0003?\u00012a`A\u0011\u0013\r\t\u0019c\u0017\u0002\u0011)J\fgn]1di&|g.\u00138eKb\f\u0011\u0002\u001e=o\u0013:$W\r\u001f\u0011\u0002\u0015\t\f7/Z(gMN,G/\u0006\u0002\u0002,A\u0019!-!\f\n\u0007\u0005=2M\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\u0011\u0011q\u0007\t\u0004E\u0006e\u0012bAA\u001eG\n\u0019\u0011J\u001c;\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\u0002\u0019I|G\u000e\u001c&jiR,'/T:\u0002\u001bI|G\u000e\u001c&jiR,'/T:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001bj!!a\u0013\u000b\u0005)\u0014\u0018\u0002BA(\u0003\u0017\u0012A\u0001V5nK\u0006)A/[7fA\u00051A(\u001b8jiz\"\"#a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002hA\u0011q\u0010\u0001\u0005\u00069F\u0001\rA\u001c\u0005\u0006yF\u0001\rA \u0005\b\u0003\u001b\t\u0002\u0019AA\t\u0011\u001d\tY\"\u0005a\u0001\u0003?Aq!a\n\u0012\u0001\u0004\tY\u0003C\u0004\u00024E\u0001\r!a\u000e\t\u000f\u0005}\u0012\u00031\u0001\u0002,!9\u00111I\tA\u0002\u0005\u001d\u0013aC8gMN,G/\u00138eKb,\"!!\u0002\u0002\u0013QLW.Z%oI\u0016DXCAA\n\u0003)\u0019\bn\\;mIJ{G\u000e\u001c\u000b\u0005\u0003k\nY\bE\u0002c\u0003oJ1!!\u001fd\u0005\u001d\u0011un\u001c7fC:Dq!! \u0015\u0001\u0004\ty(\u0001\u0006s_2d\u0007+\u0019:b[N\u00042a`AA\u0013\r\t\u0019i\u0017\u0002\u000b%>dG\u000eU1sC6\u001c\u0018!\u0004:fg&TX-\u00138eKb,7\u000f\u0006\u0003\u0002\n\u0006=\u0005c\u00012\u0002\f&\u0019\u0011QR2\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#+\u0002\u0019AA\u001c\u0003\u0011\u0019\u0018N_3\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u000b\u0005\u0003\u0013\u000b9\nC\u0004\u0002\u001aZ\u0001\r!!\u001e\u00023QLW.Z%oI\u0016Dh)\u001b7f\u001d\u0016<H._\"sK\u0006$X\rZ\u0001\bGJ,\u0017\r^3e\u0003-\u0019'/Z1uK\u0012|F%Z9\u0015\t\u0005%\u0015\u0011\u0015\u0005\n\u0003GC\u0012\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003!\u0019'/Z1uK\u0012\u0004\u0013\u0001\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\u0006a\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=`I\u0015\fH\u0003BAE\u0003[C\u0011\"a)\u001c\u0003\u0003\u0005\r!a\u000e\u00023\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018\u0010I\u0001\u0016e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q+\t\t)\fE\u0003c\u0003o\u000bY#C\u0002\u0002:\u000e\u0014aa\u00149uS>t\u0017!\u0007:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]0%KF$B!!#\u0002@\"I\u00111\u0015\u0010\u0002\u0002\u0003\u0007\u0011QW\u0001\u0017e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7qA!\u001aq$!2\u0011\u0007\t\f9-C\u0002\u0002J\u000e\u0014\u0001B^8mCRLG.Z\u0001\u0013?6\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'/\u0001\f`[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014x\fJ3r)\u0011\tI)!5\t\u0013\u0005\r\u0016%!AA\u0002\u0005U\u0016aE0nCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003f\u0001\u0012\u0002F\u0006)R.\u0019=US6,7\u000f^1naN{g)\u0019:`I\u0015\fH\u0003BAE\u00037Dq!!8$\u0001\u0004\tY#A\u0005uS6,7\u000f^1na\u0006\tR.\u0019=US6,7\u000f^1naN{g)\u0019:\u00025}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u0002=}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:`I\u0015\fH\u0003BAE\u0003OD\u0011\"a)'\u0003\u0003\u0005\r!!.\u00027}{gMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:!Q\r9\u0013QY\u0001\u001e_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR!\u0011\u0011RAy\u0011\u001d\t\u0019\u0010\u000ba\u0001\u0003W\taa\u001c4gg\u0016$\u0018!G8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\f!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$B!!\u001e\u0002|\"9\u00111_\u0016A\u0002\u0005-\u0012AB1qa\u0016tG\r\u0006\u0006\u0002\n\n\u0005!Q\u0001B\u0005\u0005\u001bAqAa\u0001-\u0001\u0004\tY#A\u0007mCJ<Wm\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005\u000fa\u0003\u0019AA\u0016\u0003Aa\u0017M]4fgR$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0003\f1\u0002\r!a\u000b\u00027MD\u0017\r\u001c7po>3gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\u0011y\u0001\fa\u0001\u0005#\tqA]3d_J$7\u000fE\u0002p\u0005'I1A!\u0006q\u00055iU-\\8ssJ+7m\u001c:eg\"\u001aAF!\u0007\u0011\u0007!\u0014Y\"C\u0002\u0003\u001e%\u0014QB\\8oi\"\u0014X-\u00193tC\u001a,\u0017aE3ogV\u0014Xm\u00144gg\u0016$\u0018J\u001c*b]\u001e,G\u0003BAE\u0005GAq!a=.\u0001\u0004\tY#A\nbaB,g\u000eZ\"ik:\\gI]8n\r&dW\r\u0006\u0005\u00028\t%\"1\u0006B\u0018\u0011\u0019\u0011yA\fa\u0001]\"9!Q\u0006\u0018A\u0002\u0005]\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000f\tEb\u00061\u0001\u00034\u0005q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003BA%\u0005kIAAa\u000e\u0002L\tq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018AD1qa\u0016tGM\u0012:p[\u001aKG.\u001a\u000b\u0007\u0003o\u0011iDa\u0010\t\r\t=q\u00061\u0001o\u0011\u001d\u0011\te\fa\u0001\u0003o\tQa\u001d;beR\fa\"\u001e9eCR,G\u000b\u001f8J]\u0012,\u0007\u0010\u0006\u0004\u0002\n\n\u001d#\u0011\u000b\u0005\b\u0005\u0013\u0002\u0004\u0019\u0001B&\u00031\u0019w.\u001c9mKR,G\r\u0016=o!\ry(QJ\u0005\u0004\u0005\u001fZ&\u0001D\"p[BdW\r^3e)bt\u0007b\u0002B*a\u0001\u0007\u00111F\u0001\u0011Y\u0006\u001cHo\u0015;bE2,wJ\u001a4tKRD3\u0001\rB\r\u0003M)\b\u000fZ1uKB\u0013x\u000eZ;dKJ\u001cF/\u0019;f)\u0019\tIIa\u0017\u0003f!9!QL\u0019A\u0002\t}\u0013\u0001\u00069s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'\u000fE\u0002\u0000\u0005CJ1Aa\u0019\\\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\"9!qM\u0019A\u0002\t%\u0014!\u00022bi\u000eD\u0007cA8\u0003l%\u0019!Q\u000e9\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r[\u0001\u0010iJ\fgn\u001d7bi\u0016|eMZ:fiR1!1\u000fBN\u0005;\u0003BA!\u001e\u0003\u0016:!!q\u000fBI\u001d\u0011\u0011IHa$\u000f\t\tm$Q\u0012\b\u0005\u0005{\u0012YI\u0004\u0003\u0003\u0000\t%e\u0002\u0002BA\u0005\u000fk!Aa!\u000b\u0007\t\u0015u,\u0001\u0004=e>|GOP\u0005\u0002q&\u0011ao^\u0005\u0003=VL!a\u001d;\n\u0005E\u0014\u0018b\u0001BJa\u0006Ya)\u001b7f%\u0016\u001cwN\u001d3t\u0013\u0011\u00119J!'\u0003#1{wm\u00144gg\u0016$\bk\\:ji&|gNC\u0002\u0003\u0014BDq!a=3\u0001\u0004\tY\u0003C\u0005\u0003 J\u0002\n\u00111\u0001\u00028\u0005!2\u000f^1si&twMR5mKB{7/\u001b;j_:D3A\rBR!\rA'QU\u0005\u0004\u0005OK'A\u0003;ie\u0016\fGm]1gK\u0006IBO]1og2\fG/Z(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iK\u000b\u0003\u00028\t=6F\u0001BY!\u0011\u0011\u0019L!0\u000e\u0005\tU&\u0002\u0002B\\\u0005s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tm6-\u0001\u0006b]:|G/\u0019;j_:LAAa0\u00036\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\tI,\u0017\r\u001a\u000b\u000b\u0005\u000b\u0014\tN!6\u0003Z\nu\u0007\u0003\u0002Bd\u0005\u001bl!A!3\u000b\u0007\t-W,\u0001\u0004tKJ4XM]\u0005\u0005\u0005\u001f\u0014IMA\u0007GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\b\u0005'$\u0004\u0019AA\u0016\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t]G\u00071\u0001\u00028\u00059Q.\u0019=TSj,\u0007\"\u0003BniA\u0005\t\u0019AA\u0016\u0003-i\u0017\r\u001f)pg&$\u0018n\u001c8\t\u0013\t}G\u0007%AA\u0002\u0005U\u0014!D7j]>sW-T3tg\u0006<W\rK\u00025\u0005G\u000baB]3bI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003h*\"\u00111\u0006BX\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"A!<+\t\u0005U$qV\u0001\u0016M\u0016$8\r[+qa\u0016\u0014(i\\;oI>3gm]3u)\u0019\t)La=\u0003~\"9!Q_\u001cA\u0002\t]\u0018aE:uCJ$xJ\u001a4tKR\u0004vn]5uS>t\u0007cA@\u0003z&\u0019!1`.\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9!q`\u001cA\u0002\u0005]\u0012!\u00034fi\u000eD7+\u001b>f\u0003\u001d\u0011XmY8wKJ$b!a\u000e\u0004\u0006\r\u001d\u0001b\u0002B/q\u0001\u0007!q\f\u0005\n\u0007\u0013A\u0004\u0013!a\u0001\u0007\u0017\t\u0001\u0003\\3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\u0011\u000b\t\f9l!\u0004\u0011\t\r=1QC\u0007\u0003\u0007#QAaa\u0005\u0003J\u0006)Q\r]8dQ&!1qCB\t\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\"\u001a\u0001H!\u0007\u0002#I,7m\u001c<fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004 )\"11\u0002BX\u0003Qaw.\u00193MCJ<Wm\u001d;US6,7\u000f^1naR\u0011\u0011\u0011R\u0001\fQ\u0006\u001cxJ^3sM2|w/\u0006\u0002\u0002v\u0005\u00112m\u001c7mK\u000e$\u0018IY8si\u0016$G\u000b\u001f8t)\u0019\u0019ica\r\u00048A\u0019qpa\f\n\u0007\rE2L\u0001\u000bUq:Le\u000eZ3y'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\b\u0007ka\u0004\u0019AA\u0016\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\reB\b1\u0001\u0002,\u0005\u0001R\u000f\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r^\u0001\ti>\u001cFO]5oOR\u00111q\b\t\u0005\u0007\u0003\u001aIE\u0004\u0003\u0004D\r\u0015\u0003c\u0001BAG&\u00191qI2\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019Ye!\u0014\u0003\rM#(/\u001b8h\u0015\r\u00199eY\u0001\u000biJ,hnY1uKR{G\u0003BA\u001c\u0007'Bq!a=?\u0001\u0004\tY\u0003K\u0002?\u00053\taB]3bI:+\u0007\u0010^(gMN,G\u000fK\u0002@\u0005G\u000bQA\u001a7vg\"D3\u0001\u0011BR\u0003=)\b\u000fZ1uKB\u000b'/\u001a8u\t&\u0014H\u0003BAE\u0007GBqa!\u001aB\u0001\u0004\u00199'A\u0002eSJ\u0004Ba!\u001b\u0004t5\u001111\u000e\u0006\u0005\u0007[\u001ay'\u0001\u0002j_*\u00111\u0011O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0004v\r-$\u0001\u0002$jY\u0016\f!c\u00195b]\u001e,g)\u001b7f'V4g-\u001b=fgR1\u0011\u0011RB>\u0007\u007fBqa! C\u0001\u0004\u0019y$A\u0005pY\u0012\u001cVO\u001a4jq\"91\u0011\u0011\"A\u0002\r}\u0012!\u00038foN+hMZ5y\u0003]ygNQ3d_6,\u0017J\\1di&4XmU3h[\u0016tG/A\fm_\u0006$g)\u001b:ti\n\u000bGo\u00195US6,7\u000f^1na\u0006\tB/[7f/\u0006LG/\u001a3G_J\u0014v\u000e\u001c7\u0015\r\u0005-21RBH\u0011\u001d\u0019i)\u0012a\u0001\u0003W\t1A\\8x\u0011\u001d\u0019\t*\u0012a\u0001\u0003W\t\u0001#\\3tg\u0006<W\rV5nKN$\u0018-\u001c9\u0002-\u001d,GOR5sgR\u0014\u0015\r^2i)&lWm\u001d;b[B$\"!a\u000b\u0002+\u0019Lg\u000eZ(gMN,GOQ=US6,7\u000f^1naR111TBR\u0007K\u0003RAYA\\\u0007;\u0003BA!\u001e\u0004 &!1\u0011\u0015BM\u0005I!\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005uw\t1\u0001\u0002,!I1qU$\u0011\u0002\u0003\u0007\u00111F\u0001\u000fgR\f'\u000f^5oO>3gm]3u\u0003}1\u0017N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B$C-\u001a4bk2$HEM\u0001\u0006G2|7/Z\u0001\u000eG2|7/\u001a%b]\u0012dWM]:\u0002\u001d\u0011,G.\u001a;f\u0013\u001a,\u00050[:ug\u0006aA.Y:u\u001b>$\u0017NZ5fI\u00061B.\u0019:hKN$(+Z2pe\u0012$\u0016.\\3ti\u0006l\u0007/\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!1\u0011XBe!\u0011\u0019Yl!2\u000e\u0005\ru&\u0002BB`\u0007\u0003\fAAZ5mK*!11YB8\u0003\rq\u0017n\\\u0005\u0005\u0007\u000f\u001ciL\u0001\u0003QCRD\u0007bBBf\u001f\u0002\u0007\u00111F\u0001\u0003[ND3\u0001\u0001B\r\u0003)aunZ*fO6,g\u000e\u001e\t\u0003\u007fF\u001b\"!U1\u0015\u0005\rE\u0017\u0001B8qK:$\"#a\u0016\u0004\\\u000eu7q\\Bu\u0007W\u001cyoa=\u0004x\"91QM*A\u0002\r\u001d\u0004bBA\u0014'\u0002\u0007\u00111\u0006\u0005\b\u0007C\u001c\u0006\u0019ABr\u0003\u0019\u0019wN\u001c4jOB\u0019qp!:\n\u0007\r\u001d8LA\u0005M_\u001e\u001cuN\u001c4jO\"9\u00111I*A\u0002\u0005\u001d\u0003\"CBw'B\u0005\t\u0019AA;\u0003E1\u0017\u000e\\3BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u0005\n\u0007c\u001c\u0006\u0013!a\u0001\u0003o\tA\"\u001b8ji\u001aKG.Z*ju\u0016D\u0011b!>T!\u0003\u0005\r!!\u001e\u0002\u0017A\u0014X-\u00197m_\u000e\fG/\u001a\u0005\n\u0007s\u001c\u0006\u0013!a\u0001\u0007\u007f\t!BZ5mKN+hMZ5y\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIU\nab\u001c9f]\u0012\"WMZ1vYR$c'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%qU\u0011AQ\u0001\u0016\u0005\u0007\u007f\u0011y\u000b\u0006\u0005\u0002\n\u0012%A1\u0002C\u0007\u0011\u001d\u0019)\u0007\u0017a\u0001\u0007OBq!a\nY\u0001\u0004\tY\u0003C\u0005\u0004zb\u0003\n\u00111\u0001\u0004@\u0005AB-\u001a7fi\u0016Le-\u0012=jgR\u001cH\u0005Z3gCVdG\u000fJ\u001a")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq(new Some<Object>(BoxesRunTime.boxToLong(timestamp)));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq(new Some<Object>(BoxesRunTime.boxToLong(this.timeIndex().lastEntry().timestamp())));
        }
        return BoxesRunTime.unboxToLong(this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset) {
        this._offsetOfMaxTimestampSoFar_$eq(new Some<Object>(BoxesRunTime.boxToLong(offset)));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq(new Some<Object>(BoxesRunTime.boxToLong(this.timeIndex().lastEntry().offset())));
        }
        return BoxesRunTime.unboxToLong(this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq(new Some<Object>(BoxesRunTime.boxToLong(largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create(0);
        LongRef maxTimestamp = LongRef.create(Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create(Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create(Long.MIN_VALUE);
        ObjectRef<ByteBuffer> readBuffer = ObjectRef.create(bufferSupplier.get(0x100000));
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1<RecordBatch, Object> & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean(this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)readBuffer.elem));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1<CompletedTxn, Object> & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1<OffsetPosition, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong(x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create(0);
        IntRef lastIndexEntry = IntRef.create(0);
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger(validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq(None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong(((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1<RecordBatch, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(x$3.nextOffset())).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0$mcV$sp & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator<FileLogInputStream.FileChannelRecordBatch> iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq(new Some<Object>(BoxesRunTime.boxToLong(iter.next().maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong(((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong(((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply(this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        if (this._maxTimestampSoFar().nonEmpty() || this._offsetOfMaxTimestampSoFar().nonEmpty()) {
            CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.lazyOffsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.lazyTimeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.lazyTimeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll(new $colon$colon<Nothing$>((Nothing$)(JFunction0$mcV$sp & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(JFunction0$mcV$sp & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(JFunction0$mcV$sp & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)(JFunction0$mcV$sp & scala.Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, Nil$.MODULE$)))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some<Object>(BoxesRunTime.boxToLong(this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((JFunction1$mcZI$sp & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
            $this.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1<LeaderEpochFileCache, Object> & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }
}

