/*
 * Decompiled with CFR 0.152.
 */
package kafka.internals.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Bytes;

public class GroupMetadataValue
implements ApiMessage {
    String protocolType;
    int generation;
    String protocol;
    String leader;
    long currentStateTimestamp;
    List<MemberMetadata> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("protocol_type", Type.STRING, ""), new Field("generation", Type.INT32, ""), new Field("protocol", Type.NULLABLE_STRING, ""), new Field("leader", Type.NULLABLE_STRING, ""), new Field("members", new ArrayOf(MemberMetadata.SCHEMA_0), ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("protocol_type", Type.STRING, ""), new Field("generation", Type.INT32, ""), new Field("protocol", Type.NULLABLE_STRING, ""), new Field("leader", Type.NULLABLE_STRING, ""), new Field("members", new ArrayOf(MemberMetadata.SCHEMA_1), ""));
    public static final Schema SCHEMA_2 = new Schema(new Field("protocol_type", Type.STRING, ""), new Field("generation", Type.INT32, ""), new Field("protocol", Type.NULLABLE_STRING, ""), new Field("leader", Type.NULLABLE_STRING, ""), new Field("current_state_timestamp", Type.INT64, ""), new Field("members", new ArrayOf(MemberMetadata.SCHEMA_1), ""));
    public static final Schema SCHEMA_3 = new Schema(new Field("protocol_type", Type.STRING, ""), new Field("generation", Type.INT32, ""), new Field("protocol", Type.NULLABLE_STRING, ""), new Field("leader", Type.NULLABLE_STRING, ""), new Field("current_state_timestamp", Type.INT64, ""), new Field("members", new ArrayOf(MemberMetadata.SCHEMA_3), ""));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public GroupMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public GroupMetadataValue() {
        this.protocolType = "";
        this.generation = 0;
        this.protocol = "";
        this.leader = "";
        this.currentStateTimestamp = -1L;
        this.members = new ArrayList<MemberMetadata>(0);
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field protocolType was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field protocolType had invalid length " + length);
        }
        this.protocolType = _readable.readString(length);
        this.generation = _readable.readInt();
        length = _readable.readShort();
        if (length < 0) {
            this.protocol = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field protocol had invalid length " + length);
            }
            this.protocol = _readable.readString(length);
        }
        length = _readable.readShort();
        if (length < 0) {
            this.leader = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field leader had invalid length " + length);
            }
            this.leader = _readable.readString(length);
        }
        this.currentStateTimestamp = _version >= 2 ? _readable.readLong() : -1L;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field members was serialized as null");
        }
        ArrayList<MemberMetadata> newCollection = new ArrayList<MemberMetadata>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new MemberMetadata(_readable, _version));
        }
        this.members = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.protocolType);
        _writable.writeShort((short)((byte[])_stringBytes).length);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.generation);
        if (this.protocol == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.protocol);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.leader == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.leader);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 2) {
            _writable.writeLong(this.currentStateTimestamp);
        }
        _writable.writeInt(this.members.size());
        _stringBytes = this.members.iterator();
        while (_stringBytes.hasNext()) {
            MemberMetadata membersElement = (MemberMetadata)_stringBytes.next();
            membersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'protocolType' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.protocolType, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        _size.addBytes(4);
        if (this.protocol == null) {
            _size.addBytes(2);
        } else {
            _stringBytes = this.protocol.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'protocol' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.protocol, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        if (this.leader == null) {
            _size.addBytes(2);
        } else {
            _stringBytes = this.leader.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'leader' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.leader, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        if (_version >= 2) {
            _size.addBytes(8);
        }
        _size.addBytes(4);
        for (MemberMetadata membersElement : this.members) {
            membersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupMetadataValue)) {
            return false;
        }
        GroupMetadataValue other = (GroupMetadataValue)obj;
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        if (this.generation != other.generation) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.leader == null ? other.leader != null : !this.leader.equals(other.leader)) {
            return false;
        }
        if (this.currentStateTimestamp != other.currentStateTimestamp) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + this.generation;
        hashCode = 31 * hashCode + (this.protocol == null ? 0 : this.protocol.hashCode());
        hashCode = 31 * hashCode + (this.leader == null ? 0 : this.leader.hashCode());
        hashCode = 31 * hashCode + ((int)(this.currentStateTimestamp >> 32) ^ (int)this.currentStateTimestamp);
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    @Override
    public GroupMetadataValue duplicate() {
        GroupMetadataValue _duplicate = new GroupMetadataValue();
        _duplicate.protocolType = this.protocolType;
        _duplicate.generation = this.generation;
        _duplicate.protocol = this.protocol == null ? null : this.protocol;
        _duplicate.leader = this.leader == null ? null : this.leader;
        _duplicate.currentStateTimestamp = this.currentStateTimestamp;
        ArrayList<MemberMetadata> newMembers = new ArrayList<MemberMetadata>(this.members.size());
        for (MemberMetadata _element : this.members) {
            newMembers.add(_element.duplicate());
        }
        _duplicate.members = newMembers;
        return _duplicate;
    }

    public String toString() {
        return "GroupMetadataValue(protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", generation=" + this.generation + ", protocol=" + (this.protocol == null ? "null" : "'" + this.protocol.toString() + "'") + ", leader=" + (this.leader == null ? "null" : "'" + this.leader.toString() + "'") + ", currentStateTimestamp=" + this.currentStateTimestamp + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int generation() {
        return this.generation;
    }

    public String protocol() {
        return this.protocol;
    }

    public String leader() {
        return this.leader;
    }

    public long currentStateTimestamp() {
        return this.currentStateTimestamp;
    }

    public List<MemberMetadata> members() {
        return this.members;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public GroupMetadataValue setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public GroupMetadataValue setGeneration(int v) {
        this.generation = v;
        return this;
    }

    public GroupMetadataValue setProtocol(String v) {
        this.protocol = v;
        return this;
    }

    public GroupMetadataValue setLeader(String v) {
        this.leader = v;
        return this;
    }

    public GroupMetadataValue setCurrentStateTimestamp(long v) {
        this.currentStateTimestamp = v;
        return this;
    }

    public GroupMetadataValue setMembers(List<MemberMetadata> v) {
        this.members = v;
        return this;
    }

    public static class MemberMetadata
    implements Message {
        String memberId;
        String groupInstanceId;
        String clientId;
        String clientHost;
        int rebalanceTimeout;
        int sessionTimeout;
        byte[] subscription;
        byte[] assignment;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("member_id", Type.STRING, ""), new Field("client_id", Type.STRING, ""), new Field("client_host", Type.STRING, ""), new Field("session_timeout", Type.INT32, ""), new Field("subscription", Type.BYTES, ""), new Field("assignment", Type.BYTES, ""));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public MemberMetadata(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MemberMetadata() {
            this.memberId = "";
            this.groupInstanceId = null;
            this.clientId = "";
            this.clientHost = "";
            this.rebalanceTimeout = 0;
            this.sessionTimeout = 0;
            this.subscription = Bytes.EMPTY;
            this.assignment = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            if (_version >= 3) {
                length = _readable.readShort();
                if (length < 0) {
                    this.groupInstanceId = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                    }
                    this.groupInstanceId = _readable.readString(length);
                }
            } else {
                this.groupInstanceId = null;
            }
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            }
            this.clientHost = _readable.readString(length);
            this.rebalanceTimeout = _version >= 1 ? _readable.readInt() : 0;
            this.sessionTimeout = _readable.readInt();
            length = _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field subscription was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.subscription = newBytes;
            length = _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field assignment was serialized as null");
            }
            newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.assignment = newBytes;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (_version >= 3) {
                if (this.groupInstanceId == null) {
                    _writable.writeShort((short)-1);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                    _writable.writeShort((short)_stringBytes.length);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            _stringBytes = _cache.getSerializedValue(this.clientId);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.clientHost);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeInt(this.rebalanceTimeout);
            }
            _writable.writeInt(this.sessionTimeout);
            _writable.writeInt(this.subscription.length);
            _writable.writeByteArray(this.subscription);
            _writable.writeInt(this.assignment.length);
            _writable.writeByteArray(this.assignment);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (_version >= 3) {
                if (this.groupInstanceId == null) {
                    _size.addBytes(2);
                } else {
                    _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if ((_stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientId, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientHost, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (_version >= 1) {
                _size.addBytes(4);
            }
            _size.addBytes(4);
            _size.addBytes(this.subscription.length);
            _size.addBytes(4);
            _size.addBytes(this.assignment.length);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberMetadata)) {
                return false;
            }
            MemberMetadata other = (MemberMetadata)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (this.rebalanceTimeout != other.rebalanceTimeout) {
                return false;
            }
            if (this.sessionTimeout != other.sessionTimeout) {
                return false;
            }
            if (!Arrays.equals(this.subscription, other.subscription)) {
                return false;
            }
            if (!Arrays.equals(this.assignment, other.assignment)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + this.rebalanceTimeout;
            hashCode = 31 * hashCode + this.sessionTimeout;
            hashCode = 31 * hashCode + Arrays.hashCode(this.subscription);
            hashCode = 31 * hashCode + Arrays.hashCode(this.assignment);
            return hashCode;
        }

        @Override
        public MemberMetadata duplicate() {
            MemberMetadata _duplicate = new MemberMetadata();
            _duplicate.memberId = this.memberId;
            _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
            _duplicate.clientId = this.clientId;
            _duplicate.clientHost = this.clientHost;
            _duplicate.rebalanceTimeout = this.rebalanceTimeout;
            _duplicate.sessionTimeout = this.sessionTimeout;
            _duplicate.subscription = MessageUtil.duplicate(this.subscription);
            _duplicate.assignment = MessageUtil.duplicate(this.assignment);
            return _duplicate;
        }

        public String toString() {
            return "MemberMetadata(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", rebalanceTimeout=" + this.rebalanceTimeout + ", sessionTimeout=" + this.sessionTimeout + ", subscription=" + Arrays.toString(this.subscription) + ", assignment=" + Arrays.toString(this.assignment) + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public int rebalanceTimeout() {
            return this.rebalanceTimeout;
        }

        public int sessionTimeout() {
            return this.sessionTimeout;
        }

        public byte[] subscription() {
            return this.subscription;
        }

        public byte[] assignment() {
            return this.assignment;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MemberMetadata setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public MemberMetadata setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public MemberMetadata setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public MemberMetadata setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public MemberMetadata setRebalanceTimeout(int v) {
            this.rebalanceTimeout = v;
            return this;
        }

        public MemberMetadata setSessionTimeout(int v) {
            this.sessionTimeout = v;
            return this;
        }

        public MemberMetadata setSubscription(byte[] v) {
            this.subscription = v;
            return this;
        }

        public MemberMetadata setAssignment(byte[] v) {
            this.assignment = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("member_id", Type.STRING, ""), new Field("client_id", Type.STRING, ""), new Field("client_host", Type.STRING, ""), new Field("rebalance_timeout", Type.INT32, ""), new Field("session_timeout", Type.INT32, ""), new Field("subscription", Type.BYTES, ""), new Field("assignment", Type.BYTES, ""));
            SCHEMA_3 = new Schema(new Field("member_id", Type.STRING, ""), new Field("group_instance_id", Type.NULLABLE_STRING, ""), new Field("client_id", Type.STRING, ""), new Field("client_host", Type.STRING, ""), new Field("rebalance_timeout", Type.INT32, ""), new Field("session_timeout", Type.INT32, ""), new Field("subscription", Type.BYTES, ""), new Field("assignment", Type.BYTES, ""));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

