/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.ElectionResult;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class Election$ {
    public static Election$ MODULE$;

    static {
        new Election$();
    }

    private ElectionResult leaderForOffline(TopicPartition partition, Option<LeaderAndIsr> leaderAndIsrOpt, boolean uncleanLeaderElectionEnabled, ControllerContext controllerContext) {
        ElectionResult electionResult;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        if (leaderAndIsrOpt instanceof Some) {
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)leaderAndIsrOpt).value();
            List<Object> isr = leaderAndIsr.isr();
            Option<LeaderAndIsr> newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas.toSet(), uncleanLeaderElectionEnabled, controllerContext).map((Function1<Object, LeaderAndIsr> & java.io.Serializable & Serializable)leader -> Election$.$anonfun$leaderForOffline$2(isr, controllerContext, partition, leaderAndIsr, BoxesRunTime.unboxToInt(leader)));
            electionResult = new ElectionResult(partition, newLeaderAndIsrOpt, liveReplicas);
        } else if (None$.MODULE$.equals(leaderAndIsrOpt)) {
            electionResult = new ElectionResult(partition, None$.MODULE$, liveReplicas);
        } else {
            throw new MatchError(leaderAndIsrOpt);
        }
        return electionResult;
    }

    public Seq<ElectionResult> leaderForOffline(ControllerContext controllerContext, Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState) {
        return partitionsWithUncleanLeaderElectionState.map((Function1<Tuple3, ElectionResult> & java.io.Serializable & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            Option leaderAndIsrOpt = (Option)x0$1._2();
            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean(x0$1._3());
            ElectionResult electionResult = MODULE$.leaderForOffline(partition, leaderAndIsrOpt, uncleanLeaderElectionEnabled, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForReassign(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        Seq<Object> targetReplicas = controllerContext.partitionFullReplicaAssignment(partition).targetReplicas();
        Seq liveReplicas = (Seq)targetReplicas.filter((JFunction1$mcZI$sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option<LeaderAndIsr> newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(targetReplicas, isr, liveReplicas.toSet()).map((Function1<Object, LeaderAndIsr> & java.io.Serializable & Serializable)leader -> leaderAndIsr.newLeader(BoxesRunTime.unboxToInt(leader)));
        return new ElectionResult(partition, newLeaderAndIsrOpt, targetReplicas);
    }

    public Seq<ElectionResult> leaderForReassign(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return leaderAndIsrs.map((Function1<Tuple2, ElectionResult> & java.io.Serializable & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForReassign(partition, leaderAndIsr, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForPreferredReplica(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option<LeaderAndIsr> newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas.toSet()).map((Function1<Object, LeaderAndIsr> & java.io.Serializable & Serializable)leader -> leaderAndIsr.newLeader(BoxesRunTime.unboxToInt(leader)));
        return new ElectionResult(partition, newLeaderAndIsrOpt, assignment);
    }

    public Seq<ElectionResult> leaderForPreferredReplica(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return leaderAndIsrs.map((Function1<Tuple2, ElectionResult> & java.io.Serializable & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForPreferredReplica(partition, leaderAndIsr, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ElectionResult leaderForControlledShutdown(TopicPartition partition, LeaderAndIsr leaderAndIsr, Set<Object> shuttingDownBrokerIds, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((JFunction1$mcZI$sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, true));
        List<Object> isr = leaderAndIsr.isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveOrShuttingDownReplicas.toSet(), shuttingDownBrokerIds);
        List newIsr = (List)isr.filter((JFunction1$mcZI$sp & Serializable)replica -> !shuttingDownBrokerIds.contains(BoxesRunTime.boxToInteger(replica)));
        Option<LeaderAndIsr> newLeaderAndIsrOpt = leaderOpt.map((Function1<Object, LeaderAndIsr> & java.io.Serializable & Serializable)leader -> leaderAndIsr.newLeaderAndIsr(BoxesRunTime.unboxToInt(leader), newIsr));
        return new ElectionResult(partition, newLeaderAndIsrOpt, liveOrShuttingDownReplicas);
    }

    public Seq<ElectionResult> leaderForControlledShutdown(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        Set shuttingDownBrokerIds = controllerContext.shuttingDownBrokerIds().toSet();
        return leaderAndIsrs.map((Function1<Tuple2, ElectionResult> & java.io.Serializable & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForControlledShutdown(partition, leaderAndIsr, shuttingDownBrokerIds, controllerContext);
            return electionResult;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$2(List isr$1, ControllerContext controllerContext$1, TopicPartition partition$1, LeaderAndIsr leaderAndIsr$1, int leader) {
        List newIsr = isr$1.contains(BoxesRunTime.boxToInteger(leader)) ? (List)isr$1.filter((JFunction1$mcZI$sp & Serializable)replica -> controllerContext$1.isReplicaOnline(replica, partition$1, controllerContext$1.isReplicaOnline$default$3())) : List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderAndIsr$1.newLeaderAndIsr(leader, newIsr);
    }

    private Election$() {
        MODULE$ = this;
    }
}

