/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.pinot.shaded.org.apache.kafka.clients.ApiVersions;
import org.apache.pinot.shaded.org.apache.kafka.clients.ClientDnsLookup;
import org.apache.pinot.shaded.org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.pinot.shaded.org.apache.kafka.clients.NetworkClient;
import org.apache.pinot.shaded.org.apache.kafka.common.Node;
import org.apache.pinot.shaded.org.apache.kafka.common.Reconfigurable;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ChannelBuilders;
import org.apache.pinot.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selectable;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Selector;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.security.JaasContext;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric$IntIsIntegral$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!\u0002\u0010 \u0011\u0003!c!\u0002\u0014 \u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007u\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fm\n!\u0019!C\u0001c!1A(\u0001Q\u0001\nIBq!P\u0001\u0012\u0002\u0013\u0005aH\u0002\u0003'?\u00011\u0006\u0002C2\t\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011\u001dD!\u0011!Q\u0001\n!D\u0001B\u001c\u0005\u0003\u0002\u0003\u0006Ia\u001c\u0005\tA\"\u0011\t\u0011)A\u0005w\"Q\u0011\u0011\u0001\u0005\u0003\u0002\u0003\u0006I!a\u0001\t\u0013\u0005%\u0001B!A!\u0002\u0013\u0001\u0005B\u0002\u0018\t\t\u0003\tY\u0001C\u0005\u0002\u001c!\u0011\r\u0011\"\u0005\u0002\u001e!A\u00111\b\u0005!\u0002\u0013\ty\u0002C\u0005\u0002>!\u0011\r\u0011\"\u0003\u0002@!A\u0011q\t\u0005!\u0002\u0013\t\t\u0005C\u0004\u0002J!!\t!a\u0013\t\u000f\u0005M\u0003\u0002\"\u0001\u0002L!9\u0011Q\u000b\u0005\u0005\u0002\u0005]\u0003\"CAO\u0011E\u0005I\u0011AAP\u0011\u001d\t\u0019\u000b\u0003C\u0001\u0003KCq!a.\t\t\u0003\tI\fC\u0004\u0002>\"!I!a0\t\u000f\u0005\r\u0007\u0002\"\u0003\u0002F\"9\u0011Q\u001b\u0005\u0005\n\u0005]\u0007bBAo\u0011\u0011E\u0011q\\\u0001\u0019\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u0011\"\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005y\"\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0013aE)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t11\u000b\u001e:j]\u001e\fA#U;fk\u0016\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0017A\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0002\u007f)\u0012\u0001)\u0014\t\u0004S\u0005\u001b\u0015B\u0001\"+\u0005\u0019y\u0005\u000f^5p]B\u0011Ai\u0013\b\u0003\u000b&\u0003\"A\u0012\u0016\u000e\u0003\u001dS!\u0001S\u0012\u0002\rq\u0012xn\u001c;?\u0013\tQ%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003s1S!A\u0013\u0016,\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u0013Ut7\r[3dW\u0016$'BA*+\u0003)\tgN\\8uCRLwN\\\u0005\u0003+B\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\u0011A\u0001fV/\u0011\u0005a[V\"A-\u000b\u0005i\u000b\u0013!B;uS2\u001c\u0018B\u0001/Z\u0005\u001daunZ4j]\u001e\u0004\"AX1\u000e\u0003}S!\u0001Y\u0011\u0002\u000f5,GO]5dg&\u0011!m\u0018\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011Q%Z\u0005\u0003M~\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.I\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055T'aC&bM.\f7i\u001c8gS\u001e\fA\u0001^5nKB\u0011\u0001/_\u0007\u0002c*\u0011!L\u001d\u0006\u0003gR\faaY8n[>t'B\u0001\u0012v\u0015\t1x/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0006\u0019qN]4\n\u0005i\f(\u0001\u0002+j[\u0016\u0004\"\u0001 @\u000e\u0003uT!\u0001\u0019:\n\u0005}l(aB'fiJL7m]\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bcA\u0013\u0002\u0006%\u0019\u0011qA\u0010\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqRq\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001CA\u0013\t\u0011\u0015\u0019w\u00021\u0001e\u0011\u00159w\u00021\u0001i\u0011\u0015qw\u00021\u0001p\u0011\u0015\u0001w\u00021\u0001|\u0011\u001d\t\ta\u0004a\u0001\u0003\u0007A\u0001\"!\u0003\u0010!\u0003\u0005\r\u0001Q\u0001\u0010EJ|7.\u001a:Ti\u0006$X-\u00138g_V\u0011\u0011q\u0004\t\t\u0003C\tY#a\f\u000265\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0004nkR\f'\r\\3\u000b\u0007\u0005%\"&\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002$\t9\u0001*Y:i\u001b\u0006\u0004\bcA\u0015\u00022%\u0019\u00111\u0007\u0016\u0003\u0007%sG\u000fE\u0002&\u0003oI1!!\u000f \u0005e\u0019uN\u001c;s_2dWM\u001d\"s_.,'o\u0015;bi\u0016LeNZ8\u0002!\t\u0014xn[3s'R\fG/Z%oM>\u0004\u0013A\u00032s_.,'\u000fT8dWV\u0011\u0011\u0011\t\t\u0004g\u0005\r\u0013bAA#i\t1qJ\u00196fGR\f1B\u0019:pW\u0016\u0014Hj\\2lA\u000591\u000f^1siV\u0004HCAA'!\rI\u0013qJ\u0005\u0004\u0003#R#\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0005\u0002N\u0005e\u0013QLAG\u0011\u001d\tYF\u0006a\u0001\u0003_\t\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003?2\u0002\u0019AA1\u0003\u001d\u0011X-];fgR\u0004D!a\u0019\u0002|A1\u0011QMA9\u0003orA!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u0012\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u0005=\u0014\u0011N\u0001\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti&!\u00111OA;\u0005\u001d\u0011U/\u001b7eKJTA!a\u001c\u0002jA!\u0011\u0011PA>\u0019\u0001!A\"! \u0002^\u0005\u0005\t\u0011!B\u0001\u0003\u007f\u00121a\u0018\u00132#\u0011\t\t)a\"\u0011\u0007%\n\u0019)C\u0002\u0002\u0006*\u0012qAT8uQ&tw\r\u0005\u0003\u0002h\u0005%\u0015\u0002BAF\u0003S\u0012a#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f\u001e\u0005\n\u0003\u001f3\u0002\u0013!a\u0001\u0003#\u000b\u0001bY1mY\n\f7m\u001b\t\bS\u0005M\u0015qSA'\u0013\r\t)J\u000b\u0002\n\rVt7\r^5p]F\u0002B!a\u001a\u0002\u001a&!\u00111TA5\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX-A\u000btK:$'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005&fAAI\u001b\u0006I\u0011\r\u001a3Ce>\\WM\u001d\u000b\u0005\u0003\u001b\n9\u000bC\u0004\u0002*b\u0001\r!a+\u0002\r\t\u0014xn[3s!\u0011\ti+a-\u000e\u0005\u0005=&bAAYC\u000591\r\\;ti\u0016\u0014\u0018\u0002BA[\u0003_\u0013aA\u0011:pW\u0016\u0014\u0018\u0001\u0004:f[>4XM\u0011:pW\u0016\u0014H\u0003BA'\u0003wCq!a\u0017\u001a\u0001\u0004\ty#\u0001\u0007bI\u0012tUm\u001e\"s_.,'\u000f\u0006\u0003\u0002N\u0005\u0005\u0007bBAU5\u0001\u0007\u00111V\u0001\u0011EJ|7.\u001a:NKR\u0014\u0018n\u0019+bON$B!a2\u0002TB1\u0011\u0011ZAheIj!!a3\u000b\t\u00055\u0017qE\u0001\nS6lW\u000f^1cY\u0016LA!!5\u0002L\n\u0019Q*\u00199\t\u000f\u0005m3\u00041\u0001\u00020\u0005!\"/Z7pm\u0016,\u00050[:uS:<'I]8lKJ$B!!\u0014\u0002Z\"9\u00111\u001c\u000fA\u0002\u0005U\u0012a\u00032s_.,'o\u0015;bi\u0016\fac\u001d;beR\u0014V-];fgR\u001cVM\u001c3UQJ,\u0017\r\u001a\u000b\u0005\u0003\u001b\n\t\u000fC\u0004\u0002\\u\u0001\r!a\f")
public class ControllerChannelManager
implements KafkaMetricsGroup {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return ControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return ControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public void startup() {
        this.controllerContext.liveOrShuttingDownBrokers().foreach((Function1<Broker, Object> & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1<ControllerBrokerStateInfo, Object> & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option<ControllerBrokerStateInfo> stateInfoOpt = this.brokerStateInfo().get(BoxesRunTime.boxToInteger(brokerId));
            if (stateInfoOpt instanceof Some) {
                ((ControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new QueueItem(request.apiKey(), request, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Not sending request ").append(request).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError(stateInfoOpt);
            }
            return;
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains(BoxesRunTime.boxToInteger(broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker(this.brokerStateInfo().apply(BoxesRunTime.boxToInteger(brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addNewBroker(Broker broker) {
        String string;
        void var12_11;
        void var11_10;
        Option option;
        LinkedBlockingQueue<QueueItem> messageQueue = new LinkedBlockingQueue<QueueItem>();
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0<ListenerName> & Serializable & scala.Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)((Object)this.config.controlPlaneSecurityProtocol().getOrElse((Function0<SecurityProtocol> & Serializable & scala.Serializable)() -> $this.config.interBrokerSecurityProtocol()));
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(controllerToBrokerSecurityProtocol, JaasContext.Type.SERVER, this.config, controllerToBrokerListenerName, this.config.saslMechanismInterBrokerProtocol(), this.time, this.config.saslInterBrokerHandshakeRequestEnable(), logContext);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)((Object)channelBuilder));
            option = new Some<ChannelBuilder>(channelBuilder);
        } else {
            option = None$.MODULE$;
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(CollectionConverters$.MODULE$.seqAsJavaListConverter(new $colon$colon<Nothing$>((Nothing$)((Object)brokerNode), Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), ClientDnsLookup.USE_ALL_DNS_IPS, this.time, false, new ApiVersions(), logContext);
        Option reconfigurableChannelBuilder = option;
        void networkClient2 = var11_10;
        void reconfigurableChannelBuilder2 = var12_11;
        Option<String> option2 = this.threadNamePrefix;
        if (None$.MODULE$.equals(option2)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option2 instanceof Some) {
            String name = (String)((Some)option2).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option2);
        }
        Timer requestRateAndQueueTimeMetrics = this.newTimer(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerContext, messageQueue, (NetworkClient)networkClient2, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, string);
        requestThread.setDaemon(false);
        Gauge<Object> queueSizeGauge = this.newGauge(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ ControllerChannelManager $outer;
            private final LinkedBlockingQueue messageQueue$1;

            public final int value() {
                return ControllerChannelManager.kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(this.messageQueue$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put(BoxesRunTime.boxToInteger(broker.id()), new ControllerBrokerStateInfo((NetworkClient)networkClient2, brokerNode, messageQueue, requestThread, queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)reconfigurableChannelBuilder2));
    }

    private scala.collection.immutable.Map<String, String> brokerMetricTags(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), Integer.toString(brokerId))}));
    }

    private void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1<Reconfigurable, Object> & Serializable & scala.Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.removeMetric(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.removeMetric(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove(BoxesRunTime.boxToInteger(brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void startRequestSendThread(int brokerId) {
        block7: {
            RequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = this.brokerStateInfo().apply(BoxesRunTime.boxToInteger(brokerId)).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(ControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt(this.brokerStateInfo().values().iterator().map((Function1<ControllerBrokerStateInfo, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(ControllerChannelManager.$anonfun$new$2(x$1))).sum(Numeric$IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(LinkedBlockingQueue messageQueue$1) {
        return messageQueue$1.size();
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerContext = controllerContext;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.newGauge("TotalQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

