/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.LeaderElectionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.Admin;
import org.apache.pinot.shaded.org.apache.kafka.common.ElectionType;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.TimeoutException;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class LeaderElectionCommand$
implements Logging {
    public static LeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        this.run(args, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = commandOptions.options().valueOf(commandOptions.electionType());
        jsonFileTopicPartitions = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.pathToJsonFile())).map((Function1<String, scala.collection.immutable.Set> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$1(java.lang.String ), (Ljava/lang/String;)Lscala/collection/immutable/Set;)());
        var15_6 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.partition()));
        var7_7 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.topic()));
        var8_8 = var15_6;
        if (!(var7_7 instanceof Some)) ** GOTO lbl-1000
        topic = (String)((Some)var7_7).value();
        if (var8_8 instanceof Some) {
            partition = (Integer)((Some)var8_8).value();
            var3_11 /* !! */  = new Some<CC>(Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition))})));
        } else lbl-1000:
        // 2 sources

        {
            var3_11 /* !! */  = None$.MODULE$;
        }
        topicPartitions = jsonFileTopicPartitions.orElse((Function0<Option> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$2(scala.Option ), ()Lscala/Option;)((Option)var3_11 /* !! */ ));
        props = (Properties)Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.adminClientConfig())).map((Function1<String, Properties> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$3(java.lang.String ), (Ljava/lang/String;)Ljava/util/Properties;)()).getOrElse((Function0<Properties> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$4(), ()Ljava/util/Properties;)());
        props.setProperty("bootstrap.servers", commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("default.api.timeout.ms", Long.toString(timeout.toMillis()));
        props.setProperty("request.timeout.ms", Long.toString(timeout.toMillis() / 2L));
        adminClient = Admin.create(props);
        try {
            this.electLeaders(adminClient, electionType, topicPartitions);
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Set<TopicPartition> parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer partitions = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, TopicPartition> & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt(p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (!duplicatePartitions.nonEmpty()) return partitions.toSet();
                throw new AdminOperationException(new StringBuilder(53).append("Replica election data contains duplicate partitions: ").append(duplicatePartitions.mkString(",")).toString());
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            throw new AdminOperationException("Replica election data is missing \"partitions\" field");
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("Replica election data is empty");
    }

    /*
     * WARNING - void declaration
     */
    private void electLeaders(Admin client, ElectionType electionType, Option<scala.collection.immutable.Set<TopicPartition>> topicPartitions) {
        scala.collection.mutable.Map<TopicPartition, Optional<Throwable>> map;
        try {
            Set partitions = (Set)topicPartitions.map((Function1<scala.collection.immutable.Set, Set> & Serializable & scala.Serializable)x$2 -> CollectionConverters$.MODULE$.setAsJavaSetConverter(x$2).asJava()).orNull(Predef$.MODULE$.$conforms());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(LeaderElectionCommand$.$anonfun$electLeaders$2(electionType, partitions)));
            }
            map = CollectionConverters$.MODULE$.mapAsScalaMapConverter(client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Predef$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Predef$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println("Error while making request");
            throw e;
        }
        scala.collection.mutable.Map<TopicPartition, Optional<Throwable>> electionResults = map;
        GenTraversable succeeded = Set$.MODULE$.empty();
        GenTraversable noop = Set$.MODULE$.empty();
        GenMap failed = Map$.MODULE$.empty();
        electionResults.foreach(arg_0 -> LeaderElectionCommand$.$anonfun$electLeaders$3$adapted((scala.collection.mutable.Set)noop, (scala.collection.mutable.Map)failed, (scala.collection.mutable.Set)succeeded, arg_0));
        if (succeeded.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println(new StringBuilder(57).append("Successfully completed leader election (").append((Object)electionType).append(") for partitions ").append(partitions).toString());
        }
        if (noop.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println(new StringBuilder(45).append("Valid replica already elected for partitions ").append(partitions).toString());
        }
        if (failed.nonEmpty()) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringBuilder(32).append(failed.size()).append(" replica(s) could not be elected").toString());
            Function2<TopicPartition, Throwable, Object> & Serializable & scala.Serializable intersect = (Function2<TopicPartition, Throwable, Object> & Serializable & scala.Serializable)(topicPartition, exception) -> {
                LeaderElectionCommand$.$anonfun$electLeaders$4(electionType, rootException, topicPartition, exception);
                return BoxedUnit.UNIT;
            };
            Map map2 = Implicits$.MODULE$.MapExtensionMethods(failed);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods(forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            throw rootException;
        }
    }

    private void validate(LeaderElectionCommandOptions commandOptions) {
        List<String> missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon(string);
        }
        if (!commandOptions.options().has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = missingOptions.$colon$colon(string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        $colon$colon<Nothing$> mutuallyExclusiveOptions = new $colon$colon<Nothing$>((Nothing$)((Object)commandOptions.topic()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)commandOptions.allTopicPartitions()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)commandOptions.pathToJsonFile()), Nil$.MODULE$)));
        switch (mutuallyExclusiveOptions.count(arg_0 -> LeaderElectionCommand$.$anonfun$validate$1$adapted(commandOptions.options(), arg_0))) {
            case 1: {
                break;
            }
            default: {
                throw new AdminCommandFailedException(new StringBuilder(55).append("One and only one of the following options is required: ").append(((TraversableOnce)mutuallyExclusiveOptions.map((Function1<AbstractOptionSpec, String> & Serializable & scala.Serializable)x$5 -> (String)x$5.options().get(0), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            }
        }
        boolean bl = commandOptions.options().has(commandOptions.partition());
        boolean bl2 = commandOptions.options().has(commandOptions.topic());
        if (bl2 && !bl) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(commandOptions.partition().options().get(0)).toString());
        }
        if (!bl2 && bl) {
            throw new AdminCommandFailedException(new StringBuilder(35).append("Option ").append(commandOptions.partition().options().get(0)).append(" is only allowed if ").append(commandOptions.topic().options().get(0)).append(" is used").toString());
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$run$1(String path) {
        return MODULE$.parseReplicaElectionData(Utils.readFileAsString(path));
    }

    public static final /* synthetic */ Option $anonfun$run$2(Option singleTopicPartition$1) {
        return singleTopicPartition$1;
    }

    public static final /* synthetic */ Properties $anonfun$run$3(String config) {
        return Utils.loadProps(config);
    }

    public static final /* synthetic */ Properties $anonfun$run$4() {
        return new Properties();
    }

    public static final /* synthetic */ String $anonfun$electLeaders$2(ElectionType electionType$1, Set partitions$1) {
        return new StringBuilder(36).append("Calling AdminClient.electLeaders(").append((Object)electionType$1).append(", ").append(partitions$1).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$electLeaders$3(scala.collection.mutable.Set noop$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Optional error = (Optional)x0$1._2();
            if (error.isPresent()) {
                if ((Throwable)error.get() instanceof ElectionNotNeededException) {
                    noop$1.$plus$eq(topicPartition);
                    return;
                }
                failed$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), error.get()));
                return;
            }
            succeeded$1.$plus$eq(topicPartition);
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$electLeaders$4(ElectionType electionType$1, AdminCommandFailedException rootException$1, TopicPartition topicPartition, Throwable exception) {
        Predef$.MODULE$.println(new StringBuilder(53).append("Error completing leader election (").append((Object)electionType$1).append(") for partition: ").append(topicPartition).append(": ").append(exception).toString());
        rootException$1.addSuppressed(exception);
    }

    private LeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$electLeaders$3$adapted(scala.collection.mutable.Set noop$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        LeaderElectionCommand$.$anonfun$electLeaders$3(noop$1, failed$1, succeeded$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$validate$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }
}

