/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;


/**
 * AST node for a list of columns.
 */
public class OutputColumnListAstNode extends BaseAstNode {
  private boolean _star;

  public boolean isStar() {
    return _star;
  }

  @Override
  public void addChild(AstNode childNode) {
    if (childNode instanceof StarColumnListAstNode) {
      _star = true;
    } else {
      super.addChild(childNode);
    }
  }

  @Override
  public void updateBrokerRequest(BrokerRequest brokerRequest) {
    sendBrokerRequestUpdateToChildren(brokerRequest);
  }

  @Override
  public void updatePinotQuery(PinotQuery pinotQuery) {
    sendPinotQueryUpdateToChildren(pinotQuery);
  }
}
