/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.pinot.shaded.io.netty.channel.Channel;
import org.apache.pinot.shaded.io.netty.channel.ChannelOption;
import org.apache.pinot.shaded.io.netty.handler.logging.LogLevel;
import org.apache.pinot.shaded.io.netty.handler.logging.LoggingHandler;
import org.apache.pinot.shaded.io.netty.resolver.AddressResolverGroup;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpResources;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.annotation.Nullable;

public final class TcpClientConfig
extends ClientTransportConfig<TcpClientConfig> {
    SslProvider sslProvider;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(TcpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("reactor.netty.tcp.ssl.client.debug", "false"));

    @Override
    public int channelHash() {
        return Objects.hash(super.channelHash(), this.sslProvider);
    }

    @Override
    public ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    public final boolean isSecure() {
        return this.sslProvider != null;
    }

    @Nullable
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    TcpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    TcpClientConfig(TcpClientConfig parent) {
        super(parent);
        this.sslProvider = parent.sslProvider;
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return TcpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return TcpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerTcpClientMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        ChannelPipelineConfigurer _default = super.defaultOnChannelInit();
        if (this.sslProvider != null) {
            return _default.then(new TcpClientChannelInitializer(this.sslProvider));
        }
        return _default;
    }

    static final class TcpClientChannelInitializer
    implements ChannelPipelineConfigurer {
        final SslProvider sslProvider;

        TcpClientChannelInitializer(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress remoteAddress) {
            this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
        }
    }

    static final class MicrometerTcpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerTcpClientMetricsRecorder INSTANCE = new MicrometerTcpClientMetricsRecorder();

        MicrometerTcpClientMetricsRecorder() {
            super("reactor.netty.tcp.client", "tcp");
        }
    }
}

