/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import java.util.Map;
import org.apache.pinot.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pinot.shaded.io.netty.channel.Channel;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandler;
import org.apache.pinot.shaded.io.netty.channel.ChannelPipeline;
import org.apache.pinot.shaded.io.netty.handler.ssl.SniHandler;
import org.apache.pinot.shaded.io.netty.handler.ssl.SslContext;
import org.apache.pinot.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.pinot.shaded.io.netty.util.DomainWildcardMappingBuilder;
import org.apache.pinot.shaded.io.netty.util.Mapping;
import reactor.netty.tcp.SslProvider;

final class SniProvider {
    final Map<String, SslProvider> confPerDomainName;
    final SslProvider defaultSslProvider;

    void addSniHandler(Channel channel, boolean sslDebug) {
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get("reactor.left.nonSslRedirectDetector") != null) {
            pipeline.addAfter("reactor.left.nonSslRedirectDetector", "reactor.left.sslHandler", this.newSniHandler());
        } else {
            pipeline.addFirst("reactor.left.sslHandler", (ChannelHandler)this.newSniHandler());
        }
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    SniProvider(Map<String, SslProvider> confPerDomainName, SslProvider defaultSslProvider) {
        this.confPerDomainName = confPerDomainName;
        this.defaultSslProvider = defaultSslProvider;
    }

    SniHandler newSniHandler() {
        DomainWildcardMappingBuilder<SslContext> mappingsContextBuilder = new DomainWildcardMappingBuilder<SslContext>(this.defaultSslProvider.getSslContext());
        this.confPerDomainName.forEach((s, sslProvider) -> mappingsContextBuilder.add((String)s, sslProvider.getSslContext()));
        DomainWildcardMappingBuilder<SslProvider> mappingsSslProviderBuilder = new DomainWildcardMappingBuilder<SslProvider>(this.defaultSslProvider);
        this.confPerDomainName.forEach(mappingsSslProviderBuilder::add);
        return new AdvancedSniHandler(mappingsSslProviderBuilder.build(), this.defaultSslProvider, mappingsContextBuilder.build());
    }

    static final class AdvancedSniHandler
    extends SniHandler {
        final Mapping<? super String, ? extends SslProvider> confPerDomainName;
        final SslProvider defaultSslProvider;

        AdvancedSniHandler(Mapping<? super String, ? extends SslProvider> confPerDomainName, SslProvider defaultSslProvider, Mapping<? super String, ? extends SslContext> mappings) {
            super(mappings);
            this.confPerDomainName = confPerDomainName;
            this.defaultSslProvider = defaultSslProvider;
        }

        @Override
        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
            SslHandler sslHandler = super.newSslHandler(context, allocator);
            String hostName = this.hostname();
            if (hostName == null) {
                this.defaultSslProvider.configure(sslHandler);
            } else {
                this.confPerDomainName.map(this.hostname()).configure(sslHandler);
            }
            return sslHandler;
        }
    }
}

