/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.websocket;

import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pinot.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import org.apache.pinot.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.pinot.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyInbound;
import reactor.util.annotation.Nullable;

public interface WebsocketInbound
extends NettyInbound {
    @Nullable
    public String selectedSubprotocol();

    public HttpHeaders headers();

    public Mono<WebSocketCloseStatus> receiveCloseStatus();

    default public WebsocketInbound aggregateFrames() {
        return this.aggregateFrames(65536);
    }

    default public WebsocketInbound aggregateFrames(int maxContentLength) {
        this.withConnection(c -> c.addHandlerLast("reactor.left.wsFrameAggregator", new WebSocketFrameAggregator(maxContentLength)));
        return this;
    }

    default public Flux<WebSocketFrame> receiveFrames() {
        return this.receiveObject().ofType(WebSocketFrame.class);
    }
}

