/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import java.util.function.Function;
import org.apache.pinot.shaded.io.netty.buffer.ByteBuf;
import org.apache.pinot.shaded.io.netty.buffer.ByteBufHolder;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.shaded.io.netty.channel.ChannelPromise;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpMessage;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.pinot.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pinot.shaded.io.netty.util.concurrent.Future;
import org.apache.pinot.shaded.io.netty.util.concurrent.GenericFutureListener;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpInfos;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogArgProviderH1;
import reactor.netty.http.server.logging.BaseAccessLogHandler;
import reactor.util.annotation.Nullable;

final class AccessLogHandlerH1
extends BaseAccessLogHandler {
    AccessLogArgProviderH1 accessLogArgProvider;

    AccessLogHandlerH1(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH1(ctx.channel().remoteAddress());
            }
            this.accessLogArgProvider.request(request);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            ChannelOperations<?, ?> ops;
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked(response);
            this.accessLogArgProvider.response(response).chunked(chunked);
            if (!chunked) {
                this.accessLogArgProvider.contentLength(HttpUtil.getContentLength((HttpMessage)response, -1));
            }
            if ((ops = ChannelOperations.get(ctx.channel())) instanceof HttpInfos) {
                this.accessLogArgProvider.cookies(((HttpInfos)((Object)ops)).cookies());
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLogArgProvider.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    AccessLog log = (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                    if (log != null) {
                        log.log();
                    }
                    this.accessLogArgProvider.clear();
                }
            }));
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLogArgProvider.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLogArgProvider.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

