/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import java.net.SocketAddress;
import java.util.Objects;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpResponse;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import reactor.util.annotation.Nullable;

final class AccessLogArgProviderH1
extends AbstractAccessLogArgProvider<AccessLogArgProviderH1> {
    HttpRequest request;
    HttpResponse response;

    AccessLogArgProviderH1(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH1 request(HttpRequest request) {
        this.request = Objects.requireNonNull(request, "request");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH1 response(HttpResponse response) {
        this.response = Objects.requireNonNull(response, "response");
        return this.get();
    }

    @Override
    @Nullable
    public CharSequence status() {
        return this.response == null ? null : this.response.status().codeAsText();
    }

    @Override
    @Nullable
    public CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.request == null ? null : this.request.headers().get(name);
    }

    @Override
    @Nullable
    public CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.response == null ? null : this.response.headers().get(name);
    }

    @Override
    void onRequest() {
        super.onRequest();
        if (this.request != null) {
            this.method = this.request.method().name();
            this.uri = this.request.uri();
            this.protocol = this.request.protocolVersion().text();
        }
    }

    @Override
    void clear() {
        super.clear();
        this.request = null;
        this.response = null;
    }

    AccessLogArgProviderH1 contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.get();
    }

    @Override
    public AccessLogArgProviderH1 get() {
        return this;
    }
}

