/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import javax.annotation.Nullable;
import org.apache.pinot.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pinot.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpResponseStatus;

final class NonSslRedirectHandler
extends ChannelInboundHandlerAdapter {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    NonSslRedirectHandler() {
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            ctx.pipeline().remove(this);
            HttpRequest request = (HttpRequest)msg;
            String url = this.getRequestedUrlInHttps(request);
            if (url == null) {
                ctx.close();
            } else {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.PERMANENT_REDIRECT);
                response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url);
                ctx.channel().writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Nullable
    private String getRequestedUrlInHttps(HttpRequest request) {
        String uri = request.uri();
        boolean isAbsoluteUri = uri.startsWith(HTTP_PROTOCOL);
        if (isAbsoluteUri) {
            return HTTPS_PROTOCOL + uri.substring(HTTP_PROTOCOL.length());
        }
        String host = request.headers().get(HttpHeaderNames.HOST);
        if (host == null) {
            return null;
        }
        return HTTPS_PROTOCOL + host + uri;
    }
}

