/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.util.Objects;
import org.apache.pinot.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import reactor.netty.http.client.WebsocketClientSpecImpl;
import reactor.netty.http.websocket.WebsocketSpec;

public interface WebsocketClientSpec
extends WebsocketSpec {
    public WebSocketVersion version();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WebsocketSpec.Builder<Builder> {
        WebSocketVersion version = WebSocketVersion.V13;

        private Builder() {
        }

        public final Builder version(WebSocketVersion version) {
            Objects.requireNonNull(version, "version");
            if (WebSocketVersion.UNKNOWN.equals((Object)version)) {
                throw new IllegalArgumentException("WebSocketVersion.UNKNOWN represents an invalid version, please provide a proper version");
            }
            this.version = version;
            return this;
        }

        public final WebsocketClientSpec build() {
            return new WebsocketClientSpecImpl(this);
        }
    }
}

