/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.file;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.internal.avro.implementation.AvroConstants;
import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AvroHeaderSchema
extends AvroCompositeSchema {
    private final ClientLogger logger = new ClientLogger(AvroHeaderSchema.class);
    private static final String HEADER_SCHEMA = "{\"type\": \"record\", \"name\": \"org.apache.avro.file.Header\",\n \"fields\" : [\n   {\"name\": \"magic\", \"type\": {\"type\": \"fixed\", \"name\": \"Magic\", \"size\": 4}},\n   {\"name\": \"meta\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},\n   {\"name\": \"sync\", \"type\": {\"type\": \"fixed\", \"name\": \"Sync\", \"size\": 16}}\n  ]\n}";

    public AvroHeaderSchema(AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroType headerType = AvroType.getType(HEADER_SCHEMA);
        AvroSchema headerSchema = AvroSchema.getSchema(headerType, this.state, this::onHeader);
        headerSchema.pushToStack();
    }

    private void onHeader(Object header) {
        AvroHeaderSchema.checkType("header", header, Map.class);
        Map h = (Map)header;
        this.validateMagic(h.get("magic"));
        LinkedHashMap<String, Object> filteredHeader = new LinkedHashMap<String, Object>();
        filteredHeader.put("meta", this.parseMeta(h.get("meta")));
        filteredHeader.put("sync", this.convertSync(h.get("sync")));
        this.result = filteredHeader;
        this.done = true;
    }

    private void validateMagic(Object magic) {
        AvroHeaderSchema.checkType("magic", magic, List.class);
        byte[] init = AvroSchema.getBytes((List)magic);
        for (int i = 0; i < AvroConstants.MAGIC_BYTES.size(); ++i) {
            if (AvroConstants.MAGIC_BYTES.get(i).equals(init[i])) continue;
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Invalid Avro file."));
        }
    }

    private AvroType parseMeta(Object meta) {
        AvroHeaderSchema.checkType("meta", meta, Map.class);
        Map m = (Map)meta;
        Object codecString = m.get("avro.codec");
        if (codecString != null && !codecString.equals("null")) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Codec is not supported"));
        }
        String schemaString = m.get("avro.schema").toString();
        return AvroType.getType(schemaString);
    }

    private byte[] convertSync(Object sync) {
        AvroHeaderSchema.checkType("sync", sync, List.class);
        return AvroSchema.getBytes((List)sync);
    }
}

