/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation.schema.file;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.internal.avro.implementation.AvroObject;
import com.azure.storage.internal.avro.implementation.AvroParserState;
import com.azure.storage.internal.avro.implementation.schema.AvroCompositeSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.AvroType;
import com.azure.storage.internal.avro.implementation.schema.complex.AvroFixedSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroLongSchema;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class AvroBlockSchema
extends AvroCompositeSchema {
    private final ClientLogger logger = new ClientLogger(AvroBlockSchema.class);
    private final Consumer<Object> onAvroObject;
    private final AvroType objectType;
    private Long blockCount;
    private final Long beginObjectIndex;
    private long objectIndex;
    private long blockOffset;
    private final byte[] syncMarker;

    public AvroBlockSchema(AvroType objectType, Long beginObjectIndex, Consumer<Object> onAvroObject, byte[] syncMarker, AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
        this.objectType = objectType;
        this.beginObjectIndex = beginObjectIndex;
        this.objectIndex = 0L;
        this.blockOffset = this.state.getSourceOffset();
        this.onAvroObject = onAvroObject;
        this.syncMarker = (byte[])syncMarker.clone();
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
        AvroLongSchema blockCountSchema = new AvroLongSchema(this.state, this::onBlockCount);
        blockCountSchema.pushToStack();
    }

    private void onBlockCount(Object blockCount) {
        AvroBlockSchema.checkType("blockCount", blockCount, Long.class);
        this.blockCount = (Long)blockCount;
        AvroLongSchema blockSizeSchema = new AvroLongSchema(this.state, this::onBlockSize);
        blockSizeSchema.pushToStack();
    }

    private void onBlockSize(Object blockSize) {
        AvroSchema objectSchema = AvroSchema.getSchema(this.objectType, this.state, this::onObject);
        objectSchema.pushToStack();
    }

    private void onObject(Object schema) {
        Long l = this.blockCount;
        Long l2 = this.blockCount = Long.valueOf(this.blockCount - 1L);
        if (this.objectIndex < this.beginObjectIndex) {
            ++this.objectIndex;
        } else {
            long nextObjectIndex;
            long nextBlockOffset;
            if (this.hasNext()) {
                nextBlockOffset = this.blockOffset;
                nextObjectIndex = this.objectIndex + 1L;
            } else {
                nextBlockOffset = this.state.getSourceOffset() + 16L;
                nextObjectIndex = 0L;
            }
            this.onAvroObject.accept(new AvroObject(this.blockOffset, this.objectIndex++, nextBlockOffset, nextObjectIndex, schema));
        }
        if (this.hasNext()) {
            AvroSchema objectSchema = AvroSchema.getSchema(this.objectType, this.state, this::onObject);
            objectSchema.pushToStack();
        } else {
            AvroFixedSchema syncSchema = new AvroFixedSchema(16L, this.state, this::validateSync);
            syncSchema.pushToStack();
        }
    }

    private void validateSync(Object sync) {
        AvroBlockSchema.checkType("sync", sync, List.class);
        byte[] syncBytes = AvroSchema.getBytes((List)sync);
        if (!Arrays.equals(syncBytes, this.syncMarker)) {
            throw this.logger.logExceptionAsError(new IllegalStateException("Sync marker validation failed."));
        }
        this.done = true;
        this.result = 0L;
    }

    public boolean hasNext() {
        return this.blockCount != 0L;
    }
}

