/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.BlobLeaseClient;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.specialized.DataLakeLeaseClientBuilder;
import java.time.Duration;

@ServiceClient(builder=DataLakeLeaseClientBuilder.class)
public final class DataLakeLeaseClient {
    private final ClientLogger logger = new ClientLogger(DataLakeLeaseClient.class);
    private final BlobLeaseClient blobLeaseClient;

    DataLakeLeaseClient(BlobLeaseClient blobLeaseClient) {
        this.blobLeaseClient = blobLeaseClient;
    }

    public String getResourceUrl() {
        return this.blobLeaseClient.getResourceUrl();
    }

    public String getLeaseId() {
        return this.blobLeaseClient.getLeaseId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String acquireLease(int duration) {
        return this.acquireLeaseWithResponse(duration, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobLeaseClient.acquireLeaseWithResponse(duration, modifiedRequestConditions, timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String renewLease() {
        return this.renewLeaseWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobLeaseClient.renewLeaseWithResponse(modifiedRequestConditions, timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease() {
        this.releaseLeaseWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobLeaseClient.releaseLeaseWithResponse(modifiedRequestConditions, timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Integer breakLease() {
        return this.breakLeaseWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Integer> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobLeaseClient.breakLeaseWithResponse(breakPeriodInSeconds, modifiedRequestConditions, timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobLeaseClient.changeLeaseWithResponse(proposedId, modifiedRequestConditions, timeout, context), this.logger);
    }

    public String getAccountName() {
        return this.blobLeaseClient.getAccountName();
    }
}

