/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.RolePermissions;
import java.util.Locale;
import java.util.Objects;

public class PathPermissions {
    private final ClientLogger logger = new ClientLogger(PathPermissions.class);
    private static final String PATH_PERMISSIONS_OCTAL_FORMAT_ERROR = "String cannot be null and must be four characters (first bit--sticky bit--must be set to 0 for umask).";
    private static final String PATH_PERMISSIONS_SYMBOLIC_FORMAT_ERROR = "Invalid format. The only character that may validly follow the permissions string is '+'.";
    private RolePermissions owner = new RolePermissions();
    private RolePermissions group = new RolePermissions();
    private RolePermissions other = new RolePermissions();
    private boolean stickyBit;
    private boolean extendedInfoInAcl;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPermissions that = (PathPermissions)o;
        if (this.stickyBit != that.stickyBit) {
            return false;
        }
        if (this.extendedInfoInAcl != that.extendedInfoInAcl) {
            return false;
        }
        if (!Objects.equals(this.owner, that.owner)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        return Objects.equals(this.other, that.other);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.other != null ? this.other.hashCode() : 0);
        result = 31 * result + (this.stickyBit ? 1 : 0);
        result = 31 * result + (this.extendedInfoInAcl ? 1 : 0);
        return result;
    }

    public static PathPermissions parseOctal(String octal) {
        StorageImplUtils.assertNotNull("octal", octal);
        if (octal.length() != 4) {
            throw new IllegalArgumentException(PATH_PERMISSIONS_OCTAL_FORMAT_ERROR);
        }
        PathPermissions res = new PathPermissions();
        res.stickyBit = octal.charAt(0) != '0';
        res.owner = RolePermissions.parseOctal(Integer.parseInt(octal.charAt(1) + ""));
        res.group = RolePermissions.parseOctal(Integer.parseInt(octal.charAt(2) + ""));
        res.other = RolePermissions.parseOctal(Integer.parseInt(octal.charAt(3) + ""));
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathPermissions parseSymbolic(String str) {
        StorageImplUtils.assertNotNull("str", str);
        StorageImplUtils.assertInBounds("str.length", str.length(), 9L, 10L);
        PathPermissions res = new PathPermissions();
        int stickyBitPos = 8;
        res.stickyBit = str.toLowerCase(Locale.ROOT).charAt(stickyBitPos) == 't';
        res.owner = RolePermissions.parseSymbolic(str.substring(0, 3), false);
        res.group = RolePermissions.parseSymbolic(str.substring(3, 6), false);
        res.other = RolePermissions.parseSymbolic(str.substring(6, 9), true);
        if (str.length() == 10) {
            if (str.charAt(9) != '+') throw new IllegalArgumentException(PATH_PERMISSIONS_SYMBOLIC_FORMAT_ERROR);
            res.extendedInfoInAcl = true;
            return res;
        } else {
            res.extendedInfoInAcl = false;
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.stickyBit) {
            sb.append(1);
        } else {
            sb.append(0);
        }
        sb.append(this.owner.toOctal());
        sb.append(this.group.toOctal());
        sb.append(this.other.toOctal());
        return sb.toString();
    }

    public RolePermissions getOwner() {
        return this.owner;
    }

    public RolePermissions getGroup() {
        return this.group;
    }

    public RolePermissions getOther() {
        return this.other;
    }

    public PathPermissions setOwner(RolePermissions owner) {
        this.owner = owner;
        return this;
    }

    public PathPermissions setGroup(RolePermissions group) {
        this.group = group;
        return this;
    }

    public PathPermissions setOther(RolePermissions other) {
        this.other = other;
        return this;
    }

    public boolean isStickyBitSet() {
        return this.stickyBit;
    }

    public PathPermissions setStickyBit(boolean hasStickyBit) {
        this.stickyBit = hasStickyBit;
        return this;
    }

    public boolean isExtendedInfoInAcl() {
        return this.extendedInfoInAcl;
    }

    PathPermissions setExtendedInfoInAcl(boolean hasExtendedInfoInAcl) {
        this.extendedInfoInAcl = hasExtendedInfoInAcl;
        return this;
    }
}

