/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.util;

import com.azure.storage.file.datalake.implementation.models.BlobHierarchyListSegment;
import com.azure.storage.file.datalake.implementation.models.BlobItemInternal;
import com.azure.storage.file.datalake.implementation.models.BlobPrefix;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;

public final class CustomHierarchicalListingDeserializer
extends JsonDeserializer<BlobHierarchyListSegment> {
    @Override
    public BlobHierarchyListSegment deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<BlobItemInternal> blobItems = new ArrayList<BlobItemInternal>();
        ArrayList<BlobPrefix> blobPrefixes = new ArrayList<BlobPrefix>();
        JsonDeserializer<Object> blobItemDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(BlobItemInternal.class));
        JsonDeserializer<Object> blobPrefixDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(BlobPrefix.class));
        JsonToken currentToken = p.nextToken();
        while (!currentToken.name().equals("END_OBJECT")) {
            p.nextToken();
            if (p.getCurrentName().equals("Blob")) {
                blobItems.add((BlobItemInternal)blobItemDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("BlobPrefix")) {
                blobPrefixes.add((BlobPrefix)blobPrefixDeserializer.deserialize(p, ctxt));
            }
            currentToken = p.nextToken();
        }
        return new BlobHierarchyListSegment().setBlobItems(blobItems).setBlobPrefixes(blobPrefixes);
    }
}

