/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.util;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.util.BlobUserAgentModificationPolicy;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.BuilderUtils;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.MetadataValidationPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import com.azure.storage.file.datalake.implementation.util.DataLakeHeadersAndQueryParameters;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BuilderHelper {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties("azure-storage-file-datalake.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");

    public static HttpPipeline buildPipeline(StorageSharedKeyCredential storageSharedKeyCredential, TokenCredential tokenCredential, AzureSasCredential azureSasCredential, String sasToken, String endpoint, RequestRetryOptions retryOptions, RetryOptions coreRetryOptions, HttpLogOptions logOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, Configuration configuration, ClientLogger logger) {
        CredentialValidator.validateSingleCredentialIsPresent(storageSharedKeyCredential, tokenCredential, azureSasCredential, sasToken, logger);
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(BuilderHelper.getUserAgentPolicy(configuration, logOptions, clientOptions));
        policies.add(new RequestIdPolicy());
        policies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(BuilderUtils.createRetryPolicy(retryOptions, coreRetryOptions, logger));
        policies.add(new AddDatePolicy());
        HttpHeaders headers = new HttpHeaders();
        clientOptions.getHeaders().forEach(header -> headers.put(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.add(new MetadataValidationPolicy());
        HttpPipelinePolicy credentialPolicy = storageSharedKeyCredential != null ? new StorageSharedKeyCredentialPolicy(storageSharedKeyCredential) : (tokenCredential != null ? new BearerTokenAuthenticationPolicy(tokenCredential, "https://storage.azure.com/.default") : (azureSasCredential != null ? new AzureSasCredentialPolicy(azureSasCredential, false) : (sasToken != null ? new AzureSasCredentialPolicy(new AzureSasCredential(sasToken), false) : null)));
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        HttpLogOptions defaultOptions = new HttpLogOptions();
        DataLakeHeadersAndQueryParameters.getDataLakeHeaders().forEach(defaultOptions::addAllowedHeaderName);
        DataLakeHeadersAndQueryParameters.getDataLakeQueryParameters().forEach(defaultOptions::addAllowedQueryParamName);
        return defaultOptions;
    }

    public static String getEndpoint(BlobUrlParts parts) throws MalformedURLException {
        if (ModelHelper.determineAuthorityIsIpStyle(parts.getHost())) {
            return String.format("%s://%s/%s", parts.getScheme(), parts.getHost(), parts.getAccountName());
        }
        return String.format("%s://%s", parts.getScheme(), parts.getHost());
    }

    private static UserAgentPolicy getUserAgentPolicy(Configuration configuration, HttpLogOptions logOptions, ClientOptions clientOptions) {
        configuration = configuration == null ? Configuration.NONE : configuration;
        String applicationId = clientOptions.getApplicationId() != null ? clientOptions.getApplicationId() : logOptions.getApplicationId();
        return new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, configuration);
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").addOptionalEcho("x-ms-encryption-key-sha256").build();
    }

    public static BlobUserAgentModificationPolicy getBlobUserAgentModificationPolicy() {
        return new BlobUserAgentModificationPolicy(CLIENT_NAME, CLIENT_VERSION);
    }
}

