/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="Properties")
public final class BlobPropertiesInternal {
    @JsonProperty(value="Creation-Time")
    private DateTimeRfc1123 creationTime;
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String etag;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="CopyId")
    private String copyId;
    @JsonProperty(value="CopySource")
    private String copySource;
    @JsonProperty(value="CopyProgress")
    private String copyProgress;
    @JsonProperty(value="CopyCompletionTime")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="CopyStatusDescription")
    private String copyStatusDescription;
    @JsonProperty(value="ServerEncrypted")
    private Boolean serverEncrypted;
    @JsonProperty(value="IncrementalCopy")
    private Boolean incrementalCopy;
    @JsonProperty(value="DestinationSnapshot")
    private String destinationSnapshot;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;
    @JsonProperty(value="AccessTierInferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="CustomerProvidedKeySha256")
    private String customerProvidedKeySha256;
    @JsonProperty(value="EncryptionScope")
    private String encryptionScope;
    @JsonProperty(value="AccessTierChangeTime")
    private DateTimeRfc1123 accessTierChangeTime;
    @JsonProperty(value="TagCount")
    private Integer tagCount;
    @JsonProperty(value="Expiry-Time")
    private DateTimeRfc1123 expiresOn;
    @JsonProperty(value="Sealed")
    private Boolean isSealed;
    @JsonProperty(value="LastAccessTime")
    private DateTimeRfc1123 lastAccessedOn;
    @JsonProperty(value="DeleteTime")
    private DateTimeRfc1123 deleteTime;

    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    public BlobPropertiesInternal setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobPropertiesInternal setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public BlobPropertiesInternal setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobPropertiesInternal setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobPropertiesInternal setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobPropertiesInternal setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobPropertiesInternal setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    public BlobPropertiesInternal setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobPropertiesInternal setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobPropertiesInternal setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobPropertiesInternal setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobPropertiesInternal setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobPropertiesInternal setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobPropertiesInternal setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobPropertiesInternal setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobPropertiesInternal setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public BlobPropertiesInternal setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.incrementalCopy;
    }

    public BlobPropertiesInternal setIncrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobPropertiesInternal setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobPropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobPropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobPropertiesInternal setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public String getCustomerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    public BlobPropertiesInternal setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobPropertiesInternal setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public BlobPropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public Integer getTagCount() {
        return this.tagCount;
    }

    public BlobPropertiesInternal setTagCount(Integer tagCount) {
        this.tagCount = tagCount;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.getDateTime();
    }

    public BlobPropertiesInternal setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn == null ? null : new DateTimeRfc1123(expiresOn);
        return this;
    }

    public Boolean isSealed() {
        return this.isSealed;
    }

    public BlobPropertiesInternal setIsSealed(Boolean isSealed) {
        this.isSealed = isSealed;
        return this;
    }

    public OffsetDateTime getLastAccessedOn() {
        if (this.lastAccessedOn == null) {
            return null;
        }
        return this.lastAccessedOn.getDateTime();
    }

    public BlobPropertiesInternal setLastAccessedOn(OffsetDateTime lastAccessedOn) {
        this.lastAccessedOn = lastAccessedOn == null ? null : new DateTimeRfc1123(lastAccessedOn);
        return this;
    }

    public OffsetDateTime getDeleteTime() {
        if (this.deleteTime == null) {
            return null;
        }
        return this.deleteTime.getDateTime();
    }

    public BlobPropertiesInternal setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime == null ? null : new DateTimeRfc1123(deleteTime);
        return this;
    }
}

