/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.azure.storage.file.datalake.models.FileSystemProperties;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathDeletedItem;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakeFileSystemClientBuilder.class)
public class DataLakeFileSystemClient {
    private final ClientLogger logger = new ClientLogger(DataLakeFileSystemClient.class);
    private final DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient;
    private final BlobContainerClient blobContainerClient;
    public static final String ROOT_FILESYSTEM_NAME = "$root";
    private static final String ROOT_DIRECTORY_NAME = "";

    DataLakeFileSystemClient(DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient, BlobContainerClient blobContainerClient) {
        this.dataLakeFileSystemAsyncClient = dataLakeFileSystemAsyncClient;
        this.blobContainerClient = blobContainerClient;
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        return new DataLakeFileClient(this.dataLakeFileSystemAsyncClient.getFileAsyncClient(fileName), this.blobContainerClient.getBlobClient(fileName).getBlockBlobClient());
    }

    public DataLakeDirectoryClient getDirectoryClient(String directoryName) {
        Objects.requireNonNull(directoryName, "'directoryName' can not be set to null");
        return new DataLakeDirectoryClient(this.dataLakeFileSystemAsyncClient.getDirectoryAsyncClient(directoryName), this.blobContainerClient.getBlobClient(directoryName).getBlockBlobClient());
    }

    DataLakeDirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient(ROOT_DIRECTORY_NAME);
    }

    public String getFileSystemName() {
        return this.dataLakeFileSystemAsyncClient.getFileSystemName();
    }

    public String getAccountUrl() {
        return this.dataLakeFileSystemAsyncClient.getAccountUrl();
    }

    public String getFileSystemUrl() {
        return this.dataLakeFileSystemAsyncClient.getFileSystemUrl();
    }

    public String getAccountName() {
        return this.dataLakeFileSystemAsyncClient.getAccountName();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.dataLakeFileSystemAsyncClient.getServiceVersion();
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeFileSystemAsyncClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.createWithResponse(metadata, Transforms.toBlobPublicAccessType(accessType), timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.deleteWithResponse(Transforms.toBlobRequestConditions(requestConditions), timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileSystemProperties getProperties() {
        return this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileSystemProperties> getPropertiesWithResponse(String leaseId, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobContainerProperties> response = this.blobContainerClient.getPropertiesWithResponse(leaseId, timeout, context);
            return new SimpleResponse<FileSystemProperties>(response, Transforms.toFileSystemProperties(response.getValue()));
        }, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions), timeout, context), this.logger);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths() {
        return this.listPaths(new ListPathsOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths(ListPathsOptions options, Duration timeout) {
        return new PagedIterable<PathItem>(this.dataLakeFileSystemAsyncClient.listPathsWithOptionalTimeout(options, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathDeletedItem> listDeletedPaths() {
        return this.listDeletedPaths(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathDeletedItem> listDeletedPaths(String prefix, Duration timeout, Context context) {
        return new PagedIterable<PathDeletedItem>(this.dataLakeFileSystemAsyncClient.listDeletedPathsWithOptionalTimeout(prefix, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, null, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        return new SimpleResponse<DataLakeFileClient>(dataLakeFileClient.createWithResponse(permissions, umask, headers, metadata, requestConditions, timeout, context), dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createDirectory(String directoryName) {
        return this.createDirectory(directoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createDirectory(String directoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createDirectoryWithResponse(directoryName, null, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createDirectoryWithResponse(String directoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse<DataLakeDirectoryClient>(dataLakeDirectoryClient.createWithResponse(permissions, umask, headers, metadata, requestConditions, timeout, context), dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDirectory(String directoryName) {
        this.deleteDirectoryWithResponse(directoryName, false, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakePathClient undeletePath(String deletedPath, String deletionId) {
        return this.undeletePathWithResponse(deletedPath, deletionId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakePathClient> undeletePathWithResponse(String deletedPath, String deletionId, Duration timeout, Context context) {
        Mono<Response<DataLakePathAsyncClient>> response = this.dataLakeFileSystemAsyncClient.undeletePathWithResponse(deletedPath, deletionId, context);
        Response<DataLakePathAsyncClient> asyncClientResponse = StorageImplUtils.blockWithOptionalTimeout(response, timeout);
        DataLakePathAsyncClient pathAsyncClient = asyncClientResponse.getValue();
        BlockBlobClient blockBlobClient = this.blobContainerClient.getBlobClient(deletedPath).getBlockBlobClient();
        if (pathAsyncClient instanceof DataLakeDirectoryAsyncClient) {
            return new SimpleResponse<DataLakePathClient>(asyncClientResponse.getRequest(), asyncClientResponse.getStatusCode(), asyncClientResponse.getHeaders(), new DataLakeDirectoryClient((DataLakeDirectoryAsyncClient)pathAsyncClient, blockBlobClient));
        }
        if (pathAsyncClient instanceof DataLakeFileAsyncClient) {
            return new SimpleResponse<DataLakePathClient>(asyncClientResponse.getRequest(), asyncClientResponse.getStatusCode(), asyncClientResponse.getHeaders(), new DataLakeFileClient((DataLakeFileAsyncClient)pathAsyncClient, blockBlobClient));
        }
        throw this.logger.logExceptionAsError(new IllegalStateException("'pathClient' expected to be either a file or directory client."));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileSystemAccessPolicies getAccessPolicy() {
        return this.getAccessPolicyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileSystemAccessPolicies> getAccessPolicyWithResponse(String leaseId, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobContainerAccessPolicies> response = this.blobContainerClient.getAccessPolicyWithResponse(leaseId, timeout, context);
            return new SimpleResponse<FileSystemAccessPolicies>(response, Transforms.toFileSystemAccessPolicies(response.getValue()));
        }, this.logger);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers) {
        this.setAccessPolicyWithResponse(accessType, identifiers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.setAccessPolicyWithResponse(Transforms.toBlobPublicAccessType(accessType), Transforms.toBlobIdentifierList(identifiers), Transforms.toBlobRequestConditions(requestConditions), timeout, context), this.logger);
    }

    BlobContainerClient getBlobContainerClient() {
        return this.blobContainerClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.dataLakeFileSystemAsyncClient.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.dataLakeFileSystemAsyncClient.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.dataLakeFileSystemAsyncClient.generateSas(dataLakeServiceSasSignatureValues);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return this.dataLakeFileSystemAsyncClient.generateSas(dataLakeServiceSasSignatureValues, context);
    }
}

