/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsResponse;
import com.azure.storage.file.datalake.implementation.models.ListBlobsShowOnly;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathsUndeleteHeaders;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.azure.storage.file.datalake.models.FileSystemProperties;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathDeletedItem;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakeFileSystemClientBuilder.class, isAsync=true)
public class DataLakeFileSystemAsyncClient {
    public static final String ROOT_FILESYSTEM_NAME = "$root";
    private static final String ROOT_DIRECTORY_NAME = "";
    private final ClientLogger logger = new ClientLogger(DataLakeFileSystemAsyncClient.class);
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final AzureDataLakeStorageRestAPIImpl blobDataLakeStorageFs;
    private final BlobContainerAsyncClient blobContainerAsyncClient;
    private final String accountName;
    private final String fileSystemName;
    private final DataLakeServiceVersion serviceVersion;

    DataLakeFileSystemAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, BlobContainerAsyncClient blobContainerAsyncClient) {
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorageFs = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.blobContainerAsyncClient = blobContainerAsyncClient;
    }

    public DataLakeFileAsyncClient getFileAsyncClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(fileName, null).getBlockBlobAsyncClient();
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), fileName, blockBlobAsyncClient);
    }

    public DataLakeDirectoryAsyncClient getDirectoryAsyncClient(String directoryName) {
        Objects.requireNonNull(directoryName, "'directoryName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(directoryName, null).getBlockBlobAsyncClient();
        return new DataLakeDirectoryAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), directoryName, blockBlobAsyncClient);
    }

    DataLakeDirectoryAsyncClient getRootDirectoryAsyncClient() {
        return this.getDirectoryAsyncClient(ROOT_DIRECTORY_NAME);
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    public String getFileSystemUrl() {
        return this.azureDataLakeStorage.getUrl() + "/" + this.fileSystemName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> create() {
        try {
            return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return this.blobContainerAsyncClient.createWithResponse(metadata, Transforms.toBlobPublicAccessType(accessType)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.deleteWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileSystemProperties>> getPropertiesWithResponse(String leaseId) {
        try {
            return this.blobContainerAsyncClient.getPropertiesWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<FileSystemProperties>((Response<?>)response, Transforms.toFileSystemProperties((BlobContainerProperties)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths() {
        try {
            return this.listPaths(new ListPathsOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths(ListPathsOptions options) {
        return this.listPathsWithOptionalTimeout(options, null);
    }

    PagedFlux<PathItem> listPathsWithOptionalTimeout(ListPathsOptions options, Duration timeout) {
        BiFunction func = (marker, pageSize) -> {
            ListPathsOptions finalOptions = pageSize != null ? (options == null ? new ListPathsOptions().setMaxResults((Integer)pageSize) : new ListPathsOptions().setMaxResults((Integer)pageSize).setPath(options.getPath()).setRecursive(options.isRecursive()).setUserPrincipalNameReturned(options.isUserPrincipalNameReturned())) : options;
            return this.listPathsSegment((String)marker, finalOptions, timeout).map(response -> {
                List value = response.getValue() == null ? Collections.emptyList() : response.getValue().getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (FileSystemsListPathsHeaders)response.getDeserializedHeaders());
            });
        };
        return new PagedFlux<PathItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<FileSystemsListPathsResponse> listPathsSegment(String marker, ListPathsOptions options, Duration timeout) {
        options = options == null ? new ListPathsOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureDataLakeStorage.getFileSystems().listPathsWithResponseAsync(options.isRecursive(), null, null, marker, options.getPath(), options.getMaxResults(), options.isUserPrincipalNameReturned(), Context.NONE), timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathDeletedItem> listDeletedPaths() {
        try {
            return this.listDeletedPaths(null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathDeletedItem> listDeletedPaths(String prefix) {
        try {
            return new PagedFlux<PathDeletedItem>(pageSize -> FluxUtil.withContext(context -> this.listDeletedPaths(null, (Integer)pageSize, prefix, null, (Context)context)), (marker, pageSize) -> FluxUtil.withContext(context -> this.listDeletedPaths((String)marker, (Integer)pageSize, prefix, null, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(this.logger, ex);
        }
    }

    PagedFlux<PathDeletedItem> listDeletedPathsWithOptionalTimeout(String prefix, Duration timeout, Context context) {
        return new PagedFlux<PathDeletedItem>(pageSize -> this.listDeletedPaths(null, (Integer)pageSize, prefix, timeout, context), (marker, pageSize) -> this.listDeletedPaths((String)marker, (Integer)pageSize, prefix, timeout, context));
    }

    private Mono<PagedResponse<PathDeletedItem>> listDeletedPaths(String marker, Integer pageSize, String prefix, Duration timeout, Context context) {
        return this.listDeletedPathsSegment(marker, prefix, pageSize, timeout, context).map(response -> {
            List value = response.getValue().getSegment() == null ? Collections.emptyList() : Stream.concat(response.getValue().getSegment().getBlobItems().stream().map(Transforms::toPathDeletedItem), response.getValue().getSegment().getBlobPrefixes().stream().map(Transforms::toPathDeletedItem)).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, response.getValue().getNextMarker(), (FileSystemsListBlobHierarchySegmentHeaders)response.getDeserializedHeaders());
        });
    }

    private Mono<FileSystemsListBlobHierarchySegmentResponse> listDeletedPathsSegment(String marker, String prefix, Integer maxResults, Duration timeout, Context context) {
        context = context == null ? Context.NONE : context;
        return StorageImplUtils.applyOptionalTimeout(this.blobDataLakeStorageFs.getFileSystems().listBlobHierarchySegmentWithResponseAsync(prefix, null, marker, maxResults, null, ListBlobsShowOnly.DELETED, null, null, context.addData("az.namespace", "Microsoft.Storage")), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        try {
            return this.createFileWithResponse(fileName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeFileAsyncClient dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
            return dataLakeFileAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse<DataLakeFileAsyncClient>((Response<?>)response, dataLakeFileAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions) {
        try {
            return this.getFileAsyncClient(fileName).deleteWithResponse(requestConditions);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName) {
        return this.createDirectory(directoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        try {
            return this.createDirectoryWithResponse(directoryName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient = this.getDirectoryAsyncClient(directoryName);
            return dataLakeDirectoryAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse<DataLakeDirectoryAsyncClient>((Response<?>)response, dataLakeDirectoryAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDirectory(String directoryName) {
        return this.deleteDirectoryWithResponse(directoryName, false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions) {
        return this.getDirectoryAsyncClient(directoryName).deleteWithResponse(recursive, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakePathAsyncClient> undeletePath(String deletedPath, String deletionId) {
        return this.undeletePathWithResponse(deletedPath, deletionId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakePathAsyncClient>> undeletePathWithResponse(String deletedPath, String deletionId) {
        try {
            return FluxUtil.withContext(context -> this.undeletePathWithResponse(deletedPath, deletionId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<DataLakePathAsyncClient>> undeletePathWithResponse(String deletedPath, String deletionId, Context context) {
        Objects.requireNonNull(deletedPath);
        Objects.requireNonNull(deletionId);
        context = context == null ? Context.NONE : context;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.blobDataLakeStorageFs.getUrl(), "blob", "dfs");
        AzureDataLakeStorageRestAPIImpl blobDataLakeStoragePath = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(this.blobDataLakeStorageFs.getHttpPipeline()).url(blobUrl).fileSystem(this.blobDataLakeStorageFs.getFileSystem()).path(Utility.urlDecode(deletedPath)).version(this.serviceVersion.getVersion()).buildClient();
        return blobDataLakeStoragePath.getPaths().undeleteWithResponseAsync(null, String.format("?%s=%s", "deletionid", deletionId), null, context.addData("az.namespace", "Microsoft.Storage")).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> {
            DataLakePathAsyncClient client = new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, this.fileSystemName, deletedPath, PathResourceType.fromString(((PathsUndeleteHeaders)response.getDeserializedHeaders()).getXMsResourceType()), this.blobContainerAsyncClient.getBlobAsyncClient(deletedPath, null).getBlockBlobAsyncClient());
            if (PathResourceType.DIRECTORY.equals((Object)client.pathResourceType)) {
                return new SimpleResponse<DataLakeDirectoryAsyncClient>((Response<?>)response, new DataLakeDirectoryAsyncClient(client));
            }
            if (PathResourceType.FILE.equals((Object)client.pathResourceType)) {
                return new SimpleResponse<DataLakeFileAsyncClient>((Response<?>)response, new DataLakeFileAsyncClient(client));
            }
            throw this.logger.logExceptionAsError(new IllegalStateException("'pathClient' expected to be either a file or directory client."));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicy(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers) {
        try {
            return this.setAccessPolicyWithResponse(accessType, identifiers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers, DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.setAccessPolicyWithResponse(Transforms.toBlobPublicAccessType(accessType), Transforms.toBlobIdentifierList(identifiers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemAccessPolicies> getAccessPolicy() {
        try {
            return this.getAccessPolicyWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileSystemAccessPolicies>> getAccessPolicyWithResponse(String leaseId) {
        try {
            return this.blobContainerAsyncClient.getAccessPolicyWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<FileSystemAccessPolicies>((Response<?>)response, Transforms.toFileSystemAccessPolicies((BlobContainerAccessPolicies)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    BlobContainerAsyncClient getBlobContainerAsyncClient() {
        return this.blobContainerAsyncClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateUserDelegationSas(userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), context);
    }
}

