/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ScrubEtagPolicy
implements HttpPipelinePolicy {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final String ETAG = "eTag";

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> Mono.just(this.scrubETagHeader((HttpResponse)response)));
    }

    private HttpResponse scrubETagHeader(HttpResponse unprocessedResponse) {
        HttpHeader eTagHeader = unprocessedResponse.getHeaders().get(ETAG);
        if (eTagHeader == null) {
            return unprocessedResponse;
        }
        String eTag = eTagHeader.getValue();
        eTag = QUOTE_PATTERN.matcher(eTag).replaceAll("");
        HttpHeaders headers = unprocessedResponse.getHeaders();
        headers.set(eTagHeader.getName(), eTag);
        return new InnerHttpResponse(unprocessedResponse, headers, unprocessedResponse.getRequest());
    }

    private static final class InnerHttpResponse
    extends HttpResponse {
        private final HttpResponse innerHttpResponse;
        private final HttpHeaders headers;

        InnerHttpResponse(HttpResponse innerHttpResponse, HttpHeaders headers, HttpRequest request) {
            super(request);
            this.innerHttpResponse = innerHttpResponse;
            this.headers = headers;
        }

        @Override
        public int getStatusCode() {
            return this.innerHttpResponse.getStatusCode();
        }

        @Override
        public String getHeaderValue(String name) {
            return this.innerHttpResponse.getHeaderValue(name);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return this.innerHttpResponse.getBody();
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return this.innerHttpResponse.getBodyAsByteArray();
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.innerHttpResponse.getBodyAsString();
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.innerHttpResponse.getBodyAsString(charset);
        }
    }
}

