/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.util.CoreUtils;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.TimeAndFormat;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class SasImplUtils {
    public static StorageSharedKeyCredential extractSharedKeyCredential(HttpPipeline pipeline) {
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            if (!(pipeline.getPolicy(i) instanceof StorageSharedKeyCredentialPolicy)) continue;
            StorageSharedKeyCredentialPolicy policy = (StorageSharedKeyCredentialPolicy)pipeline.getPolicy(i);
            return policy.sharedKeyCredential();
        }
        return null;
    }

    public static void tryAppendQueryParameter(StringBuilder sb, String param, Object value) {
        if (value != null) {
            if (sb.length() != 0) {
                sb.append('&');
            }
            sb.append(Utility.urlEncode(param)).append('=').append(Utility.urlEncode(value.toString()));
        }
    }

    public static String formatQueryParameterDate(TimeAndFormat timeAndFormat) {
        if (timeAndFormat == null || timeAndFormat.getDateTime() == null) {
            return null;
        }
        if (timeAndFormat.getFormatter() == null) {
            return Constants.ISO_8601_UTC_DATE_FORMATTER.format(timeAndFormat.getDateTime());
        }
        return timeAndFormat.getFormatter().format(timeAndFormat.getDateTime());
    }

    public static Map<String, String[]> parseQueryString(String queryParams) {
        String[] valuePairs;
        TreeMap<String, String[]> retVals = new TreeMap<String, String[]>(Comparator.naturalOrder());
        if (CoreUtils.isNullOrEmpty(queryParams)) {
            return retVals;
        }
        for (String valuePair : valuePairs = queryParams.split("&")) {
            int equalDex = valuePair.indexOf("=");
            String key = Utility.urlDecode(valuePair.substring(0, equalDex)).toLowerCase(Locale.ROOT);
            String value = Utility.urlDecode(valuePair.substring(equalDex + 1));
            String[] keyValues = retVals.get(key);
            if (keyValues == null) {
                keyValues = new String[]{value};
            } else {
                String[] newValues = new String[keyValues.length + 1];
                System.arraycopy(keyValues, 0, newValues, 0, keyValues.length);
                newValues[newValues.length - 1] = value;
                keyValues = newValues;
            }
            retVals.put(key, keyValues);
        }
        return retVals;
    }
}

