/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;

public final class DownloadRetryOptions {
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private final ClientLogger logger = new ClientLogger(DownloadRetryOptions.class);
    private int maxRetryRequests = 5;

    public int getMaxRetryRequests() {
        return this.maxRetryRequests;
    }

    public DownloadRetryOptions setMaxRetryRequests(int maxRetryRequests) {
        if (maxRetryRequests < 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, "options.maxRetryRequests", 0, Integer.MAX_VALUE)));
        }
        this.maxRetryRequests = maxRetryRequests;
        return this;
    }
}

