/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="Blob-Query-Headers")
public final class BlobQueryHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMd5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean serverEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-encryption-scope")
    private String encryptionScope;
    @JsonProperty(value="x-ms-blob-content-md5")
    private byte[] blobContentMd5;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] contentCrc64;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobQueryHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobQueryHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobQueryHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobQueryHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public BlobQueryHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobQueryHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public BlobQueryHeaders setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone(contentMd5);
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobQueryHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobQueryHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobQueryHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobQueryHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobQueryHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public BlobQueryHeaders setBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobQueryHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobQueryHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobQueryHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobQueryHeaders setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobQueryHeaders setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobQueryHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobQueryHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobQueryHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobQueryHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public BlobQueryHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BlobQueryHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public BlobQueryHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobQueryHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobQueryHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobQueryHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public BlobQueryHeaders setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlobQueryHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobQueryHeaders setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public byte[] getBlobContentMd5() {
        return CoreUtils.clone(this.blobContentMd5);
    }

    public BlobQueryHeaders setBlobContentMd5(byte[] blobContentMd5) {
        this.blobContentMd5 = CoreUtils.clone(blobContentMd5);
        return this;
    }

    public byte[] getContentCrc64() {
        return CoreUtils.clone(this.contentCrc64);
    }

    public BlobQueryHeaders setContentCrc64(byte[] contentCrc64) {
        this.contentCrc64 = CoreUtils.clone(contentCrc64);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobQueryHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

