/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.accesshelpers.BlobDownloadHeadersConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobsDownloadHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.ObjectReplicationRule;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="Blob-Download-Headers")
public final class BlobDownloadHeaders {
    @JsonUnwrapped
    private final BlobsDownloadHeaders internalHeaders;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    private BlobDownloadHeaders(BlobsDownloadHeaders internalHeaders) {
        this.internalHeaders = internalHeaders;
    }

    public BlobDownloadHeaders() {
        this.internalHeaders = new BlobsDownloadHeaders();
    }

    public OffsetDateTime getLastModified() {
        return this.internalHeaders.getLastModified();
    }

    public BlobDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        this.internalHeaders.setLastModified(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.internalHeaders.getXMsMeta();
    }

    public BlobDownloadHeaders setMetadata(Map<String, String> metadata) {
        this.internalHeaders.setXMsMeta(metadata);
        return this;
    }

    public String getObjectReplicationDestinationPolicyId() {
        return this.internalHeaders.getXMsOrPolicyId();
    }

    public BlobDownloadHeaders setObjectReplicationDestinationPolicyId(String objectReplicationDestinationPolicyId) {
        this.internalHeaders.setXMsOrPolicyId(objectReplicationDestinationPolicyId);
        return this;
    }

    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return Collections.unmodifiableList(ModelHelper.getObjectReplicationSourcePolicies(this.internalHeaders.getXMsOr()));
    }

    public BlobDownloadHeaders setObjectReplicationSourcePolicies(List<ObjectReplicationPolicy> objectReplicationSourcePolicies) {
        HashMap<String, String> xMsOr = new HashMap<String, String>();
        if (!CoreUtils.isNullOrEmpty(objectReplicationSourcePolicies)) {
            for (ObjectReplicationPolicy policy : objectReplicationSourcePolicies) {
                String policyId = policy.getPolicyId();
                for (ObjectReplicationRule rule : policy.getRules()) {
                    xMsOr.put(policyId + "_" + rule.getRuleId(), rule.getStatus().toString());
                }
            }
        }
        this.internalHeaders.setXMsOr(xMsOr);
        return this;
    }

    public Long getContentLength() {
        return this.internalHeaders.getContentLength();
    }

    public BlobDownloadHeaders setContentLength(Long contentLength) {
        this.internalHeaders.setContentLength(contentLength);
        return this;
    }

    public String getContentType() {
        return this.internalHeaders.getContentType();
    }

    public BlobDownloadHeaders setContentType(String contentType) {
        this.internalHeaders.setContentType(contentType);
        return this;
    }

    public String getContentRange() {
        return this.internalHeaders.getContentRange();
    }

    public BlobDownloadHeaders setContentRange(String contentRange) {
        this.internalHeaders.setContentRange(contentRange);
        return this;
    }

    public String getETag() {
        return this.internalHeaders.getETag();
    }

    public BlobDownloadHeaders setETag(String eTag) {
        this.internalHeaders.setETag(eTag);
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.internalHeaders.getContentMD5());
    }

    public BlobDownloadHeaders setContentMd5(byte[] contentMd5) {
        this.internalHeaders.setContentMD5(CoreUtils.clone(contentMd5));
        return this;
    }

    public String getContentEncoding() {
        return this.internalHeaders.getContentEncoding();
    }

    public BlobDownloadHeaders setContentEncoding(String contentEncoding) {
        this.internalHeaders.setContentEncoding(contentEncoding);
        return this;
    }

    public String getCacheControl() {
        return this.internalHeaders.getCacheControl();
    }

    public BlobDownloadHeaders setCacheControl(String cacheControl) {
        this.internalHeaders.setCacheControl(cacheControl);
        return this;
    }

    public String getContentDisposition() {
        return this.internalHeaders.getContentDisposition();
    }

    public BlobDownloadHeaders setContentDisposition(String contentDisposition) {
        this.internalHeaders.setContentDisposition(contentDisposition);
        return this;
    }

    public String getContentLanguage() {
        return this.internalHeaders.getContentLanguage();
    }

    public BlobDownloadHeaders setContentLanguage(String contentLanguage) {
        this.internalHeaders.setContentLanguage(contentLanguage);
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.internalHeaders.getXMsBlobSequenceNumber();
    }

    public BlobDownloadHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.internalHeaders.setXMsBlobSequenceNumber(blobSequenceNumber);
        return this;
    }

    public BlobType getBlobType() {
        return this.internalHeaders.getXMsBlobType();
    }

    public BlobDownloadHeaders setBlobType(BlobType blobType) {
        this.internalHeaders.setXMsBlobType(blobType);
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.internalHeaders.getXMsCopyCompletionTime();
    }

    public BlobDownloadHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.internalHeaders.setXMsCopyCompletionTime(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.internalHeaders.getXMsCopyStatusDescription();
    }

    public BlobDownloadHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.internalHeaders.setXMsCopyStatusDescription(copyStatusDescription);
        return this;
    }

    public String getCopyId() {
        return this.internalHeaders.getXMsCopyId();
    }

    public BlobDownloadHeaders setCopyId(String copyId) {
        this.internalHeaders.setXMsCopyId(copyId);
        return this;
    }

    public String getCopyProgress() {
        return this.internalHeaders.getXMsCopyProgress();
    }

    public BlobDownloadHeaders setCopyProgress(String copyProgress) {
        this.internalHeaders.setXMsCopyProgress(copyProgress);
        return this;
    }

    public String getCopySource() {
        return this.internalHeaders.getXMsCopySource();
    }

    public BlobDownloadHeaders setCopySource(String copySource) {
        this.internalHeaders.setXMsCopySource(copySource);
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.internalHeaders.getXMsCopyStatus();
    }

    public BlobDownloadHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.internalHeaders.setXMsCopyStatus(copyStatus);
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.internalHeaders.getXMsLeaseDuration();
    }

    public BlobDownloadHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.internalHeaders.setXMsLeaseDuration(leaseDuration);
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.internalHeaders.getXMsLeaseState();
    }

    public BlobDownloadHeaders setLeaseState(LeaseStateType leaseState) {
        this.internalHeaders.setXMsLeaseState(leaseState);
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.internalHeaders.getXMsLeaseStatus();
    }

    public BlobDownloadHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.internalHeaders.setXMsLeaseStatus(leaseStatus);
        return this;
    }

    public String getClientRequestId() {
        return this.internalHeaders.getXMsClientRequestId();
    }

    public BlobDownloadHeaders setClientRequestId(String clientRequestId) {
        this.internalHeaders.setXMsClientRequestId(clientRequestId);
        return this;
    }

    public String getRequestId() {
        return this.internalHeaders.getXMsRequestId();
    }

    public BlobDownloadHeaders setRequestId(String requestId) {
        this.internalHeaders.setXMsRequestId(requestId);
        return this;
    }

    public String getVersion() {
        return this.internalHeaders.getXMsVersion();
    }

    public BlobDownloadHeaders setVersion(String version) {
        this.internalHeaders.setXMsVersion(version);
        return this;
    }

    public String getVersionId() {
        return this.internalHeaders.getXMsVersionId();
    }

    public BlobDownloadHeaders setVersionId(String versionId) {
        this.internalHeaders.setXMsVersionId(versionId);
        return this;
    }

    public String getAcceptRanges() {
        return this.internalHeaders.getAcceptRanges();
    }

    public BlobDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.internalHeaders.setAcceptRanges(acceptRanges);
        return this;
    }

    public OffsetDateTime getDateProperty() {
        return this.internalHeaders.getDateProperty();
    }

    public BlobDownloadHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.internalHeaders.setDateProperty(dateProperty);
        return this;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.internalHeaders.getXMsBlobCommittedBlockCount();
    }

    public BlobDownloadHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.internalHeaders.setXMsBlobCommittedBlockCount(blobCommittedBlockCount);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.internalHeaders.isXMsServerEncrypted();
    }

    public BlobDownloadHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.internalHeaders.setXMsServerEncrypted(isServerEncrypted);
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.internalHeaders.getXMsEncryptionKeySha256();
    }

    public BlobDownloadHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.internalHeaders.setXMsEncryptionKeySha256(encryptionKeySha256);
        return this;
    }

    public String getEncryptionScope() {
        return this.internalHeaders.getXMsEncryptionScope();
    }

    public BlobDownloadHeaders setEncryptionScope(String encryptionScope) {
        this.internalHeaders.setXMsEncryptionScope(encryptionScope);
        return this;
    }

    public byte[] getBlobContentMD5() {
        return CoreUtils.clone(this.internalHeaders.getXMsBlobContentMd5());
    }

    public BlobDownloadHeaders setBlobContentMD5(byte[] blobContentMD5) {
        this.internalHeaders.setXMsBlobContentMd5(CoreUtils.clone(blobContentMD5));
        return this;
    }

    public Long getTagCount() {
        return this.internalHeaders.getXMsTagCount();
    }

    public BlobDownloadHeaders setTagCount(Long tagCount) {
        this.internalHeaders.setXMsTagCount(tagCount);
        return this;
    }

    public byte[] getContentCrc64() {
        return CoreUtils.clone(this.internalHeaders.getXMsContentCrc64());
    }

    public BlobDownloadHeaders setContentCrc64(byte[] contentCrc64) {
        this.internalHeaders.setXMsContentCrc64(CoreUtils.clone(contentCrc64));
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobDownloadHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Boolean isSealed() {
        return this.internalHeaders.isXMsBlobSealed();
    }

    public BlobDownloadHeaders setSealed(Boolean sealed) {
        this.internalHeaders.setXMsBlobSealed(sealed);
        return this;
    }

    public OffsetDateTime getLastAccessedTime() {
        return this.internalHeaders.getXMsLastAccessTime();
    }

    public BlobDownloadHeaders setLastAccessedTime(OffsetDateTime lastAccessedTime) {
        this.internalHeaders.setXMsLastAccessTime(lastAccessedTime);
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.internalHeaders.isXMsIsCurrentVersion();
    }

    public BlobDownloadHeaders setCurrentVersion(Boolean currentVersion) {
        this.internalHeaders.setXMsIsCurrentVersion(currentVersion);
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return new BlobImmutabilityPolicy().setPolicyMode(BlobImmutabilityPolicyMode.fromString(this.internalHeaders.getXMsImmutabilityPolicyMode())).setExpiryTime(this.internalHeaders.getXMsImmutabilityPolicyUntilDate());
    }

    public BlobDownloadHeaders setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        if (immutabilityPolicy == null) {
            this.internalHeaders.setXMsImmutabilityPolicyMode(null);
            this.internalHeaders.setXMsImmutabilityPolicyUntilDate(null);
        } else {
            this.internalHeaders.setXMsImmutabilityPolicyMode(immutabilityPolicy.getPolicyMode().toString());
            this.internalHeaders.setXMsImmutabilityPolicyUntilDate(immutabilityPolicy.getExpiryTime());
        }
        return this;
    }

    public Boolean hasLegalHold() {
        return this.internalHeaders.isXMsLegalHold();
    }

    public BlobDownloadHeaders setHasLegalHold(Boolean hasLegalHold) {
        this.internalHeaders.setXMsLegalHold(hasLegalHold);
        return this;
    }

    static {
        BlobDownloadHeadersConstructorProxy.setAccessor(new BlobDownloadHeadersConstructorProxy.BlobDownloadHeadersConstructorAccessor(){

            @Override
            public BlobDownloadHeaders create(BlobsDownloadHeaders internalHeaders) {
                return new BlobDownloadHeaders(internalHeaders);
            }
        });
    }
}

