/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.FindBlobsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BlobContainerClientBuilder.class)
public final class BlobContainerClient {
    private final BlobContainerAsyncClient client;
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    BlobContainerClient(BlobContainerAsyncClient client) {
        this.client = client;
    }

    public BlobClient getBlobClient(String blobName) {
        return new BlobClient(this.client.getBlobAsyncClient(blobName));
    }

    public BlobClient getBlobClient(String blobName, String snapshot) {
        return new BlobClient(this.client.getBlobAsyncClient(blobName, snapshot));
    }

    public BlobClient getBlobVersionClient(String blobName, String versionId) {
        return new BlobClient(this.client.getBlobVersionAsyncClient(blobName, versionId));
    }

    public String getBlobContainerName() {
        return this.client.getBlobContainerName();
    }

    public String getAccountUrl() {
        return this.client.getAccountUrl();
    }

    public String getBlobContainerUrl() {
        return this.client.getBlobContainerUrl();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public BlobServiceClient getServiceClient() {
        return this.client.getServiceClientBuilder().buildClient();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.client.getCustomerProvidedKey();
    }

    public String getEncryptionScope() {
        return this.client.getEncryptionScope();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.existsWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.createWithResponse(metadata, accessType, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerProperties getProperties() {
        return this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerProperties> getPropertiesWithResponse(String leaseId, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.getPropertiesWithResponse(leaseId, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerAccessPolicies getAccessPolicy() {
        return this.getAccessPolicyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerAccessPolicies> getAccessPolicyWithResponse(String leaseId, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.getAccessPolicyWithResponse(leaseId, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers) {
        this.setAccessPolicyWithResponse(accessType, identifiers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setAccessPolicyWithResponse(accessType, identifiers, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs() {
        return this.listBlobs(new ListBlobsOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, Duration timeout) {
        return this.listBlobs(options, null, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, String continuationToken, Duration timeout) {
        return new PagedIterable<BlobItem>(this.client.listBlobsFlatWithOptionalTimeout(options, continuationToken, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobsByHierarchy(String directory) {
        return this.listBlobsByHierarchy("/", new ListBlobsOptions().setPrefix(directory), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobsByHierarchy(String delimiter, ListBlobsOptions options, Duration timeout) {
        return new PagedIterable<BlobItem>(this.client.listBlobsHierarchyWithOptionalTimeout(delimiter, options, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout, Context context) {
        return new PagedIterable<TaggedBlobItem>(this.client.findBlobsByTags(options, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo(Duration timeout) {
        return this.getAccountInfoWithResponse(timeout, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Mono<Response<StorageAccountInfo>> response = this.client.getAccountInfoWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.client.generateSas(blobServiceSasSignatureValues);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.client.generateSas(blobServiceSasSignatureValues, context);
    }
}

