/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class PortPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(PortPolicy.class);
    private final int port;
    private final boolean overwrite;

    public PortPolicy(int port, boolean overwrite) {
        this.port = port;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
        if (this.overwrite || urlBuilder.getPort() == null) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Changing port to " + this.port);
            try {
                context.getHttpRequest().setUrl(urlBuilder.setPort(this.port).toUrl());
            }
            catch (MalformedURLException e) {
                return Mono.error(new RuntimeException(String.format("Failed to set the HTTP request port to %d.", this.port), e));
            }
        }
        return next.process();
    }
}

