/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;

public class HttpRequest {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRequest.class);
    private HttpMethod httpMethod;
    private URL url;
    private HttpHeaders headers;
    private Flux<ByteBuffer> body;

    public HttpRequest(HttpMethod httpMethod, URL url) {
        this(httpMethod, url, new HttpHeaders(), null);
    }

    public HttpRequest(HttpMethod httpMethod, String url) {
        this.httpMethod = httpMethod;
        this.setUrl(url);
        this.headers = new HttpHeaders();
    }

    public HttpRequest(HttpMethod httpMethod, URL url, HttpHeaders headers, Flux<ByteBuffer> body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.body = body;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public HttpRequest setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(URL url) {
        this.url = url;
        return this;
    }

    public HttpRequest setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("'url' must be a valid URL.", ex));
        }
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest setHeader(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public Flux<ByteBuffer> getBody() {
        return this.body;
    }

    public HttpRequest setBody(String content) {
        byte[] bodyBytes = content.getBytes(StandardCharsets.UTF_8);
        return this.setBody(bodyBytes);
    }

    public HttpRequest setBody(byte[] content) {
        this.setContentLength(content.length);
        return this.setBody(Flux.defer(() -> Flux.just(ByteBuffer.wrap(content))));
    }

    public HttpRequest setBody(Flux<ByteBuffer> content) {
        this.body = content;
        return this;
    }

    private void setContentLength(long contentLength) {
        this.headers.set("Content-Length", String.valueOf(contentLength));
    }

    public HttpRequest copy() {
        HttpHeaders bufferedHeaders = new HttpHeaders(this.headers);
        return new HttpRequest(this.httpMethod, this.url, bufferedHeaders, this.body);
    }
}

