/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.replica;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.pinot.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;

public interface ClientMetadata {
    public String rackId();

    public String clientId();

    public InetAddress clientAddress();

    public KafkaPrincipal principal();

    public String listenerName();

    public static class DefaultClientMetadata
    implements ClientMetadata {
        private final String rackId;
        private final String clientId;
        private final InetAddress clientAddress;
        private final KafkaPrincipal principal;
        private final String listenerName;

        public DefaultClientMetadata(String rackId, String clientId, InetAddress clientAddress, KafkaPrincipal principal, String listenerName) {
            this.rackId = rackId;
            this.clientId = clientId;
            this.clientAddress = clientAddress;
            this.principal = principal;
            this.listenerName = listenerName;
        }

        @Override
        public String rackId() {
            return this.rackId;
        }

        @Override
        public String clientId() {
            return this.clientId;
        }

        @Override
        public InetAddress clientAddress() {
            return this.clientAddress;
        }

        @Override
        public KafkaPrincipal principal() {
            return this.principal;
        }

        @Override
        public String listenerName() {
            return this.listenerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultClientMetadata that = (DefaultClientMetadata)o;
            return Objects.equals(this.rackId, that.rackId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientAddress, that.clientAddress) && Objects.equals(this.principal, that.principal) && Objects.equals(this.listenerName, that.listenerName);
        }

        public int hashCode() {
            return Objects.hash(this.rackId, this.clientId, this.clientAddress, this.principal, this.listenerName);
        }

        public String toString() {
            return "DefaultClientMetadata{rackId='" + this.rackId + '\'' + ", clientId='" + this.clientId + '\'' + ", clientAddress=" + this.clientAddress + ", principal=" + this.principal + ", listenerName='" + this.listenerName + '\'' + '}';
        }
    }
}

