/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.shaded.org.apache.kafka.common.network.Send;
import org.apache.pinot.shaded.org.apache.kafka.common.network.TransferableChannel;

public class ByteBufferSend
implements Send {
    private final long size;
    protected final ByteBuffer[] buffers;
    private long remaining;
    private boolean pending = false;

    public ByteBufferSend(ByteBuffer ... buffers) {
        this.buffers = buffers;
        for (ByteBuffer buffer : buffers) {
            this.remaining += (long)buffer.remaining();
        }
        this.size = this.remaining;
    }

    public ByteBufferSend(ByteBuffer[] buffers, long size) {
        this.buffers = buffers;
        this.size = size;
        this.remaining = size;
    }

    @Override
    public boolean completed() {
        return this.remaining <= 0L && !this.pending;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long writeTo(TransferableChannel channel) throws IOException {
        long written = channel.write(this.buffers);
        if (written < 0L) {
            throw new EOFException("Wrote negative bytes to channel. This shouldn't happen.");
        }
        this.remaining -= written;
        this.pending = channel.hasPendingWrites();
        return written;
    }

    public long remaining() {
        return this.remaining;
    }

    public String toString() {
        return "ByteBufferSend(, size=" + this.size + ", remaining=" + this.remaining + ", pending=" + this.pending + ')';
    }

    public static ByteBufferSend sizePrefixed(ByteBuffer buffer) {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
        sizeBuffer.putInt(0, buffer.remaining());
        return new ByteBufferSend(sizeBuffer, buffer);
    }
}

