/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.Serializer;

public class AvroMessageReader
extends SchemaMessageReader<Object> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();

    public AvroMessageReader() {
    }

    AvroMessageReader(SchemaRegistryClient schemaRegistryClient, Schema keySchema, Schema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean autoRegister, boolean useLatest) {
        super(schemaRegistryClient, new AvroSchema(keySchema), new AvroSchema(valueSchema), topic, parseKey, reader, autoRegister, useLatest);
    }

    @Override
    protected SchemaMessageSerializer<Object> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
        return new AvroMessageSerializer(schemaRegistryClient, autoRegister, useLatest, keySerializer);
    }

    @Override
    protected SchemaProvider getProvider() {
        return new AvroSchemaProvider();
    }

    @Override
    protected Object readFrom(String jsonString, ParsedSchema parsedSchema) {
        Schema schema = ((AvroSchema)parsedSchema).rawSchema();
        try {
            Object object = AvroSchemaUtils.toObject(jsonString, (AvroSchema)parsedSchema);
            if (schema.getType().equals((Object)Schema.Type.STRING)) {
                object = ((Utf8)object).toString();
            }
            return object;
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), e);
        }
        catch (AvroRuntimeException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), e);
        }
    }

    static class AvroMessageSerializer
    extends AbstractKafkaAvroSerializer
    implements SchemaMessageSerializer<Object> {
        protected final Serializer keySerializer;

        AvroMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.autoRegisterSchema = autoRegister;
            this.useLatestVersion = useLatest;
            this.keySerializer = keySerializer;
        }

        @Override
        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        @Override
        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        @Override
        public byte[] serialize(String subject, String topic, boolean isKey, Object object, ParsedSchema schema) {
            return super.serializeImpl(subject, object, (AvroSchema)schema);
        }
    }
}

