/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.segmentgenerationandpush;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.MinionContext;
import org.apache.pinot.minion.event.MinionEventObserver;
import org.apache.pinot.minion.event.MinionEventObservers;
import org.apache.pinot.plugin.ingestion.batch.common.SegmentGenerationTaskRunner;
import org.apache.pinot.plugin.minion.tasks.BaseTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.segmentgenerationandpush.SegmentGenerationAndPushResult;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.RecordReaderSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationTaskSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentNameGeneratorSpec;
import org.apache.pinot.spi.ingestion.batch.spec.TableSpec;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentGenerationAndPushTaskExecutor
extends BaseTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGenerationAndPushTaskExecutor.class);
    private static final int DEFUALT_PUSH_ATTEMPTS = 5;
    private static final int DEFAULT_PUSH_PARALLELISM = 1;
    private static final long DEFAULT_PUSH_RETRY_INTERVAL_MILLIS = 1000L;
    private PinotTaskConfig _pinotTaskConfig;
    private MinionEventObserver _eventObserver;

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        throw new UnsupportedOperationException();
    }

    public Object executeTask(PinotTaskConfig pinotTaskConfig) throws Exception {
        LOGGER.info("Executing SegmentGenerationAndPushTask with task config: {}", (Object)pinotTaskConfig);
        Map taskConfigs = pinotTaskConfig.getConfigs();
        SegmentGenerationAndPushResult.Builder resultBuilder = new SegmentGenerationAndPushResult.Builder();
        File localTempDir = new File(new File(MinionContext.getInstance().getDataDir(), "SegmentGenerationAndPushResult"), "tmp-" + UUID.randomUUID());
        this._pinotTaskConfig = pinotTaskConfig;
        this._eventObserver = MinionEventObservers.getInstance().getMinionEventObserver(pinotTaskConfig.getTaskId());
        try {
            SegmentGenerationTaskSpec taskSpec = this.generateTaskSpec(taskConfigs, localTempDir);
            SegmentGenerationAndPushResult segmentGenerationAndPushResult = this.generateAndPushSegment(taskSpec, resultBuilder, taskConfigs);
            return segmentGenerationAndPushResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute SegmentGenerationAndPushTask", e);
        }
        finally {
            FileUtils.deleteQuietly((File)localTempDir);
        }
    }

    private SegmentGenerationAndPushResult generateAndPushSegment(SegmentGenerationTaskSpec taskSpec, SegmentGenerationAndPushResult.Builder resultBuilder, Map<String, String> taskConfigs) throws Exception {
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)"Generating segment");
        SegmentGenerationTaskRunner taskRunner = new SegmentGenerationTaskRunner(taskSpec);
        String segmentName = taskRunner.run();
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Compressing segment: " + segmentName));
        File localSegmentTarFile = this.tarSegmentDir(taskSpec, segmentName);
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Moving segment: %s to output dir", segmentName));
        URI outputSegmentTarURI = this.moveSegmentToOutputPinotFS(taskConfigs, localSegmentTarFile);
        LOGGER.info("Moved generated segment from [{}] to location: [{}]", (Object)localSegmentTarFile, (Object)outputSegmentTarURI);
        resultBuilder.setSegmentName(segmentName);
        this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Pushing segment: " + segmentName));
        this.pushSegment(taskSpec.getTableConfig().getTableName(), taskConfigs, outputSegmentTarURI);
        resultBuilder.setSucceed(true);
        return resultBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushSegment(String tableName, Map<String, String> taskConfigs, URI outputSegmentTarURI) throws Exception {
        String pushMode = taskConfigs.get("push.mode");
        LOGGER.info("Trying to push Pinot segment with push mode {} from {}", (Object)pushMode, (Object)outputSegmentTarURI);
        PushJobSpec pushJobSpec = new PushJobSpec();
        pushJobSpec.setPushAttempts(5);
        pushJobSpec.setPushParallelism(1);
        pushJobSpec.setPushRetryIntervalMillis(1000L);
        pushJobSpec.setSegmentUriPrefix(taskConfigs.get("push.segmentUriPrefix"));
        pushJobSpec.setSegmentUriSuffix(taskConfigs.get("push.segmentUriSuffix"));
        SegmentGenerationJobSpec spec = this.generatePushJobSpec(tableName, taskConfigs, pushJobSpec);
        URI outputSegmentDirURI = null;
        if (taskConfigs.containsKey("output.segment.dir.uri")) {
            outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        }
        try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
            switch (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase())) {
                case TAR: {
                    try (PinotFS pinotFS = MinionTaskUtils.getLocalPinotFs();){
                        SegmentPushUtils.pushSegments((SegmentGenerationJobSpec)spec, (PinotFS)pinotFS, Arrays.asList(outputSegmentTarURI.toString()));
                        return;
                    }
                    catch (AttemptsExceededException | RetriableOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
                case URI: {
                    try {
                        ArrayList<String> segmentUris = new ArrayList<String>();
                        URI updatedURI = SegmentPushUtils.generateSegmentTarURI((URI)outputSegmentDirURI, (URI)outputSegmentTarURI, (String)pushJobSpec.getSegmentUriPrefix(), (String)pushJobSpec.getSegmentUriSuffix());
                        segmentUris.add(updatedURI.toString());
                        SegmentPushUtils.sendSegmentUris((SegmentGenerationJobSpec)spec, segmentUris);
                        return;
                    }
                    catch (AttemptsExceededException | RetriableOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
                case METADATA: {
                    try {
                        Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputSegmentDirURI, (PushJobSpec)pushJobSpec, (String[])new String[]{outputSegmentTarURI.toString()});
                        SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)spec, (PinotFS)outputFileFS, (Map)segmentUriToTarPathMap);
                        return;
                    }
                    catch (AttemptsExceededException | RetriableOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized push mode - " + pushMode);
                }
            }
        }
    }

    private SegmentGenerationJobSpec generatePushJobSpec(String tableName, Map<String, String> taskConfigs, PushJobSpec pushJobSpec) {
        TableSpec tableSpec = new TableSpec();
        tableSpec.setTableName(tableName);
        PinotClusterSpec pinotClusterSpec = new PinotClusterSpec();
        pinotClusterSpec.setControllerURI(taskConfigs.get("push.controllerUri"));
        PinotClusterSpec[] pinotClusterSpecs = new PinotClusterSpec[]{pinotClusterSpec};
        SegmentGenerationJobSpec spec = new SegmentGenerationJobSpec();
        spec.setPushJobSpec(pushJobSpec);
        spec.setTableSpec(tableSpec);
        spec.setPinotClusterSpecs(pinotClusterSpecs);
        spec.setAuthToken(taskConfigs.get("authToken"));
        return spec;
    }

    private URI moveSegmentToOutputPinotFS(Map<String, String> taskConfigs, File localSegmentTarFile) throws Exception {
        if (!taskConfigs.containsKey("output.segment.dir.uri")) {
            return localSegmentTarFile.toURI();
        }
        URI outputSegmentDirURI = URI.create(taskConfigs.get("output.segment.dir.uri"));
        try (PinotFS outputFileFS = MinionTaskUtils.getOutputPinotFS(taskConfigs, outputSegmentDirURI);){
            URI outputSegmentTarURI = URI.create(outputSegmentDirURI + localSegmentTarFile.getName());
            if (!Boolean.parseBoolean(taskConfigs.get("overwriteOutput")) && outputFileFS.exists(outputSegmentDirURI)) {
                LOGGER.warn("Not overwrite existing output segment tar file: {}", (Object)outputFileFS.exists(outputSegmentDirURI));
            } else {
                outputFileFS.copyFromLocalFile(localSegmentTarFile, outputSegmentTarURI);
            }
            URI uRI = outputSegmentTarURI;
            return uRI;
        }
    }

    private File tarSegmentDir(SegmentGenerationTaskSpec taskSpec, String segmentName) throws IOException {
        File localOutputTempDir = new File(taskSpec.getOutputDirectoryPath());
        File localSegmentDir = new File(localOutputTempDir, segmentName);
        String segmentTarFileName = segmentName + ".tar.gz";
        File localSegmentTarFile = new File(localOutputTempDir, segmentTarFileName);
        LOGGER.info("Tarring segment from: {} to: {}", (Object)localSegmentDir, (Object)localSegmentTarFile);
        TarGzCompressionUtils.createTarGzFile((File)localSegmentDir, (File)localSegmentTarFile);
        long uncompressedSegmentSize = FileUtils.sizeOf((File)localSegmentDir);
        long compressedSegmentSize = FileUtils.sizeOf((File)localSegmentTarFile);
        LOGGER.info("Size for segment: {}, uncompressed: {}, compressed: {}", new Object[]{segmentName, DataSizeUtils.fromBytes((long)uncompressedSegmentSize), DataSizeUtils.fromBytes((long)compressedSegmentSize)});
        return localSegmentTarFile;
    }

    protected SegmentGenerationTaskSpec generateTaskSpec(Map<String, String> taskConfigs, File localTempDir) throws Exception {
        SegmentGenerationTaskSpec taskSpec = new SegmentGenerationTaskSpec();
        URI inputFileURI = URI.create(taskConfigs.get("input.data.file.uri"));
        try (PinotFS inputFileFS = MinionTaskUtils.getInputPinotFS(taskConfigs, inputFileURI);){
            File localInputTempDir = new File(localTempDir, "input");
            FileUtils.forceMkdir((File)localInputTempDir);
            File localOutputTempDir = new File(localTempDir, "output");
            FileUtils.forceMkdir((File)localOutputTempDir);
            taskSpec.setOutputDirectoryPath(localOutputTempDir.getAbsolutePath());
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Copying file: %s to local disk", inputFileURI));
            File localInputDataFile = new File(localInputTempDir, new File(inputFileURI.getPath()).getName());
            inputFileFS.copyToLocalFile(inputFileURI, localInputDataFile);
            taskSpec.setInputFilePath(localInputDataFile.getAbsolutePath());
            RecordReaderSpec recordReaderSpec = new RecordReaderSpec();
            recordReaderSpec.setDataFormat(taskConfigs.get("inputFormat"));
            recordReaderSpec.setClassName(taskConfigs.get("recordReader.className"));
            recordReaderSpec.setConfigClassName(taskConfigs.get("recordReader.configClassName"));
            taskSpec.setRecordReaderSpec(recordReaderSpec);
            String authToken = taskConfigs.get("authToken");
            String tableNameWithType = taskConfigs.get("tableName");
            Schema schema = taskConfigs.containsKey("schema") ? (Schema)JsonUtils.stringToObject((String)JsonUtils.objectToString((Object)taskConfigs.get("schema")), Schema.class) : (taskConfigs.containsKey("schemaURI") ? SegmentGenerationUtils.getSchema((String)taskConfigs.get("schemaURI"), (String)authToken) : this.getSchema(tableNameWithType));
            taskSpec.setSchema(schema);
            TableConfig tableConfig = taskConfigs.containsKey("tableConfigs") ? (TableConfig)JsonUtils.stringToObject((String)taskConfigs.get("tableConfigs"), TableConfig.class) : (taskConfigs.containsKey("tableConfigsURI") ? SegmentGenerationUtils.getTableConfig((String)taskConfigs.get("tableConfigsURI"), (String)authToken) : this.getTableConfig(tableNameWithType));
            taskSpec.setTableConfig(tableConfig);
            taskSpec.setSequenceId(Integer.parseInt(taskConfigs.get("sequenceId")));
            if (taskConfigs.containsKey("fail.on.empty.segment")) {
                taskSpec.setFailOnEmptySegment(Boolean.parseBoolean(taskConfigs.get("fail.on.empty.segment")));
            }
            SegmentNameGeneratorSpec segmentNameGeneratorSpec = new SegmentNameGeneratorSpec();
            segmentNameGeneratorSpec.setType(taskConfigs.get("segmentNameGenerator.type"));
            segmentNameGeneratorSpec.setConfigs(IngestionConfigUtils.getConfigMapWithPrefix(taskConfigs, (String)"segmentNameGenerator.configs"));
            taskSpec.setSegmentNameGeneratorSpec(segmentNameGeneratorSpec);
            taskSpec.setCustomProperty("input.data.file.uri", inputFileURI.toString());
            SegmentGenerationTaskSpec segmentGenerationTaskSpec = taskSpec;
            return segmentGenerationTaskSpec;
        }
    }
}

