/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.purge;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.minion.SegmentPurger;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class PurgeTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    public static final String RECORD_PURGER_KEY = "recordPurger";
    public static final String RECORD_MODIFIER_KEY = "recordModifier";
    public static final String NUM_RECORDS_PURGED_KEY = "numRecordsPurged";
    public static final String NUM_RECORDS_MODIFIED_KEY = "numRecordsModified";

    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        SegmentPurger.RecordPurgerFactory recordPurgerFactory = MINION_CONTEXT.getRecordPurgerFactory();
        SegmentPurger.RecordPurger recordPurger = recordPurgerFactory != null ? recordPurgerFactory.getRecordPurger(rawTableName) : null;
        SegmentPurger.RecordModifierFactory recordModifierFactory = MINION_CONTEXT.getRecordModifierFactory();
        SegmentPurger.RecordModifier recordModifier = recordModifierFactory != null ? recordModifierFactory.getRecordModifier(rawTableName) : null;
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Purging segment: " + indexDir));
        SegmentPurger segmentPurger = new SegmentPurger(indexDir, workingDir, tableConfig, recordPurger, recordModifier);
        File purgedSegmentFile = segmentPurger.purgeSegment();
        if (purgedSegmentFile == null) {
            purgedSegmentFile = indexDir;
        }
        return new SegmentConversionResult.Builder().setFile(purgedSegmentFile).setTableNameWithType(tableNameWithType).setSegmentName((String)configs.get("segmentName")).setCustomProperty(RECORD_PURGER_KEY, segmentPurger.getRecordPurger()).setCustomProperty(RECORD_MODIFIER_KEY, segmentPurger.getRecordModifier()).setCustomProperty(NUM_RECORDS_PURGED_KEY, segmentPurger.getNumRecordsPurged()).setCustomProperty(NUM_RECORDS_MODIFIED_KEY, segmentPurger.getNumRecordsModified()).build();
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("PurgeTask.time", String.valueOf(System.currentTimeMillis())));
    }
}

