/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import java.util.Map;
import java.util.TreeMap;

public class MergeRollupTaskUtils {
    private static final String[] VALID_CONFIG_KEYS = new String[]{"bucketTimePeriod", "bufferTimePeriod", "roundBucketTimePeriod", "mergeType", "maxNumRecordsPerSegment", "maxNumRecordsPerTask", "maxNumParallelBuckets"};

    private MergeRollupTaskUtils() {
    }

    public static Map<String, Map<String, String>> getLevelToConfigMap(Map<String, String> taskConfig) {
        TreeMap<String, Map<String, String>> levelToConfigMap = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : taskConfig.entrySet()) {
            String key = entry.getKey();
            for (String configKey : VALID_CONFIG_KEYS) {
                if (!key.endsWith(configKey)) continue;
                String level = key.substring(0, key.length() - configKey.length() - 1);
                levelToConfigMap.computeIfAbsent(level, k -> new TreeMap()).put(configKey, entry.getValue());
            }
        }
        return levelToConfigMap;
    }
}

