/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.lineage.SegmentLineageUtils;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.common.minion.MergeRollupTaskMetadata;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.MergeTaskUtils;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.mergerollup.MergeRollupTaskUtils;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class MergeRollupTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeRollupTaskGenerator.class);
    private static final int DEFAULT_MAX_NUM_RECORDS_PER_TASK = 50000000;
    private static final int DEFAULT_NUM_PARALLEL_BUCKETS = 1;
    private static final String REFRESH = "REFRESH";
    private static final String DELIMITER_IN_SEGMENT_NAME = "_";
    private static final String MERGE_ROLLUP_TASK_DELAY_IN_NUM_BUCKETS = "mergeRollupTaskDelayInNumBuckets";
    private final Map<String, Map<String, Long>> _mergeRollupWatermarks = new HashMap<String, Map<String, Long>>();
    private final Map<String, Long> _tableLowestLevelMaxValidBucketEndTimeMs = new HashMap<String, Long>();

    public String getTaskType() {
        return "MergeRollupTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "MergeRollupTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            if (!MergeRollupTaskGenerator.validate(tableConfig, taskType)) continue;
            String tableNameWithType = tableConfig.getTableName();
            LOGGER.info("Start generating task configs for table: {} for task: {}", (Object)tableNameWithType, (Object)taskType);
            List allSegments = this._clusterInfoAccessor.getSegmentsZKMetadata(tableNameWithType);
            List<SegmentZKMetadata> preSelectedSegmentsBasedOnStatus = MergeRollupTaskGenerator.filterSegmentsBasedOnStatus(tableConfig.getTableType(), allSegments);
            SegmentLineage segmentLineage = this._clusterInfoAccessor.getSegmentLineage(tableNameWithType);
            HashSet<String> preSelectedSegmentsBasedOnLineage = new HashSet<String>();
            for (SegmentZKMetadata segmentZKMetadata : preSelectedSegmentsBasedOnStatus) {
                preSelectedSegmentsBasedOnLineage.add(segmentZKMetadata.getSegmentName());
            }
            SegmentLineageUtils.filterSegmentsBasedOnLineageInPlace(preSelectedSegmentsBasedOnLineage, (SegmentLineage)segmentLineage);
            ArrayList<SegmentZKMetadata> preSelectedSegments = new ArrayList<SegmentZKMetadata>();
            for (SegmentZKMetadata segment3 : preSelectedSegmentsBasedOnStatus) {
                if (!preSelectedSegmentsBasedOnLineage.contains(segment3.getSegmentName()) || segment3.getTotalDocs() <= 0L || !MergeTaskUtils.allowMerge(segment3)) continue;
                preSelectedSegments.add(segment3);
            }
            if (preSelectedSegments.isEmpty()) {
                this.resetDelayMetrics(tableNameWithType);
                LOGGER.info("Skip generating task: {} for table: {}, no segment is found.", (Object)taskType, (Object)tableNameWithType);
                continue;
            }
            preSelectedSegments.sort((a, b) -> {
                long bEndTime;
                long bStartTime;
                long aStartTime = a.getStartTimeMs();
                if (aStartTime != (bStartTime = b.getStartTimeMs())) {
                    return Long.compare(aStartTime, bStartTime);
                }
                long aEndTime = a.getEndTimeMs();
                return aEndTime != (bEndTime = b.getEndTimeMs()) ? Long.compare(aEndTime, bEndTime) : a.getSegmentName().compareTo(b.getSegmentName());
            });
            Map map = tableConfig.getTaskConfig().getConfigsForTaskType(taskType);
            Map<String, Map<String, String>> mergeLevelToConfigs = MergeRollupTaskUtils.getLevelToConfigMap(map);
            ArrayList<Map.Entry<String, Map<String, String>>> sortedMergeLevelConfigs = new ArrayList<Map.Entry<String, Map<String, String>>>(mergeLevelToConfigs.entrySet());
            sortedMergeLevelConfigs.sort(Comparator.comparingLong(e -> TimeUtils.convertPeriodToMillis((String)((String)((Map)e.getValue()).get("bucketTimePeriod")))));
            HashSet<String> inCompleteMergeLevels = new HashSet<String>();
            for (Map.Entry entry : TaskGeneratorUtils.getIncompleteTasks((String)taskType, (String)tableNameWithType, (ClusterInfoAccessor)this._clusterInfoAccessor).entrySet()) {
                for (PinotTaskConfig taskConfig : this._clusterInfoAccessor.getTaskConfigs((String)entry.getKey())) {
                    inCompleteMergeLevels.add((String)taskConfig.getConfigs().get("mergeLevel"));
                }
            }
            ZNRecord mergeRollupTaskZNRecord = this._clusterInfoAccessor.getMinionTaskMetadataZNRecord("MergeRollupTask", tableNameWithType);
            int expectedVersion = mergeRollupTaskZNRecord != null ? mergeRollupTaskZNRecord.getVersion() : -1;
            MergeRollupTaskMetadata mergeRollupTaskMetadata = mergeRollupTaskZNRecord != null ? MergeRollupTaskMetadata.fromZNRecord((ZNRecord)mergeRollupTaskZNRecord) : new MergeRollupTaskMetadata(tableNameWithType, new TreeMap());
            ArrayList<PinotTaskConfig> pinotTaskConfigsForTable = new ArrayList<PinotTaskConfig>();
            String mergeLevel = null;
            for (Map.Entry entry : sortedMergeLevelConfigs) {
                long watermarkMs;
                int maxNumParallelBuckets;
                String lowerMergeLevel = mergeLevel;
                mergeLevel = (String)entry.getKey();
                Map mergeConfigs = (Map)entry.getValue();
                if (inCompleteMergeLevels.contains(mergeLevel)) {
                    LOGGER.info("Found incomplete task of merge level: {} for the same table: {}, Skipping task generation: {}", new Object[]{mergeLevel, tableNameWithType, taskType});
                    continue;
                }
                String bucketPeriod = (String)mergeConfigs.get("bucketTimePeriod");
                long bucketMs = TimeUtils.convertPeriodToMillis((String)bucketPeriod);
                if (bucketMs <= 0L) {
                    LOGGER.error("Bucket time period: {} (table : {}, mergeLevel : {}) must be larger than 0", new Object[]{bucketPeriod, tableNameWithType, mergeLevel});
                    continue;
                }
                String bufferPeriod = (String)mergeConfigs.get("bufferTimePeriod");
                long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferPeriod);
                if (bufferMs < 0L) {
                    LOGGER.error("Buffer time period: {} (table : {}, mergeLevel : {}) must be larger or equal to 0", new Object[]{bufferPeriod, tableNameWithType, mergeLevel});
                    continue;
                }
                String maxNumParallelBucketsStr = (String)mergeConfigs.get("maxNumParallelBuckets");
                int n = maxNumParallelBuckets = maxNumParallelBucketsStr != null ? Integer.parseInt(maxNumParallelBucketsStr) : 1;
                if (maxNumParallelBuckets <= 0) {
                    LOGGER.error("Maximum number of parallel buckets: {} (table : {}, mergeLevel : {}) must be larger than 0", new Object[]{maxNumParallelBuckets, tableNameWithType, mergeLevel});
                    continue;
                }
                long bucketStartMs = watermarkMs = this.getWatermarkMs(((SegmentZKMetadata)preSelectedSegments.get(0)).getStartTimeMs(), bucketMs, mergeLevel, mergeRollupTaskMetadata);
                long bucketEndMs = bucketStartMs + bucketMs;
                if (lowerMergeLevel == null) {
                    long lowestLevelMaxValidBucketEndTimeMs = Long.MIN_VALUE;
                    for (SegmentZKMetadata preSelectedSegment : preSelectedSegments) {
                        long currentValidBucketEndTimeMs = this.getValidBucketEndTimeMsForSegment(preSelectedSegment, bucketMs, bufferMs);
                        lowestLevelMaxValidBucketEndTimeMs = Math.max(lowestLevelMaxValidBucketEndTimeMs, currentValidBucketEndTimeMs);
                    }
                    this._tableLowestLevelMaxValidBucketEndTimeMs.put(tableNameWithType, lowestLevelMaxValidBucketEndTimeMs);
                }
                this.createOrUpdateDelayMetrics(tableNameWithType, mergeLevel, null, watermarkMs, bufferMs, bucketMs);
                if (!this.isValidBucketEndTime(bucketEndMs, bufferMs, lowerMergeLevel, mergeRollupTaskMetadata)) {
                    LOGGER.info("Bucket with start: {} and end: {} (table : {}, mergeLevel : {}) cannot be merged yet", new Object[]{bucketStartMs, bucketEndMs, tableNameWithType, mergeLevel});
                    continue;
                }
                ArrayList selectedSegmentsForAllBuckets = new ArrayList(maxNumParallelBuckets);
                ArrayList<SegmentZKMetadata> selectedSegmentsForBucket = new ArrayList<SegmentZKMetadata>();
                boolean hasUnmergedSegments = false;
                boolean hasSpilledOverData = false;
                for (SegmentZKMetadata preSelectedSegment : preSelectedSegments) {
                    long startTimeMs = preSelectedSegment.getStartTimeMs();
                    if (startTimeMs < bucketEndMs) {
                        long endTimeMs = preSelectedSegment.getEndTimeMs();
                        if (endTimeMs < bucketStartMs) continue;
                        if (!this.isMergedSegment(preSelectedSegment, mergeLevel)) {
                            hasUnmergedSegments = true;
                        }
                        if (this.hasSpilledOverData(preSelectedSegment, bucketMs)) {
                            hasSpilledOverData = true;
                        }
                        selectedSegmentsForBucket.add(preSelectedSegment);
                        continue;
                    }
                    if (hasUnmergedSegments) {
                        selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
                    }
                    if (selectedSegmentsForAllBuckets.size() == maxNumParallelBuckets || hasSpilledOverData) break;
                    selectedSegmentsForBucket = new ArrayList();
                    hasUnmergedSegments = false;
                    bucketStartMs = startTimeMs / bucketMs * bucketMs;
                    bucketEndMs = bucketStartMs + bucketMs;
                    if (!this.isValidBucketEndTime(bucketEndMs, bufferMs, lowerMergeLevel, mergeRollupTaskMetadata)) break;
                    if (!this.isMergedSegment(preSelectedSegment, mergeLevel)) {
                        hasUnmergedSegments = true;
                    }
                    if (this.hasSpilledOverData(preSelectedSegment, bucketMs)) {
                        hasSpilledOverData = true;
                    }
                    selectedSegmentsForBucket.add(preSelectedSegment);
                }
                if (hasUnmergedSegments && (selectedSegmentsForAllBuckets.isEmpty() || selectedSegmentsForAllBuckets.get(selectedSegmentsForAllBuckets.size() - 1) != selectedSegmentsForBucket)) {
                    selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
                }
                if (selectedSegmentsForAllBuckets.isEmpty()) {
                    LOGGER.info("No unmerged segment found for table: {}, mergeLevel: {}", (Object)tableNameWithType, (Object)mergeLevel);
                    continue;
                }
                long newWatermarkMs = ((SegmentZKMetadata)((List)selectedSegmentsForAllBuckets.get(0)).get(0)).getStartTimeMs() / bucketMs * bucketMs;
                mergeRollupTaskMetadata.getWatermarkMap().put(mergeLevel, newWatermarkMs);
                LOGGER.info("Update watermark for table: {}, mergeLevel: {} from: {} to: {}", new Object[]{tableNameWithType, mergeLevel, watermarkMs, newWatermarkMs});
                this.createOrUpdateDelayMetrics(tableNameWithType, mergeLevel, lowerMergeLevel, newWatermarkMs, bufferMs, bucketMs);
                int maxNumRecordsPerTask = mergeConfigs.get("maxNumRecordsPerTask") != null ? Integer.parseInt((String)mergeConfigs.get("maxNumRecordsPerTask")) : 50000000;
                SegmentPartitionConfig segmentPartitionConfig = tableConfig.getIndexingConfig().getSegmentPartitionConfig();
                if (segmentPartitionConfig == null) {
                    for (List list : selectedSegmentsForAllBuckets) {
                        pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(list, tableNameWithType, maxNumRecordsPerTask, mergeLevel, null, mergeConfigs, map));
                    }
                    continue;
                }
                Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
                ArrayList arrayList = new ArrayList(columnPartitionMap.keySet());
                for (List list : selectedSegmentsForAllBuckets) {
                    HashMap<List, List> partitionToSegments = new HashMap<List, List>();
                    ArrayList<SegmentZKMetadata> outlierSegments = new ArrayList<SegmentZKMetadata>();
                    for (SegmentZKMetadata segmentZKMetadata : list) {
                        SegmentPartitionMetadata segmentPartitionMetadata = segmentZKMetadata.getPartitionMetadata();
                        ArrayList<Integer> partitions = new ArrayList<Integer>();
                        if (segmentPartitionMetadata != null && columnPartitionMap.keySet().equals(segmentPartitionMetadata.getColumnPartitionMap().keySet())) {
                            for (String partitionColumn : arrayList) {
                                if (segmentPartitionMetadata.getPartitions(partitionColumn).size() == 1) {
                                    partitions.add((Integer)segmentPartitionMetadata.getPartitions(partitionColumn).iterator().next());
                                    continue;
                                }
                                partitions.clear();
                                break;
                            }
                        }
                        if (partitions.isEmpty()) {
                            outlierSegments.add(segmentZKMetadata);
                            continue;
                        }
                        partitionToSegments.computeIfAbsent(partitions, k -> new ArrayList()).add(segmentZKMetadata);
                    }
                    for (Map.Entry entry2 : partitionToSegments.entrySet()) {
                        List partition = (List)entry2.getKey();
                        List partitionedSegments = (List)entry2.getValue();
                        pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(partitionedSegments, tableNameWithType, maxNumRecordsPerTask, mergeLevel, partition, mergeConfigs, map));
                    }
                    if (outlierSegments.isEmpty()) continue;
                    pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(outlierSegments, tableNameWithType, maxNumRecordsPerTask, mergeLevel, null, mergeConfigs, map));
                }
            }
            try {
                this._clusterInfoAccessor.setMinionTaskMetadata((BaseTaskMetadata)mergeRollupTaskMetadata, "MergeRollupTask", expectedVersion);
            }
            catch (ZkException e2) {
                LOGGER.error("Version changed while updating merge/rollup task metadata for table: {}, skip scheduling. There are multiple task schedulers for the same table, need to investigate!", (Object)tableNameWithType);
                continue;
            }
            pinotTaskConfigs.addAll(pinotTaskConfigsForTable);
            LOGGER.info("Finished generating task configs for table: {} for task: {}, numTasks: {}", new Object[]{tableNameWithType, taskType, pinotTaskConfigsForTable.size()});
        }
        this.cleanUpDelayMetrics(tableConfigs);
        return pinotTaskConfigs;
    }

    @VisibleForTesting
    static List<SegmentZKMetadata> filterSegmentsBasedOnStatus(TableType tableType, List<SegmentZKMetadata> allSegments) {
        if (tableType == TableType.REALTIME) {
            long earliestStartTimeMsOfInProgressSegments = Long.MAX_VALUE;
            for (SegmentZKMetadata segmentZKMetadata2 : allSegments) {
                if (segmentZKMetadata2.getStatus().isCompleted() || segmentZKMetadata2.getTotalDocs() <= 0L || segmentZKMetadata2.getStartTimeMs() >= earliestStartTimeMsOfInProgressSegments) continue;
                earliestStartTimeMsOfInProgressSegments = segmentZKMetadata2.getStartTimeMs();
            }
            long finalEarliestStartTimeMsOfInProgressSegments = earliestStartTimeMsOfInProgressSegments;
            return allSegments.stream().filter(segmentZKMetadata -> segmentZKMetadata.getStatus().isCompleted() && segmentZKMetadata.getStartTimeMs() < finalEarliestStartTimeMsOfInProgressSegments).collect(Collectors.toList());
        }
        return allSegments;
    }

    @VisibleForTesting
    static boolean validate(TableConfig tableConfig, String taskType) {
        String tableNameWithType = tableConfig.getTableName();
        if (REFRESH.equalsIgnoreCase(IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig))) {
            LOGGER.warn("Skip generating task: {} for non-APPEND table: {}, REFRESH table is not supported", (Object)taskType, (Object)tableNameWithType);
            return false;
        }
        if (tableConfig.getTableType() == TableType.REALTIME) {
            if (tableConfig.isUpsertEnabled()) {
                LOGGER.warn("Skip generating task: {} for table: {}, table with upsert enabled is not supported", (Object)taskType, (Object)tableNameWithType);
                return false;
            }
            if (tableConfig.isDedupEnabled()) {
                LOGGER.warn("Skip generating task: {} for table: {}, table with dedup enabled is not supported", (Object)taskType, (Object)tableNameWithType);
                return false;
            }
        }
        return true;
    }

    private long getValidBucketEndTimeMsForSegment(SegmentZKMetadata segmentZKMetadata, long bucketMs, long bufferMs) {
        long currentTimeMs = System.currentTimeMillis();
        long firstBucketEndTimeMs = segmentZKMetadata.getStartTimeMs() / bucketMs * bucketMs + bucketMs;
        if (firstBucketEndTimeMs > currentTimeMs - bufferMs) {
            return Long.MIN_VALUE;
        }
        long validBucketEndTimeMs = (segmentZKMetadata.getEndTimeMs() / bucketMs + 1L) * bucketMs;
        validBucketEndTimeMs = Math.min(validBucketEndTimeMs, (currentTimeMs - bufferMs) / bucketMs * bucketMs);
        return validBucketEndTimeMs;
    }

    private boolean hasSpilledOverData(SegmentZKMetadata segmentZKMetadata, long bucketMs) {
        return segmentZKMetadata.getStartTimeMs() / bucketMs < segmentZKMetadata.getEndTimeMs() / bucketMs;
    }

    private boolean isMergedSegment(SegmentZKMetadata segmentZKMetadata, String mergeLevel) {
        Map customMap = segmentZKMetadata.getCustomMap();
        return customMap != null && mergeLevel.equalsIgnoreCase((String)customMap.get("MergeRollupTask.mergeLevel"));
    }

    private boolean isValidBucketEndTime(long bucketEndMs, long bufferMs, @Nullable String lowerMergeLevel, MergeRollupTaskMetadata mergeRollupTaskMetadata) {
        if (bucketEndMs > System.currentTimeMillis() - bufferMs) {
            return false;
        }
        if (lowerMergeLevel != null) {
            Long lowerMergeLevelWatermarkMs = (Long)mergeRollupTaskMetadata.getWatermarkMap().get(lowerMergeLevel);
            return lowerMergeLevelWatermarkMs != null && bucketEndMs <= lowerMergeLevelWatermarkMs;
        }
        return true;
    }

    private long getWatermarkMs(long minStartTimeMs, long bucketMs, String mergeLevel, MergeRollupTaskMetadata mergeRollupTaskMetadata) {
        long watermarkMs = mergeRollupTaskMetadata.getWatermarkMap().get(mergeLevel) == null ? minStartTimeMs / bucketMs * bucketMs : (Long)mergeRollupTaskMetadata.getWatermarkMap().get(mergeLevel);
        return watermarkMs;
    }

    private List<PinotTaskConfig> createPinotTaskConfigs(List<SegmentZKMetadata> selectedSegments, String tableNameWithType, int maxNumRecordsPerTask, String mergeLevel, List<Integer> partition, Map<String, String> mergeConfigs, Map<String, String> taskConfigs) {
        int numRecordsPerTask = 0;
        ArrayList segmentNamesList = new ArrayList();
        ArrayList downloadURLsList = new ArrayList();
        ArrayList<String> segmentNames = new ArrayList<String>();
        ArrayList<String> downloadURLs = new ArrayList<String>();
        for (int i = 0; i < selectedSegments.size(); ++i) {
            SegmentZKMetadata targetSegment = selectedSegments.get(i);
            segmentNames.add(targetSegment.getSegmentName());
            downloadURLs.add(targetSegment.getDownloadUrl());
            numRecordsPerTask = (int)((long)numRecordsPerTask + targetSegment.getTotalDocs());
            if (numRecordsPerTask < maxNumRecordsPerTask && i != selectedSegments.size() - 1) continue;
            segmentNamesList.add(segmentNames);
            downloadURLsList.add(downloadURLs);
            numRecordsPerTask = 0;
            segmentNames = new ArrayList();
            downloadURLs = new ArrayList();
        }
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        StringBuilder partitionSuffixBuilder = new StringBuilder();
        if (partition != null && !partition.isEmpty()) {
            for (int columnPartition : partition) {
                partitionSuffixBuilder.append(DELIMITER_IN_SEGMENT_NAME).append(columnPartition);
            }
        }
        String partitionSuffix = partitionSuffixBuilder.toString();
        for (int i = 0; i < segmentNamesList.size(); ++i) {
            String downloadURL = StringUtils.join((Iterable)((Iterable)downloadURLsList.get(i)), (String)",");
            Map<String, String> configs = MinionTaskUtils.getPushTaskConfig(tableNameWithType, taskConfigs, this._clusterInfoAccessor);
            configs.put("tableName", tableNameWithType);
            configs.put("segmentName", StringUtils.join((Iterable)((Iterable)segmentNamesList.get(i)), (String)","));
            configs.put("downloadURL", downloadURL);
            configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
            configs.put("enableReplaceSegments", "true");
            for (Map.Entry<String, String> taskConfig : taskConfigs.entrySet()) {
                if (!taskConfig.getKey().endsWith(".aggregationType")) continue;
                configs.put(taskConfig.getKey(), taskConfig.getValue());
            }
            configs.put("overwriteOutput", taskConfigs.getOrDefault("overwriteOutput", "false"));
            configs.put("mergeType", mergeConfigs.get("mergeType"));
            configs.put("mergeLevel", mergeLevel);
            configs.put("partitionBucketTimePeriod", mergeConfigs.get("bucketTimePeriod"));
            configs.put("roundBucketTimePeriod", mergeConfigs.get("roundBucketTimePeriod"));
            configs.put("maxNumRecordsPerSegment", mergeConfigs.get("maxNumRecordsPerSegment"));
            configs.put("segmentNamePrefix", "merged_" + mergeLevel + DELIMITER_IN_SEGMENT_NAME + System.currentTimeMillis() + partitionSuffix + DELIMITER_IN_SEGMENT_NAME + i + DELIMITER_IN_SEGMENT_NAME + TableNameBuilder.extractRawTableName((String)tableNameWithType));
            pinotTaskConfigs.add(new PinotTaskConfig("MergeRollupTask", configs));
        }
        return pinotTaskConfigs;
    }

    private long getMergeRollupTaskDelayInNumTimeBuckets(long watermarkMs, long maxEndTimeMsOfCurrentLevel, long bufferTimeMs, long bucketTimeMs) {
        if (watermarkMs == -1L || maxEndTimeMsOfCurrentLevel == Long.MIN_VALUE) {
            return 0L;
        }
        return (Math.min(System.currentTimeMillis() - bufferTimeMs, maxEndTimeMsOfCurrentLevel) - watermarkMs) / bucketTimeMs;
    }

    private void createOrUpdateDelayMetrics(String tableNameWithType, String mergeLevel, String lowerMergeLevel, long watermarkMs, long bufferTimeMs, long bucketTimeMs) {
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map watermarkForTable = this._mergeRollupWatermarks.computeIfAbsent(tableNameWithType, k -> new ConcurrentHashMap());
        watermarkForTable.compute(mergeLevel, (k, v) -> {
            if (v == null) {
                LOGGER.info("Creating the gauge metric for tracking the merge/roll-up task delay for table: {} and mergeLevel: {}.(watermarkMs={}, bufferTimeMs={}, bucketTimeMs={}, taskDelayInNumTimeBuckets={})", new Object[]{tableNameWithType, mergeLevel, watermarkMs, bufferTimeMs, bucketTimeMs, this.getMergeRollupTaskDelayInNumTimeBuckets(watermarkMs, lowerMergeLevel == null ? this._tableLowestLevelMaxValidBucketEndTimeMs.get(tableNameWithType) : (Long)watermarkForTable.get(lowerMergeLevel), bufferTimeMs, bucketTimeMs)});
                controllerMetrics.addCallbackGaugeIfNeeded(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel), () -> this.getMergeRollupTaskDelayInNumTimeBuckets(watermarkForTable.getOrDefault(k, -1L), lowerMergeLevel == null ? this._tableLowestLevelMaxValidBucketEndTimeMs.get(tableNameWithType) : (Long)watermarkForTable.get(lowerMergeLevel), bufferTimeMs, bucketTimeMs));
            }
            return watermarkMs;
        });
    }

    private void resetDelayMetrics(String tableNameWithType) {
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map<String, Long> watermarksForTable = this._mergeRollupWatermarks.remove(tableNameWithType);
        if (watermarksForTable != null) {
            for (String mergeLevel : watermarksForTable.keySet()) {
                controllerMetrics.removeGauge(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel));
            }
        }
    }

    private void resetDelayMetrics(String tableNameWithType, String mergeLevel) {
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map<String, Long> watermarksForTable = this._mergeRollupWatermarks.get(tableNameWithType);
        if (watermarksForTable != null && watermarksForTable.remove(mergeLevel) != null) {
            controllerMetrics.removeGauge(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel));
        }
    }

    private void cleanUpDelayMetrics(List<TableConfig> tableConfigs) {
        HashMap<String, TableConfig> tableConfigMap = new HashMap<String, TableConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            tableConfigMap.put(tableConfig.getTableName(), tableConfig);
        }
        for (String tableNameWithType : new ArrayList<String>(this._mergeRollupWatermarks.keySet())) {
            TableConfig currentTableConfig = (TableConfig)tableConfigMap.get(tableNameWithType);
            if (currentTableConfig == null) {
                this.resetDelayMetrics(tableNameWithType);
                continue;
            }
            if (!this._clusterInfoAccessor.getLeaderControllerManager().isLeaderForTable(tableNameWithType)) {
                this.resetDelayMetrics(tableNameWithType);
                continue;
            }
            Map taskConfigs = currentTableConfig.getTaskConfig().getConfigsForTaskType(this.getTaskType());
            Map<String, Map<String, String>> mergeLevelToConfigs = MergeRollupTaskUtils.getLevelToConfigMap(taskConfigs);
            Map<String, Long> tableToWatermark = this._mergeRollupWatermarks.get(tableNameWithType);
            for (String mergeLevel : tableToWatermark.keySet()) {
                if (mergeLevelToConfigs.containsKey(mergeLevel)) continue;
                this.resetDelayMetrics(tableNameWithType, mergeLevel);
            }
        }
    }

    private String getMetricNameForTaskDelay(String tableNameWithType, String mergeLevel) {
        return "mergeRollupTaskDelayInNumBuckets." + tableNameWithType + "." + mergeLevel;
    }
}

