/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorFramework;
import org.apache.pinot.minion.MinionConf;
import org.apache.pinot.plugin.minion.tasks.BaseMultipleSegmentsConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.MergeTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRollupTaskExecutor
extends BaseMultipleSegmentsConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeRollupTaskExecutor.class);

    public MergeRollupTaskExecutor(MinionConf minionConf) {
        super(minionConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SegmentConversionResult> convert(PinotTaskConfig pinotTaskConfig, List<File> segmentDirs, File workingDir) throws Exception {
        List outputSegmentDirs;
        int numInputSegments = segmentDirs.size();
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Converting segments: " + numInputSegments));
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        LOGGER.info("Starting task: {} with configs: {}", (Object)taskType, (Object)configs);
        long startMillis = System.currentTimeMillis();
        String tableNameWithType = (String)configs.get("tableName");
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        Schema schema = this.getSchema(tableNameWithType);
        SegmentProcessorConfig.Builder segmentProcessorConfigBuilder = new SegmentProcessorConfig.Builder().setTableConfig(tableConfig).setSchema(schema);
        segmentProcessorConfigBuilder.setTimeHandlerConfig(MergeTaskUtils.getTimeHandlerConfig(tableConfig, schema, configs));
        segmentProcessorConfigBuilder.setPartitionerConfigs(MergeTaskUtils.getPartitionerConfigs(tableConfig, schema, configs));
        segmentProcessorConfigBuilder.setMergeType(MergeTaskUtils.getMergeType(configs));
        segmentProcessorConfigBuilder.setAggregationTypes(MergeTaskUtils.getAggregationTypes(configs));
        segmentProcessorConfigBuilder.setSegmentConfig(MergeTaskUtils.getSegmentConfig(configs));
        segmentProcessorConfigBuilder.setProgressObserver(p -> this._eventObserver.notifyProgress(this._pinotTaskConfig, p));
        SegmentProcessorConfig segmentProcessorConfig = segmentProcessorConfigBuilder.build();
        ArrayList<RecordReader> recordReaders = new ArrayList<RecordReader>(numInputSegments);
        int count = 1;
        for (File file : segmentDirs) {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)String.format("Creating RecordReader for: %s (%d out of %d)", file, count++, numInputSegments));
            RecordReader recordReader = new PinotSegmentRecordReader();
            recordReader.init(file, null, null, true);
            recordReaders.add(recordReader);
        }
        try {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)"Generating segments");
            outputSegmentDirs = new SegmentProcessorFramework(recordReaders, segmentProcessorConfig, workingDir).process();
        }
        finally {
            for (RecordReader recordReader : recordReaders) {
                recordReader.close();
            }
        }
        long l = System.currentTimeMillis();
        LOGGER.info("Finished task: {} with configs: {}. Total time: {}ms", new Object[]{taskType, configs, l - startMillis});
        ArrayList<SegmentConversionResult> results = new ArrayList<SegmentConversionResult>();
        for (File outputSegmentDir : outputSegmentDirs) {
            String outputSegmentName = outputSegmentDir.getName();
            results.add(new SegmentConversionResult.Builder().setFile(outputSegmentDir).setSegmentName(outputSegmentName).setTableNameWithType(tableNameWithType).build());
        }
        return results;
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        TreeMap<String, String> updateMap = new TreeMap<String, String>();
        updateMap.put("MergeRollupTask.mergeLevel", (String)pinotTaskConfig.getConfigs().get("mergeLevel"));
        updateMap.put("MergeRollupTask.time", String.valueOf(System.currentTimeMillis()));
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, updateMap);
    }
}

