/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.converttorawindex;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.lineage.SegmentLineageUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class ConvertToRawIndexTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertToRawIndexTaskGenerator.class);

    public String getTaskType() {
        return "ConvertToRawIndexTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        Set runningSegments = TaskGeneratorUtils.getRunningSegments((String)"ConvertToRawIndexTask", (ClusterInfoAccessor)this._clusterInfoAccessor);
        block2: for (TableConfig tableConfig : tableConfigs) {
            int tableMaxNumTasks;
            String offlineTableName = tableConfig.getTableName();
            if (tableConfig.getTableType() != TableType.OFFLINE) {
                LOGGER.warn("Skip generating ConvertToRawIndexTask for non-OFFLINE table: {}", (Object)offlineTableName);
                continue;
            }
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            Preconditions.checkNotNull((Object)tableTaskConfig);
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType("ConvertToRawIndexTask");
            Preconditions.checkNotNull((Object)taskConfigs, (String)"Task config shouldn't be null for Table: {}", (Object)offlineTableName);
            String tableMaxNumTasksConfig = (String)taskConfigs.get("tableMaxNumTasks");
            if (tableMaxNumTasksConfig != null) {
                try {
                    tableMaxNumTasks = Integer.parseInt(tableMaxNumTasksConfig);
                }
                catch (Exception e) {
                    tableMaxNumTasks = Integer.MAX_VALUE;
                }
            } else {
                tableMaxNumTasks = Integer.MAX_VALUE;
            }
            String columnsToConvertConfig = (String)taskConfigs.get("columnsToConvert");
            List offlineSegmentsZKMetadata = this._clusterInfoAccessor.getSegmentsZKMetadata(offlineTableName);
            SegmentLineage segmentLineage = this._clusterInfoAccessor.getSegmentLineage(offlineTableName);
            HashSet<String> preSelectedSegmentsBasedOnLineage = new HashSet<String>();
            for (SegmentZKMetadata offlineSegmentZKMetadata : offlineSegmentsZKMetadata) {
                preSelectedSegmentsBasedOnLineage.add(offlineSegmentZKMetadata.getSegmentName());
            }
            SegmentLineageUtils.filterSegmentsBasedOnLineageInPlace(preSelectedSegmentsBasedOnLineage, (SegmentLineage)segmentLineage);
            int tableNumTasks = 0;
            for (SegmentZKMetadata segmentZKMetadata : offlineSegmentsZKMetadata) {
                Map customMap;
                if (tableNumTasks == tableMaxNumTasks) continue block2;
                String segmentName = segmentZKMetadata.getSegmentName();
                if (runningSegments.contains(new Segment(offlineTableName, segmentName)) || !preSelectedSegmentsBasedOnLineage.contains(segmentName) || (customMap = segmentZKMetadata.getCustomMap()) != null && customMap.containsKey("columnsToConvert.time")) continue;
                HashMap<String, Object> configs = new HashMap<String, Object>();
                configs.put("tableName", offlineTableName);
                configs.put("segmentName", segmentName);
                configs.put("downloadURL", segmentZKMetadata.getDownloadUrl());
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("crc", String.valueOf(segmentZKMetadata.getCrc()));
                if (columnsToConvertConfig != null) {
                    configs.put("columnsToConvert", columnsToConvertConfig);
                }
                pinotTaskConfigs.add(new PinotTaskConfig("ConvertToRawIndexTask", configs));
                ++tableNumTasks;
            }
        }
        return pinotTaskConfigs;
    }
}

