/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.converttorawindex;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.minion.RawIndexConverter;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.segment.spi.creator.ForwardIndexCreatorProvider;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class ConvertToRawIndexTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Converting segment: " + indexDir));
        new RawIndexConverter(rawTableName, indexDir, workingDir, (String)configs.get("columnsToConvert"), (ForwardIndexCreatorProvider)IndexingOverrides.getIndexCreatorProvider()).convert();
        return new SegmentConversionResult.Builder().setFile(workingDir).setTableNameWithType((String)configs.get("tableName")).setSegmentName((String)configs.get("segmentName")).build();
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("ConvertToRawIndexTask.time", String.valueOf(System.currentTimeMillis())));
    }
}

