/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.event.MinionEventObserver;
import org.apache.pinot.minion.event.MinionEventObservers;
import org.apache.pinot.minion.exception.TaskCancelledException;
import org.apache.pinot.plugin.minion.tasks.BaseTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionUtils;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSingleSegmentConversionExecutor
extends BaseTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSingleSegmentConversionExecutor.class);
    protected PinotTaskConfig _pinotTaskConfig;
    protected MinionEventObserver _eventObserver;

    protected abstract SegmentConversionResult convert(PinotTaskConfig var1, File var2, File var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentConversionResult executeTask(PinotTaskConfig pinotTaskConfig) throws Exception {
        this._pinotTaskConfig = pinotTaskConfig;
        this._eventObserver = MinionEventObservers.getInstance().getMinionEventObserver(pinotTaskConfig.getTaskId());
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String segmentName = (String)configs.get("segmentName");
        String downloadURL = (String)configs.get("downloadURL");
        String uploadURL = (String)configs.get("uploadURL");
        String originalSegmentCrc = (String)configs.get("crc");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
        long currentSegmentCrc = this.getSegmentCrc(tableNameWithType, segmentName);
        if (Long.parseLong(originalSegmentCrc) != currentSegmentCrc) {
            LOGGER.info("Segment CRC does not match, skip the task. Original CRC: {}, current CRC: {}", (Object)originalSegmentCrc, (Object)currentSegmentCrc);
            return new SegmentConversionResult.Builder().setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        }
        LOGGER.info("Start executing {} on table: {}, segment: {} with downloadURL: {}, uploadURL: {}", new Object[]{taskType, tableNameWithType, segmentName, downloadURL, uploadURL});
        File tempDataDir = new File(new File(MINION_CONTEXT.getDataDir(), taskType), "tmp-" + UUID.randomUUID());
        Preconditions.checkState((boolean)tempDataDir.mkdirs(), (String)"Failed to create temporary directory: %s", (Object)tempDataDir);
        String crypterName = this.getTableConfig(tableNameWithType).getValidationConfig().getCrypterClassName();
        try {
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Downloading segment from: " + downloadURL));
            File tarredSegmentFile = new File(tempDataDir, "tarredSegment");
            LOGGER.info("Downloading segment from {} to {}", (Object)downloadURL, (Object)tarredSegmentFile.getAbsolutePath());
            SegmentFetcherFactory.fetchAndDecryptSegmentToLocal((String)downloadURL, (File)tarredSegmentFile, (String)crypterName);
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Decompressing segment from: " + downloadURL));
            File segmentDir = new File(tempDataDir, "segmentDir");
            File indexDir = (File)TarGzCompressionUtils.untar((File)tarredSegmentFile, (File)segmentDir).get(0);
            if (!FileUtils.deleteQuietly((File)tarredSegmentFile)) {
                LOGGER.warn("Failed to delete tarred input segment: {}", (Object)tarredSegmentFile.getAbsolutePath());
            }
            File workingDir = new File(tempDataDir, "workingDir");
            Preconditions.checkState((boolean)workingDir.mkdir());
            SegmentConversionResult segmentConversionResult = this.convert(pinotTaskConfig, indexDir, workingDir);
            Preconditions.checkState((boolean)segmentConversionResult.getSegmentName().equals(segmentName), (String)"Converted segment name: %s does not match original segment name: %s", (Object)segmentConversionResult.getSegmentName(), (Object)segmentName);
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Compressing segment: " + segmentName));
            File convertedSegmentDir = segmentConversionResult.getFile();
            File convertedTarredSegmentFile = new File(tempDataDir, segmentName + ".tar.gz");
            TarGzCompressionUtils.createTarGzFile((File)convertedSegmentDir, (File)convertedTarredSegmentFile);
            if (!FileUtils.deleteQuietly((File)convertedSegmentDir)) {
                LOGGER.warn("Failed to delete converted segment: {}", (Object)convertedSegmentDir.getAbsolutePath());
            }
            if (indexDir.exists() && !FileUtils.deleteQuietly((File)indexDir)) {
                LOGGER.warn("Failed to delete input segment: {}", (Object)indexDir.getAbsolutePath());
            }
            if (this._cancelled) {
                LOGGER.info("{} on table: {}, segment: {} got cancelled", new Object[]{taskType, tableNameWithType, segmentName});
                throw new TaskCancelledException(taskType + " on table: " + tableNameWithType + ", segment: " + segmentName + " got cancelled");
            }
            BasicHeader ifMatchHeader = new BasicHeader("If-Match", originalSegmentCrc);
            BasicHeader refreshOnlyHeader = new BasicHeader("REFRESH_ONLY", "true");
            SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = this.getSegmentZKMetadataCustomMapModifier(pinotTaskConfig, segmentConversionResult);
            BasicHeader segmentZKMetadataCustomMapModifierHeader = new BasicHeader("Pinot-SegmentZKMetadataCustomMapModifier", segmentZKMetadataCustomMapModifier.toJsonString());
            ArrayList<Header> httpHeaders = new ArrayList<Header>();
            httpHeaders.add((Header)ifMatchHeader);
            httpHeaders.add((Header)refreshOnlyHeader);
            httpHeaders.add((Header)segmentZKMetadataCustomMapModifierHeader);
            httpHeaders.addAll(AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider));
            BasicNameValuePair enableParallelPushProtectionParameter = new BasicNameValuePair("enableParallelPushProtection", "true");
            BasicNameValuePair tableNameParameter = new BasicNameValuePair("tableName", TableNameBuilder.extractRawTableName((String)tableNameWithType));
            BasicNameValuePair tableTypeParameter = new BasicNameValuePair("tableType", TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType).toString());
            List<NameValuePair> parameters = Arrays.asList(enableParallelPushProtectionParameter, tableNameParameter, tableTypeParameter);
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Uploading segment: " + segmentName));
            SegmentConversionUtils.uploadSegment(configs, httpHeaders, parameters, tableNameWithType, segmentName, uploadURL, convertedTarredSegmentFile);
            if (!FileUtils.deleteQuietly((File)convertedTarredSegmentFile)) {
                LOGGER.warn("Failed to delete tarred converted segment: {}", (Object)convertedTarredSegmentFile.getAbsolutePath());
            }
            LOGGER.info("Done executing {} on table: {}, segment: {}", new Object[]{taskType, tableNameWithType, segmentName});
            SegmentConversionResult segmentConversionResult2 = segmentConversionResult;
            return segmentConversionResult2;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDataDir);
        }
    }

    @VisibleForTesting
    public void setMinionEventObserver(MinionEventObserver observer) {
        this._eventObserver = observer;
    }
}

